/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif
#ifdef ENABLE_MP3

#include "../../player.h"
#include "../../other.h"
#include "../../output.h"
#include "mp3.h"

void
mp3_run (void)
{
  struct mad_decoder decoder;
  void *buf;
  format_data_mp3 *mp3 = (format_data_mp3 *) play->format_current->data;

  if (!mp3)
    return;

  play->play = 0;

  mp3->frame = 0;
  mp3->n_frames = 0;

  if (!(buf = malloc (SIZE_BUFFER)))
    fatal (_("Error: memory."));

  mad_timer_reset (&mp3->mad_time);

#ifdef ENABLE_ID3
#ifdef ENABLE_OPENSSL
  if (!play->secure)
#endif
    id3_read (play->fd);
#endif

  mad_decoder_init (&decoder, buf, read_file, read_header, 0,
		    mad_write, 0, 0);

  mad_decoder_run (&decoder, MAD_DECODER_MODE_SYNC);

  output_close ();
  play->play = 0;

  mad_decoder_finish (&decoder);

  free (buf);
}

char *
mp3_get_time (void)
{

  static char output[25];
  format_data_mp3 *mp3 = (format_data_mp3 *) play->format_current->data;
  int ret;
  mad_timer_t end_time;

  if (!mp3)
    return NULL;

  mad_timer_string (mp3->mad_time, output, "T: %.2u:%.2u.%.2u ",
		    MAD_UNITS_MINUTES, MAD_UNITS_CENTISECONDS, 0);

  if (!mad_timer_compare (mp3->mad_duration, mad_timer_zero) || play->remote)
    end_time = mp3->mad_time;
  else
    {
      end_time = mp3->mad_duration;

      mad_timer_negate (&mp3->mad_time);
      mad_timer_add (&end_time, mp3->mad_time);
      mad_timer_negate (&mp3->mad_time);
    }

  ret = strlen (output);

  mad_timer_string (end_time, output + ret, "[%.2u:%.2u.%.2u] ",
		    MAD_UNITS_MINUTES, MAD_UNITS_CENTISECONDS, 0);

  return output;
}

char *
mp3_get_name (char *file)
{
#ifdef ENABLE_ID3
  struct id3_file *id3_struct = NULL;
  struct id3_tag *id3_tag = NULL;
  char *str;
  char buf[1024];
  int len = 0;

  id3_struct = id3_file_open (file, ID3_FILE_MODE_READONLY);

  if (!id3_struct)
    return NULL;

  if (!(id3_tag = id3_file_tag (id3_struct)))
    {
      free (id3_struct);
      return NULL;
    }

  if (!(str = id3_show (id3_tag, ID3_FRAME_ARTIST)))
    {
      free (id3_struct);
      return NULL;
    }

  len = snprintf (buf, 1024, "%s", str);
  free (str);

  if ((str = id3_show (id3_tag, ID3_FRAME_TITLE)))
    {
      len = snprintf (buf + len, 1024 - len, " - %s", str);
      free (str);
    }

  free (id3_struct);

  return strdup(buf);
#else
  return NULL;
#endif
}

#endif
