/*
 * Decompiled with CFR 0.152.
 */
package fr.loria.smarteiffel;

import fr.loria.smarteiffel.SmartEiffelRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartEiffelBasicIo {
    public static Object basic_io_stdin() {
        return System.in;
    }

    public static Object basic_io_stdout() {
        return System.out;
    }

    public static Object basic_io_stderr() {
        return System.err;
    }

    public static int basic_io_eof() {
        return -1;
    }

    public static Object basic_io_binary_file_read_open(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        File file = new File(string);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static Object basic_io_binary_file_write_open(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        File file = new File(string);
        try {
            return new FileOutputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object basic_io_binary_file_write_append(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        try {
            return new FileOutputStream(string, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object basic_io_text_file_read_open(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        File file = new File(string);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static Object basic_io_text_file_write_open(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        File file = new File(string);
        try {
            return new FileOutputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object basic_io_text_file_write_append(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        try {
            return new FileOutputStream(string, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object basic_io_text_file_read_write_open(Object object) {
        RandomAccessFile randomAccessFile;
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        try {
            randomAccessFile = new RandomAccessFile(string, "rw");
        }
        catch (IOException iOException) {
            return null;
        }
        return randomAccessFile;
    }

    public static Object basic_io_text_file_read_write_append(Object object) {
        RandomAccessFile randomAccessFile;
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        try {
            randomAccessFile = new RandomAccessFile(string, "rw");
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            long l = randomAccessFile.length();
            randomAccessFile.seek(l);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return randomAccessFile;
    }

    public static boolean basic_io_feof(Object object) {
        boolean bl = false;
        try {
            long l = ((RandomAccessFile)object).getFilePointer();
            long l2 = ((RandomAccessFile)object).length();
            if (l == l2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static void basic_io_rename(Object object, Object object2) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        String string2 = SmartEiffelRuntime.NullTerminatedBytesToString(object2);
        File file = new File(string);
        File file2 = new File(string2);
        file.renameTo(file2);
    }

    public static void basic_io_remove(Object object) {
        String string = SmartEiffelRuntime.NullTerminatedBytesToString(object);
        File file = new File(string);
        file.delete();
    }

    public static void basic_io_fclose(Object object) {
        try {
            ((InputStream)object).close();
            return;
        }
        catch (Exception exception) {
            try {
                ((OutputStream)object).close();
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public static int basic_io_getc(Object object) {
        try {
            return ((InputStream)object).read();
        }
        catch (IOException iOException) {
            return -1;
        }
        catch (ClassCastException classCastException) {
            try {
                return ((RandomAccessFile)object).read();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
    }

    public static void basic_io_putc(byte by, Object object) {
        try {
            ((OutputStream)object).write(by);
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                ((RandomAccessFile)object).write(by);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public static void basic_io_flush(Object object) {
        try {
            ((PrintStream)object).flush();
            return;
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    public static int basic_io_read_stdin(byte[] byArray, int n) {
        try {
            return System.in.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static int basic_io_fread(byte[] byArray, int n, Object object) {
        try {
            return ((InputStream)object).read(byArray, 0, n);
        }
        catch (IOException iOException) {
            return -1;
        }
        catch (ClassCastException classCastException) {
            try {
                return ((RandomAccessFile)object).read(byArray, 0, n);
            }
            catch (IOException iOException) {
                return -1;
            }
        }
    }

    public static void basic_io_fwrite(byte[] byArray, int n, Object object) {
        try {
            ((OutputStream)object).write(byArray, 0, n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                ((RandomAccessFile)object).write(byArray, 0, n);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

