/*
    This file is part of the sly ident daemon (slidentd).
   slidentd was written by Sean Hunter <sean@uncarved.com> as a minimal
    RFC1413 (ident) daemon.

   slidentd is copyright (c) 2001 Uncarved Systems Ltd.

   slidentd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

   slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along withslidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef SLIDENTD_H
#define SLIDENTD_H

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>

#include "slid_config.h"
#include "slid_log.h"
#include "slid_die.h"
#include "slid_random.h"
#include "slid_tcptable.h"
#include "slid_get_input.h"
#include "slid_chroot.h"
#include "slid_setuid.h"
#include "slid_datestamp.h"

extern int SLIDENTD_LOG;
extern int slid_running_tcpserver;
extern int slid_running_inetd;
#endif
