package SigC;

use 5.006;
use strict;
use warnings;

require Exporter;
require DynaLoader;

our @ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use SigC ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);
our $VERSION = '0.07';

bootstrap SigC $VERSION;

# Preloaded methods go here.

# Makefile.PL helper stuff

do "sigcperl_compile_flags.pl";

sub create_glue_code
{
  use Carp;

  my ($filename, $typemap_list, $type_map) = @_;
  my (%type_kind, %input_expr, %output_expr);

  no warnings;

  ################################################################
  # The typemap parsing code was stolen directly from
  # ExtUtils/xsubpp in Perl 5.6.1
  ################################################################

sub TrimWhitespace
{
    $_[0] =~ s/^\s+|\s+$//go ;
}

sub TidyType
{
    local ($_) = @_ ;

    # rationalise any '*' by joining them into bunches and removing whitespace
    s#\s*(\*+)\s*#$1#g;
    s#(\*+)# $1 #g ;

    # change multiple whitespace into a single space
    s/\s+/ /g ;
    
    # trim leading & trailing whitespace
    TrimWhitespace($_) ;

    $_ ;
}

my $proto_re = "[" . quotemeta('\$%&*@;') . "]" ;

sub ValidProtoString ($)
{
    my($string) = @_ ;

    if ( $string =~ /^$proto_re+$/ ) {
        return $string ;
    }

    return 0 ;
}

foreach my $typemap (@$typemap_list) {
    croak "Can't find $typemap\n" unless -r $typemap;
}
foreach my $typemap (@$typemap_list) {
    next unless -e $typemap ;
    # skip directories, binary files etc.
    carp("Warning: ignoring non-text typemap file '$typemap'\n"), next 
	unless -T $typemap ;
    open(TYPEMAP, $typemap) 
	or carp ("Warning: could not open typemap file '$typemap': $!\n"), next;
    my $mode = 'Typemap';
    my $junk = "" ;
    my $current = \$junk;
    while (<TYPEMAP>) {
	next if /^\s*#/;
        my $line_no = $. + 1; 
	if (/^INPUT\s*$/)   { $mode = 'Input';   $current = \$junk;  next; }
	if (/^OUTPUT\s*$/)  { $mode = 'Output';  $current = \$junk;  next; }
	if (/^TYPEMAP\s*$/) { $mode = 'Typemap'; $current = \$junk;  next; }
	if ($mode eq 'Typemap') {
	    chomp;
	    my $line = $_ ;
            TrimWhitespace($_) ;
	    # skip blank lines and comment lines
	    next if /^$/ or /^#/ ;
	    my($type,$kind, $proto) = /^\s*(.*?\S)\s+(\S+)\s*($proto_re*)\s*$/ or
		carp("Warning: File '$typemap' Line $. '$line' TYPEMAP entry needs 2 or 3 columns\n"), next;
            $type = TidyType($type) ;
	    $type_kind{$type} = $kind ;
            # prototype defaults to '$'
            $proto = "\$" unless $proto ;
            carp("Warning: File '$typemap' Line $. '$line' Invalid prototype '$proto'\n") 
                unless ValidProtoString($proto) ;
	}
	elsif (/^\s/) {
	    $$current .= $_;
	}
	elsif ($mode eq 'Input') {
	    s/\s+$//;
	    $input_expr{$_} = '';
	    $current = \$input_expr{$_};
	}
	else {
	    s/\s+$//;
	    $output_expr{$_} = '';
	    $current = \$output_expr{$_};
	}
    }
    close(TYPEMAP);
}

foreach my $key (keys %input_expr) {
    $input_expr{$key} =~ s/\n+$//;
}

foreach my $key (keys %output_expr) {
    $output_expr{$key} =~ s/\n+$//;
}

  ################################################################
  # End parsing code
  ################################################################

  use warnings;

  open (FILE, '>', $filename) or croak "Couldn't open file $filename";

  foreach my $type (keys %$type_map) {
    my $class_name = $$type_map{$type};
    my $kind = $type_kind{$type};
    my $input_code = $input_expr{$kind};
    my $output_code = $output_expr{$kind};

    croak "Couldn't find type $type in the typemap"
      if !$input_code || !$output_code;

    $input_code =~ s/XSRETURN_UNDEF/throw BadConvertVal()/g;
    croak << "ARGEND" if $output_code =~ /XSREUTRN_UNDEF/;
Typemap code can fail when producing an SV* from $type,
unable to construct glue code.
ARGEND

    my $Package = "SigCPerl";
    my $func_name = "ArgBox<$type>::ArgBox(SV*) throw(BadConvertVal)";
    my ($var, $arg) = ("m_val", "val");
    print FILE << "ARGEND";

template<> inline SigCPerl::ArgBox<$type>::ArgBox(SV *val) throw(BadConvertVal)
{
ARGEND
    eval "print FILE qq\a$input_code\n\a";
    print FILE << "ARGEND";
}
ARGEND

    $Package = "";
    $func_name = "SV* GetSV($type) throw()";
    ($var, $arg) = ("val", "out");
    print FILE << "ARGEND";

inline SV* GetSV($type val) throw()
{
  SV *out = NEWSV(0, 0);
  const char *CLASS = "$class_name";
ARGEND
    eval "print FILE qq\a$output_code\n\a";
    print FILE << "ARGEND";
  return out;
}
ARGEND
  }

 close(FILE);
}

# Emulate the SigC::slot function in C++

sub slot {return new SigC::Slot(@_);}

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

SigC - Perl extension which wraps the libsigc++ signal library

=head1 SYNOPSIS

  use SigC;

  $foo = sub {return shift;};

  $signal = new SigC::Signal();
  $connection = $signal->connect($foo);

  $signal->emit(1, 2); # calls $foo, returns a list containing 1

  disconnect $connection;

  $signal->emit(3, 4, 5);  # doesn't call $foo, returns an empty list

=head1 DESCRIPTION

While this module can be used alone to provide signals,
its primary use is to make it easier to write modules
around C++ code that uses libsigc++. The signals provided
by these other modules may have restrictions on the kinds
of values they may be called with or return.

=head2 EXPORT

None by default.


=head1 AUTHOR

Ron Steinke, E<lt>rsteinke@w-link.netE<gt>

=head1 SEE ALSO

L<perl>.

=head1 COPYRIGHT

Copyright 2002, Ron Steinke.  All Rights Reserved.

This program is free software.  You may copy or redistribute
it under the same terms as Perl itself.

=cut
