/***************************************************************************
                          player_track.h  -  description
                             -------------------
    begin                : Tue Nov 7 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYER_TRACK_H
#define PLAYER_TRACK_H

#include "typedefs.h"
#include "player_variable.h"

/**Playing Track!
  *@author Juan Sebastian Linietsky
  */

#define MAX_COLUMNS_PER_PLAYING_TRACK 10


struct Player_Column {

	Uint8 current_note; /* note to be played 1-128 0 = no note / noteoff sets this to 0 */
	Uint8 initial_volume; /* volume of the note (0-127 - bit 7 set = note off) */
	char last_effect;  // 0 == no effect
	
//        char current_controller;

	Player_Effect_Controller_Slide controller_slide;
	Player_Effect_Pitch_Slide pitch_slide;
	Player_Effect_Pitch_Portamento pitch_porta;
        Player_Effect_Pitch_Vibrato pitch_vibrato;
	void reset() {

		current_note=0;
		initial_volume=0;
		last_effect=0;
//		current_controller=-1;
	}
	
	void reinit_effects() {

		controller_slide.reset();
	}	
	
	Player_Column() {

		reset();         	
	}

	void set_tempo_value_ptr(int *tempo_value_ptr) {

		controller_slide.link_tempo(tempo_value_ptr);
		pitch_slide.link_tempo(tempo_value_ptr);
		pitch_porta.link_tempo(tempo_value_ptr);
		pitch_vibrato.link_tempo(tempo_value_ptr);
	}
	
	void set_current_controller(char new_controller,float *controller_ptr) {

		controller_slide.link_to_controller(new_controller,controller_ptr);
	}

};

class Player_Track {
public:
	
	Player_Column column[MAX_COLUMNS_PER_PLAYING_TRACK];

	struct Instrument_Cache {

		int device;
		int bank;
		char patch;
		char channel;

		bool device_channel_in_use;

	} instrument_cache;

	//controllers data
	
	float controller_value[128]; // float, so we can do effects more acuratedly

	//pitch bender data

	char current_bender_sens;
	int current_bender_value;

	int *tempo_value_ptr; // effect classes and stuff need this


	void reset() {

		int i;

		for (i=0;i<MAX_COLUMNS_PER_PLAYING_TRACK;i++) {

			column[i].set_tempo_value_ptr(tempo_value_ptr);
			column[i].pitch_slide.link_to_pitch(&current_bender_value);
			column[i].pitch_porta.link_to_pitch(&current_bender_value);
			column[i].pitch_vibrato.link_to_pitch(&current_bender_value);
		}

		reinit_cache();
		reinit_columns();
	}

	void reinit_effects() {

		int i;
		for (i=0;i<MAX_COLUMNS_PER_PLAYING_TRACK;i++) column[i].reinit_effects();
	}

	void reinit_columns() {

		int i;

		for (i=0;i<MAX_COLUMNS_PER_PLAYING_TRACK;i++) {

			column[i].reset();
		}
	}

	void reinit_cache() {

		instrument_cache.device_channel_in_use=false;
		instrument_cache.device=-1;		
		instrument_cache.channel=-1;		

	}

	Player_Track() {

		reset();
	}
	~Player_Track();
};

#endif
