/***************************************************************************
                          editor_orderlist.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editor.h"



void Pattern_Editor::orderlist_move_up() {

        if (orderlist_cursor_y>0) orderlist_cursor_y--;

}

void Pattern_Editor::orderlist_move_down() {

        if (orderlist_cursor_y<song->get_max_order()-1) orderlist_cursor_y++;
	
}

void Pattern_Editor::orderlist_move_left() {

        if (orderlist_cursor_x>0) orderlist_cursor_x--;
	
}

void Pattern_Editor::orderlist_move_right() {

        if (orderlist_cursor_x<2) orderlist_cursor_x++;

}

void Pattern_Editor::orderlist_page_up() {

       orderlist_cursor_y-=8;
       if (orderlist_cursor_y<0) orderlist_cursor_y=0;
}

void Pattern_Editor::orderlist_page_down() {

       orderlist_cursor_y+=8;
       if (orderlist_cursor_y>song->get_max_order()-1) orderlist_cursor_y=song->get_max_order()-1;
}

void Pattern_Editor::orderlist_increase_order() {

	if (orderlist_cursor_y<=0) return;
	if (song->get_order(orderlist_cursor_y-1)<0) return;
	song->set_order(orderlist_cursor_y,song->get_order(orderlist_cursor_y-1)+1);
	orderlist_move_down();
}
void Pattern_Editor::orderlist_add_separator() {

	song->set_order(orderlist_cursor_y,Song::ORDER_SKIP);
	orderlist_move_down();
}

void Pattern_Editor::orderlist_clear_order() {

	song->set_order(orderlist_cursor_y,Song::ORDER_CLEAR);
	orderlist_move_down();
}

void Pattern_Editor::orderlist_insert_value(int number) {

	int tmpvalue;

	tmpvalue=song->get_order(orderlist_cursor_y);

	if (tmpvalue<0) tmpvalue=0;

	switch (orderlist_cursor_x) {

		case 0: {

			tmpvalue=tmpvalue-((tmpvalue/100)*100)+number*100;
		} break;
		case 1: {

			tmpvalue=tmpvalue-(((tmpvalue/10) % 10)*10)+number*10;	
		} break;
		case 2: {
			tmpvalue=tmpvalue-(tmpvalue % 10)+number;		
		} break;

	}

//	if (tmpvalue>=song->get_patterns()) tmpvalue=199;

	song->set_order(orderlist_cursor_y,tmpvalue);

	if (orderlist_cursor_x<2) orderlist_move_right();
	else { orderlist_cursor_x=0; orderlist_move_down();}
}

void Pattern_Editor::orderlist_insert() {
	
	int i;

	for (i=song->get_max_order()-1;i>orderlist_cursor_y;i--) {

		song->set_order(i,song->get_order(i-1));
	}
	song->set_order(orderlist_cursor_y,Song::ORDER_CLEAR);
}

void Pattern_Editor::orderlist_delete() {

	int i;

	for (i=orderlist_cursor_y;i<song->get_max_order()-1;i++) {

		song->set_order(i,song->get_order(i+1));
	}
	song->set_order(song->get_max_order()-1,Song::ORDER_CLEAR);
}

string Pattern_Editor::orderlist_get_cursor_string(int p_order) {

       	char tmporder[4]={'0','0','0',0};
        int aux;
       	aux=song->get_order(p_order);
     	switch (aux) {

     		case Song::ORDER_CLEAR: {

     			tmporder[0]='.';
     			tmporder[1]='.';
     			tmporder[2]='.';
     		}break;
     		case Song::ORDER_SKIP: {
     			tmporder[0]='+';
     			tmporder[1]='+';
     			tmporder[2]='+';
     		}break;
     		default: {

     			tmporder[0]='0'+aux/100;
     			tmporder[1]='0'+(aux/10)%10;
     			tmporder[2]='0'+aux%10;
     		}break;

     	}
	return tmporder;
}