/***************************************************************************
                          alsa_client.cpp  -  description
                             -------------------
    begin                : Mon Feb 4 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef ALSA_ENABLED

#include "alsa_client.h"


int Alsa_Client::get_file_descriptor() {

	int pfds = snd_seq_poll_descriptors_count(handle, POLLIN);
	if (pfds > 0) {
		struct pollfd pfd;
		if (snd_seq_poll_descriptors(handle, &pfd, 1, POLLIN) >= 0)
			return pfd.fd;
	}
	return -ENXIO;
}

bool Alsa_Client::create_port() {

	snd_seq_port_info_t *pinfo;
	char name[32];
	int port;

	/* open that bitch */
	if (snd_seq_open(&handle, "hw", SND_SEQ_OPEN_INPUT, 0)<0) return true;
	
	
	client = snd_seq_client_id(handle); //get client?
	//fd = get_file_descriptor();
	snd_seq_set_client_pool_input(handle, 1000); /* enough? */

	
	sprintf(name, "ShakeTracker Ctl.");
	port = snd_seq_create_simple_port(handle, name,
					  SND_SEQ_PORT_CAP_WRITE|SND_SEQ_PORT_CAP_SUBS_WRITE,
					  SND_SEQ_PORT_TYPE_MIDI_GENERIC);
	if (port < 0) {
		fprintf(stderr, "error in snd_seq_create_simple_port\n");
		return true;
	}
	
	
	active=true;
	port_index=port;

	return false;
}

void Alsa_Client::dispatch_events() {

        if (!active) return;
		
	while (snd_seq_event_input_pending(handle, 1)) {
	
		snd_seq_event_t *event;	
		int er;
					
                er = snd_seq_event_input(handle, &event);
	
		if (er < 0 || event == NULL)
			return;
			
		switch(event->type) {
	
			case SND_SEQ_EVENT_NOTEON: {
			
                                Note_Event new_event;
                                new_event.note=event->data.note.note;
                                new_event.velocity=event->data.note.velocity;
                                new_event.note_off=false;

                                note_list.push_back(new_event);
                                
//				midi_event->note_on(event->data.note.channel,event->data.note.note,event->data.note.velocity);
				
				
				
				/*
		
				ev.channel = NOTE_CHAN(aevp);
				ev.a       = aevp->data.note.note;
				ev.b       = aevp->data.note.velocity;
				if (ev.b == 0)
					ev.type = ME_NOTEOFF;
				else
					ev.type = ME_NOTEON;
				seq_play_event(&ev);
				break; */
			} break;
			

			case SND_SEQ_EVENT_NOTEOFF: {

                                Note_Event new_event;
                                new_event.note=event->data.note.note;
                                new_event.velocity=event->data.note.velocity;
                                new_event.note_off=true;

                                note_list.push_back(new_event);

//				midi_event->note_off(event->data.note.channel,event->data.note.note,event->data.note.velocity);				
						
			  /*
                    		ev.channel = NOTE_CHAN(aevp);
                    		ev.a       = aevp->data.note.note;
                    		ev.b       = aevp->data.note.velocity;
                    		ev.type = ME_NOTEOFF;
                    		seq_play_event(&ev); */
                    		
                    	} break;

			case SND_SEQ_EVENT_KEYPRESS: {
			
				/*
                      		ev.channel = NOTE_CHAN(aevp);
                      		ev.a       = aevp->data.note.note;
                      		ev.b       = aevp->data.note.velocity;
                      		ev.type = ME_KEYPRESSURE;
                      		seq_play_event(&ev);
				break; */
			}
			
			case SND_SEQ_EVENT_PGMCHANGE: {

				
//				midi_event->program_change(event->data.control.channel,event->data.control.value);
					
				/*
                       		ev.channel = CTRL_CHAN(aevp);
                       		ev.a = aevp->data.control.value;
                       		ev.type = ME_PROGRAM;
                       		seq_play_event(&ev); */
			} break;

			case SND_SEQ_EVENT_CONTROLLER: {


//				midi_event->controller(event->data.control.channel,event->data.control.param,event->data.control.value);
				
				/*
                       		if(convert_midi_control_change(CTRL_CHAN(aevp),
                       					       aevp->data.control.param,
                       					       aevp->data.control.value,
                       					       &ev))
                       			seq_play_event(&ev); */
                       	} break;
			
	
			case SND_SEQ_EVENT_CONTROL14: {
                         			
				/*
			
                   		if (aevp->data.control.param < 0 || aevp->data.control.param >= 32)
                   			break;
                   		if (! convert_midi_control_change(CTRL_CHAN(aevp),
                   						  aevp->data.control.param,
                   						  (aevp->data.control.value >> 7) & 0x7f,
                   						  &ev))
                   			break;
                   		seq_play_event(&ev);
                   		if (! convert_midi_control_change(CTRL_CHAN(aevp),
                   						  aevp->data.control.param + 32,
                   						  aevp->data.control.value & 0x7f,
                   						  &ev))
                   			break;
                   		seq_play_event(&ev); */
			} break;
		
			case SND_SEQ_EVENT_PITCHBEND: {
			
//				midi_event->pitch_bend(event->data.control.channel,event->data.control.value+0x2000);			
				/*
                		ev.type    = ME_PITCHWHEEL;
                		ev.channel = CTRL_CHAN(aevp);
                		aevp->data.control.value += 0x2000;
                		ev.a       = (aevp->data.control.value) & 0x7f;
                		ev.b       = (aevp->data.control.value>>7) & 0x7f;
                		seq_play_event(&ev); */
                		
			} break;

			case SND_SEQ_EVENT_CHANPRESS: {
			  	
				/*
                   		ev.type    = ME_CHANNEL_PRESSURE;
                   		ev.channel = CTRL_CHAN(aevp);
                   		ev.a       = aevp->data.control.value;
                   		seq_play_event(&ev); */
                   	} break;
		
			case SND_SEQ_EVENT_NONREGPARAM: {
                      		
				/*

                      		ev.type = ME_NRPN_MSB;
                      		ev.channel = CTRL_CHAN(aevp);
                      		ev.a = (aevp->data.control.param >> 7) & 0x7f;
                      		seq_play_event(&ev);
                      		ev.type = ME_NRPN_LSB;
                      		ev.channel = CTRL_CHAN(aevp);
                      		ev.a = aevp->data.control.param & 0x7f;
                      		seq_play_event(&ev);
                      		ev.type = ME_DATA_ENTRY_MSB;
                      		ev.channel = CTRL_CHAN(aevp);
                      		ev.a = (aevp->data.control.value >> 7) & 0x7f;
                      		seq_play_event(&ev);
                      		ev.type = ME_DATA_ENTRY_LSB;
                      		ev.channel = CTRL_CHAN(aevp);
                      		ev.a = aevp->data.control.value & 0x7f;
                      		seq_play_event(&ev);
                      		*/
			} break;


      			case SND_SEQ_EVENT_REGPARAM: {



				/*      				
      			
                       		ev.type = ME_RPN_MSB;
                       		ev.channel = CTRL_CHAN(aevp);
                       		ev.a = (aevp->data.control.param >> 7) & 0x7f;
                       		seq_play_event(&ev);
                       		ev.type = ME_RPN_LSB;
                       		ev.channel = CTRL_CHAN(aevp);
                       		ev.a = aevp->data.control.param & 0x7f;
                       		seq_play_event(&ev);
                       		ev.type = ME_DATA_ENTRY_MSB;
                       		ev.channel = CTRL_CHAN(aevp);
                       		ev.a = (aevp->data.control.value >> 7) & 0x7f;
                       		seq_play_event(&ev);
                       		ev.type = ME_DATA_ENTRY_LSB;
                       		ev.channel = CTRL_CHAN(aevp);
                       		ev.a = aevp->data.control.value & 0x7f;
                       		seq_play_event(&ev);
                       		*/

//                         	midi_event->registered_parameter_number(event->data.control.param & 0x7f,(event->data.control.param >> 7) & 0x7f,event->data.control.value & 0x7f,(event->data.control.value >> 7) & 0x7f);

			} break;

      			case SND_SEQ_EVENT_SYSEX: {
      			
      				/*
      				if (parse_sysex_event(aevp->data.ext.ptr + 1, aevp->data.ext.len - 1, &ev))
      				seq_play_event(&ev); */
			} break;

#if SND_LIB_MINOR >= 6
#define snd_seq_addr_equal(a,b)	((a)->client == (b)->client && (a)->port == (b)->port)
	
			case SND_SEQ_EVENT_PORT_SUBSCRIBED: {
				
			  	/*
				if (snd_seq_addr_equal(&aevp->data.connect.dest, &aevp->dest)) {
				if (! ctxp->active) {
				if (! start_sequencer(ctxp)) {
					snd_seq_free_event(aevp);
					return 0;
				}
				}
					ctxp->used++;
				} */      	
			} break;

			case SND_SEQ_EVENT_PORT_UNSUBSCRIBED: {
			
				/*
                		if (snd_seq_addr_equal(&aevp->data.connect.dest, &aevp->dest)) {
                			if (ctxp->active) {
                				ctxp->used--;
                				if (ctxp->used <= 0) {
                					snd_seq_free_event(aevp);
                					return 1;
                				}
                			}
                		} */
                		
			} break;
#else
			case SND_SEQ_EVENT_PORT_USED: {
			
                		if (! ctxp->active) {
                			if (! start_sequencer(ctxp)) {
                				snd_seq_free_event(aevp);
                				return 0;
                			}
                		}
                		ctxp->used++;
			} break;

                 	case SND_SEQ_EVENT_PORT_UNUSED: {
                 	
                 		/*
                 		if (ctxp->active) {
                 			ctxp->used--;
                 			if (ctxp->used <= 0) {
                 				snd_seq_free_event(aevp);
                 				return 1;
                 			}
                 		} */
			} break;
#endif
		
			default: {
				/*printf("Unsupported event %d\n", aevp->type);*/
			} break;
		}

		snd_seq_free_event(event);
		//return;
	}
/*	
        fd_set rfds;
	FD_ZERO(&rfds);
	FD_SET(fd, &rfds);
	select(fd + 1, &rfds, NULL, NULL, NULL);*/
}


bool Alsa_Client::are_notes_pending() {
        dispatch_events();

	return (note_list.size()!=0);
}
bool Alsa_Client::get_note(char &p_note,char &p_velocity, bool &p_is_noteoff) {
        dispatch_events();

	if (note_list.size()==0) return false;

        printf("GETNOTE!\n");	
	p_note=note_list.begin()->note;
	p_velocity=note_list.begin()->velocity;
	p_is_noteoff=note_list.begin()->note_off;
	note_list.pop_front();

	return true;
}

void Alsa_Client::close_port() {


}


Alsa_Client::Alsa_Client(){


	active=false;
}
Alsa_Client::~Alsa_Client(){
}

#endif