/***************************************************************************
                          event_execute.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EVENT_EXECUTE_H
#define EVENT_EXECUTE_H

#include "song.h"
#include "midioutdevicemanager.h"

/**
  *@author Juan Sebastian Linietsky
  */

class Event_Execute {

        MidiOutDeviceManager *midiout;
	Song *song;

	struct Track_State {

	 	struct Column_State {
	
			Uint8 note;
	                float volume;	
		
			void reset() {
        	
				note=Note::CLEAR;
				volume=0;
			}

			Column_State() {

				reset();
			}
		};

		vector<Column_State> column;
	
		struct Instrument_Cache {

			int device;
			int bank;
			char patch;
			char channel;

			bool device_channel_in_use;

		} cache;

		float controller[128];
		char  bender_sens;
		float bender_value;
		float aftertouch_value;

		void reset() {

			unsigned int i;
			for (i=0;i<column.size();i++) column[i].reset();
			for (i=0;i<128;i++) controller[i]=127;
			cache.device=-1;
			cache.channel=-1;
			cache.bank=-1;
			cache.patch=-1;
			cache.device_channel_in_use=false;
			aftertouch_value=0;
		}

		Track_State() {

			reset();
		}
	};

	vector<Track_State> track;

	char convert_volume_to_velocity(int p_track,Uint8 p_volume);
        void stop_note_in_another_track(int p_track,int p_column,char p_note);

	Bank* get_current_bank(int p_track);
        //instrument cache

	void verify_instrument_cache(int p_track);
	void set_track_device_channel_in_use(int p_track);
	bool check_channel_changed(int p_track);
	bool check_device_changed(int p_track);
	bool check_instrument_settings_changed(int p_track);
	void set_track_instrument(int p_track);
	void adjust_size();

public:

	void event_External_NoteOn(int p_track,char p_note, char p_volume);
	void event_External_NoteOff(int p_track,char p_note, char p_volume);


	void event_NoteOff(int p_track,int p_column, char p_volume);
	void event_NoteOn(int p_track,int p_column,char p_note, char p_volume);
	void event_Controller_Set(int p_track,int p_column,char p_controller,float p_value);
	void event_controller_set_virtual_displacement(int p_track,int p_column,char p_controller,float p_value);
	void event_Pitch_Set(int p_track,int p_column,float p_value);
	void event_Pitch_Set_Virtual_Displacement(int p_track,int p_column,float p_value);
	void event_Set_Column_Volume(int p_track,int p_column,float p_volume);
	void event_set_column_volume_virtual(int p_track,int p_column,float p_volume);
	void event_set_aftertouch(int p_track,float p_value);

//	void event_Pitch_Set_Virtual_Displacement(int p_track,int p_column,float p_value);
	
	char get_last_note(int p_track,int p_column); // -1 if no note has been set yet
	float get_controller_value(int p_track,int p_controller);
	float get_pitch_value(int p_track);
	float get_column_volume(int p_track,int p_column);
	float get_aftertouch(int p_track);

        void adjust_bender_sens(int p_track);

	void reset_track(int p_track);
	void reset();

	void stop_track(int p_track);
	void stop();

	void stop_channel(int p_track,int p_column);
        int get_hw_device(int p_track);
        int get_hw_channel(int p_track);

	void set_midiout(MidiOutDeviceManager *p_midiout);
	void set_song(Song *p_song);

	Event_Execute();
	~Event_Execute();
};

#endif
