/* $Id: test_tiger.C,v 1.2 1998/11/10 21:36:12 dm Exp $ */

#include "tiger.h"
#include "async.h"

struct tigertest {
  const char *msg;
  u_char hash[64];
};

tigertest testvecs[] = {
  {
    "",
    {0x24, 0xF0, 0x13, 0x0C, 0x63, 0xAC, 0x93, 0x32, 0x16, 0x16, 0x6E, 0x76,
     0xB1, 0xBB, 0x92, 0x5F, 0xF3, 0x73, 0xDE, 0x2D, 0x49, 0x58, 0x4E, 0x7A}
  },
  {
    "abc",
    {0xF2, 0x58, 0xC1, 0xE8, 0x84, 0x14, 0xAB, 0x2A, 0x52, 0x7A, 0xB5, 0x41,
     0xFF, 0xC5, 0xB8, 0xBF, 0x93, 0x5F, 0x7B, 0x95, 0x1C, 0x13, 0x29, 0x51}
  },
  {
    "Tiger",
    {0x9F, 0x00, 0xF5, 0x99, 0x07, 0x23, 0x00, 0xDD, 0x27, 0x6A, 0xBB, 0x38,
     0xC8, 0xEB, 0x6D, 0xEC, 0x37, 0x79, 0x0C, 0x11, 0x6F, 0x9D, 0x2B, 0xDF}
  },
  {
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-",
    {0x87, 0xFB, 0x2A, 0x90, 0x83, 0x85, 0x1C, 0xF7, 0x47, 0x0D, 0x2C, 0xF8,
     0x10, 0xE6, 0xDF, 0x9E, 0xB5, 0x86, 0x44, 0x50, 0x34, 0xA5, 0xA3, 0x86}
  },
  {
    "ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789",
    {0x46, 0x7D, 0xB8, 0x08, 0x63, 0xEB, 0xCE, 0x48, 0x8D, 0xF1, 0xCD, 0x12,
     0x61, 0x65, 0x5D, 0xE9, 0x57, 0x89, 0x65, 0x65, 0x97, 0x5F, 0x91, 0x97}
  },
  {
    "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham",
    {0x0C, 0x41, 0x0A, 0x04, 0x29, 0x68, 0x86, 0x8A, 0x16, 0x71, 0xDA, 0x5A,
     0x3F, 0xD2, 0x9A, 0x72, 0x5E, 0xC1, 0xE4, 0x57, 0xD3, 0xCD, 0xB3, 0x03}
  },
  {
    "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, "
    "proceedings of Fast Software Encryption 3, Cambridge.",
    {0xEB, 0xF5, 0x91, 0xD5, 0xAF, 0xA6, 0x55, 0xCE, 0x7F, 0x22, 0x89, 0x4F,
     0xF8, 0x7F, 0x54, 0xAC, 0x89, 0xC8, 0x11, 0xB6, 0xB0, 0xDA, 0x31, 0x93}
  },
  {
    "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, "
    "proceedings of Fast Software Encryption 3, Cambridge, 1996.",
    {0x3D, 0x9A, 0xEB, 0x03, 0xD1, 0xBD, 0x1A, 0x63, 0x57, 0xB2, 0x77, 0x4D,
     0xFD, 0x6D, 0x5B, 0x24, 0xDD, 0x68, 0x15, 0x1D, 0x50, 0x39, 0x74, 0xFC}
  },
  {
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-"
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-",
    {0x00, 0xB8, 0x3E, 0xB4, 0xE5, 0x34, 0x40, 0xC5, 0x76, 0xAC, 0x6A, 0xAE,
     0xE0, 0xA7, 0x48, 0x58, 0x25, 0xFD, 0x15, 0xE7, 0x0A, 0x59, 0xFF, 0xE4}
  },
};

const size_t ntestvecs = sizeof (testvecs) / sizeof (testvecs[0]);

const u_char hash64k[64] = {
  0x8E, 0xF4, 0x39, 0x51, 0xB3, 0xF5, 0xF4, 0xFD,  0x1D, 0x41, 0xAF, 0xE5,
  0x1B, 0x42, 0x0E, 0x71,  0x04, 0x62, 0xF2, 0x33, 0xC3, 0xAA, 0xA8, 0xE1 
};

int
main (int argc, char **argv)
{
  tigerctx tc;
  u_char out[tiger::hashsize];

  setprogname (argv[0]);

  for (size_t i = 0; i < ntestvecs; i++) {
    tc.reset ();
    tc.update (testvecs[i].msg, strlen (testvecs[i].msg));
    tc.final (out);
    if (memcmp (out, testvecs[i].hash, tiger::hashsize))
      panic << "test failed for:\n  \""
	    << testvecs[i].msg << "\"\n"
	    << " wanted: "
	    << hexdump (testvecs[i].hash, tiger::hashsize) << "\n"
	    << "    got: "
	    << hexdump (out, tiger::hashsize) << "\n";
  }

  char buffer[0x10000];
  for (size_t i = 0; i < sizeof (buffer); i++)
    buffer[i] = i;

  tc.reset ();
  tc.update (buffer, sizeof (buffer));
  tc.final (out);
  if (memcmp (out, hash64k, tiger::hashsize))
    panic << "test failed for 64k string:\n"
	  << " wanted: "
	  << hexdump (hash64k, tiger::hashsize) << "\n"
	  << "    got: "
	  << hexdump (out, tiger::hashsize) << "\n";

  return 0;
}
