/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2003  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <string.h>
#include <gtk/gtk.h>

#include "misc.h"
#include "miscui.h"

void insert_item (config *selectwm_config, const gchar *cmd, const gchar *dsc) {
	GtkTreeIter iter;
	GdkColor color = { 0, 0, 0, 0};
	
	gtk_list_store_append (GTK_LIST_STORE (selectwm_config->model), &iter);

	gtk_list_store_set (GTK_LIST_STORE (selectwm_config->model), &iter, 
			C_ICON, gtk_widget_render_icon (selectwm_config->window, "gtk-execute", GTK_ICON_SIZE_MENU, NULL),
			C_DESC, dsc,
			C_CMD, cmd ,
			C_DEFAULT, FALSE,
			C_COLOR, &color,
			C_EDITABLE, TRUE, -1);
}

typedef struct _browse_data {
	GtkWidget *window;
	GtkWidget *entry;
} browse_data;

static void browse_ok (GtkWidget *w, gpointer data) {
	browse_data *bdata = (browse_data *) data;
	
	gtk_entry_set_text (GTK_ENTRY (bdata->entry), gtk_file_selection_get_filename (GTK_FILE_SELECTION (bdata->window)));
	gtk_widget_destroy (bdata->window);
}

static void browse (GtkWidget *entry) {
	GtkWidget *filew;
	browse_data bdata;
        
        filew = gtk_file_selection_new (_("Select a window manager"));
	gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (filew));
        gtk_window_set_modal (GTK_WINDOW (filew), TRUE);
	g_signal_connect (G_OBJECT (filew), "destroy", G_CALLBACK (gtk_main_quit), filew);
	gtk_window_set_position (GTK_WINDOW (filew), GTK_WIN_POS_MOUSE);

	bdata.window = filew;
	bdata.entry = entry;
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (filew)->ok_button), "clicked", G_CALLBACK (browse_ok), &bdata);
        
        g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button), "clicked", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (filew));
        
        gtk_widget_show (filew);
	gtk_main ();
}

static void add_edit_gui (GtkWidget **window, GtkWidget **entry1, GtkWidget **entry2, const gchar *title, const gchar *btn) {
	GtkWidget *hbox, *label;
	
	*window = gtk_dialog_new_with_buttons (title, NULL, GTK_DIALOG_MODAL, btn, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_FIND, GTK_RESPONSE_HELP, NULL);
        gtk_window_set_position (GTK_WINDOW (*window), GTK_WIN_POS_CENTER);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (*window)->vbox), hbox, FALSE, FALSE, 0);

	*entry2 = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox), *entry2, FALSE, FALSE, 0);
	label = gtk_label_new (_(" Description"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (*window)->vbox), hbox, FALSE, FALSE, 0);
	
	*entry1 = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox), *entry1, FALSE, FALSE, 0);
	label = gtk_label_new (_(" Command"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
}

void add_edit (gboolean edit, gpointer data) {
	GtkWidget *window, *entry1, *entry2;
	config * selectwm_config = (config *) data;
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *desc, *cmd;
	const gchar *desc2, *cmd2;

	if (edit && !gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (selectwm_config->treeview)), &model, &iter)) return;

	if (edit) {
		add_edit_gui (&window, &entry1, &entry2, _("Edit Item"), GTK_STOCK_OK);
		gtk_tree_model_get (model, &iter, C_CMD, &cmd, C_DESC, &desc , -1);
		gtk_entry_set_text (GTK_ENTRY (entry2), desc);
		gtk_entry_set_text (GTK_ENTRY (entry1), cmd);
		g_free (desc);
		g_free (cmd);
	} else
		add_edit_gui (&window, &entry1, &entry2, _("Add item"), GTK_STOCK_ADD);

	gtk_widget_show_all (window);
retry:
	switch (gtk_dialog_run (GTK_DIALOG (window))) {
		case GTK_RESPONSE_OK:
			cmd2 = gtk_entry_get_text (GTK_ENTRY (entry1));
			desc2 = gtk_entry_get_text (GTK_ENTRY (entry2));
			if (0 == strcmp (cmd2, "") || 0 == strcmp (desc2, "")) goto retry;
			if (edit) gtk_list_store_set (GTK_LIST_STORE (model), &iter, C_DESC, desc2, C_CMD, cmd2, -1);
				else insert_item (selectwm_config, cmd2, desc2);
			break;
		case GTK_RESPONSE_HELP:
			browse (entry1);
			goto retry;
	}
	gtk_widget_destroy (window);
}

void add_item (GtkWidget *w, gpointer data) {
	add_edit (FALSE, data);
}

void edit_item (GtkWidget *w, gpointer data) {
	add_edit (TRUE, data);
}

void delete_item (GtkWidget *w, gpointer data) {
	config *selectwm_config = (config *) data;
	GtkTreeIter iter;
	GtkTreeModel *model;

	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (selectwm_config->treeview)), &model, &iter)) {
		gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
	}
}

void default_item (GtkWidget *w, gpointer data) {
	GString *buf;
	config *selectwm_config = (config *) data;
	gchar *desc;
	GtkTreeIter iter;
	GtkTreeModel *model;
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (selectwm_config->treeview)), &model, &iter)) {
		remove_defaultwm (selectwm_config->model);
		set_defaultwm (GTK_LIST_STORE (model), &iter);

		buf = g_string_new ("");
	        gtk_tree_model_get (model, &iter, C_DESC, &desc , -1);
		g_string_printf (buf,_("\"%s\" is now the default window manager"), desc);
		messagebox (buf->str, GTK_MESSAGE_INFO);
		g_free (desc);
		g_string_free (buf, TRUE);
	}
}
