/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMSUDH_H
#define SMSUDH_H

//own headers
#include <smspdu.h>

struct sms_pdu_ud_header* sms_udh_multipart16_get (uint16_t seqnum,
						   uint8_t index,
						   uint8_t total);


/* print the headers as text to fp
 * sms_udh_fill() and sms_multipart_merge() should be
 * called before this one
 *
 * called e.g. by sms_pdu_print_deliver()
 */
void sms_udh_print (FILE* fp, struct sms_pdu_ud* plist, uint8_t parts);

//these are called by sms_udh_print()
void sms_udh_multipart8_print (FILE* fp, char* data);
void sms_udh_multipart16_print (FILE* fp, char* data);
void sms_udh_application8_print (FILE* fp, char* data);
void sms_udh_application16_print (FILE* fp, char* data);
void sms_udh_source_indicator_print (FILE* fp, char* data);
void sms_udh_smstk_print (FILE* fp, char* data);
void sms_udh_wcmpdu_print (FILE* fp, char* data);
void sms_udh_indication_print (FILE* fp, char* data);

//mainly used by sms_udh_fill()
struct sms_pdu_ud_header_def {
  int16_t type; //negative entries are invalid
  uint8_t minlen; //in octets
  uint8_t maxlen; //in octets (obviously not more than 137(=140-1-2)))
  void (*print_func) (FILE* fp, char* data); //function pointer to header type printer
};
extern struct sms_pdu_ud_header_def header_defs[]; //known header types

//to parse the user data header from a pdu
void sms_udh_fill (struct sms_pdu_data* sms, char* data);
//called by sms_udh_fill(), no need to call anywhere else
void sms_udh_multipart_mark (struct sms_pdu_data* data);

#endif
