/* sandcommon.h - common header file for sanduhr
 *
 * Copyright (C) 1999, 2000  Jochen Voss.
 *
 * $Id: sandcommon.h,v 1.21 2002/02/22 19:08:27 voss Rel $ */

#ifndef FILE_SANDUHR_H_SEEN
#define FILE_SANDUHR_H_SEEN

#include <time.h>		/* we use 'time_t' */
#include <gnome.h>

#include "sanduhr.h"


#define  TIMER_IID  "OAFIID:sanduhr:6c7b2e70-d8d0-4486-b75f-c5e83be9663b"
#define  FACTORY_IID  "OAFIID:sanduhr:c31c770f-1043-43b1-a843-660eba410128"


/* from "main.c" */
extern  CORBA_ORB  orb;

extern  void  main_loop_ref (void);
extern  void  main_loop_unref (void);

extern  void  check_corba_error (CORBA_Environment *ev, GtkWindow *parent);

/* from "factory.c" */
struct timer;

struct factory {
  POA_SandUhr_TimerFactory servant;
  PortableServer_POA poa;
  
  GtkWidget *window;
  GtkWidget *clist, *popup_menu;
};

extern  struct factory *create_factory (PortableServer_POA poa,
					CORBA_Environment *ev);
extern  void  delete_factory (struct factory *factory, CORBA_Environment *ev);

extern  void  factory_add_timer (struct factory *, struct timer *);
extern  void  factory_remove_timer (struct factory *, struct timer *);
extern  void  factory_update_timer (struct factory *, struct timer *timer);
extern  int  factory_timer_count (struct factory *factory);

/* from "timer.c" */
enum timer_state { ts_PREPARE, ts_RUNNING, ts_DONE };
struct timer {
  POA_SandUhr_Timer servant;
  PortableServer_POA poa;
  struct factory *factory;
  
  SandUhr_Timer_TimerState  state;
  GtkWidget *window;
  GSList *prop_windows;

  gboolean  grab_active;
  gint  grab_x, grab_y;
  
  gboolean  is_absolute, time_valid;
  time_t  start_time;
  time_t  target_time_abs;
  double  target_time_rel;
  double  ratio;
  char *message;

  SandUhr_AlarmAction alarm;

  guint  handler_id;
};

extern  struct timer *create_timer (struct factory *factory,
				    const char *time_spec, const char *msg,
				    CORBA_Environment *ev);
extern  void  delete_timer (struct timer *timer);
extern  char *timer_get_message (const struct timer *timer);
extern  void  initialize_time (struct timer *);

/* from "alarm.c" */
struct alarm_beep {
  POA_SandUhr_AlarmBeep servant;
  PortableServer_POA poa;

  gboolean  delivering;
  unsigned  ref, count;
};

struct alarm_sound {
  POA_SandUhr_AlarmSound servant;
  PortableServer_POA poa;

  char *file;
};

struct alarm_command {
  POA_SandUhr_AlarmCommand servant;
  PortableServer_POA poa;

  char *command;
};

extern  struct alarm_beep *create_alarm_beep (PortableServer_POA poa,
					      unsigned count,
					      CORBA_Environment *ev);
extern  struct alarm_sound *create_alarm_sound (PortableServer_POA poa,
						const char *file,
						CORBA_Environment *ev);
extern  struct alarm_command *create_alarm_command (PortableServer_POA poa,
						    const char *command,
						    CORBA_Environment *ev);

extern  void  deliver_alarm (struct timer *);

/* from "winutil.c" */
extern  void  window_show_cb (GtkObject *obj, gpointer data);
extern  void  window_destroy_cb (GtkObject *obj, gpointer data);
extern  gint  window_close_cb (GtkObject *obj, gpointer data);

extern  void  display_error_message (const char *str, GtkWindow *parent);
extern  gint  ask_yes_no_question (const char *str, GtkWindow *parent);

/* from "preferences.c" */
extern  void  load_defaults (void);
extern  void  apply_defaults (struct timer *timer);
extern  void  prepare_preferences_dialog (GtkWidget *preferences);
extern  void  decode_preferences (GtkWidget *dialog, int page);

/* from "properties.c" */
extern  void  properties_timer_stopped (GtkWidget *properties);
extern  void  prepare_properties_dialog (GtkWidget *properties,
					 struct timer *timer);
extern  void  properties_to_timer (GtkWidget *properties, int page,
				   struct timer *timer);

/* from "initdialog.c" */
extern  void  ask_for_time (struct timer *, const char *time_spec,
			    void (*success)(struct timer *),
			    void (*failure)(struct timer *),
			    CORBA_Environment *parent_ev);

/* from "argscan.l" */
extern  int  yylex (void);
extern  void  begin_arg (const char *arg);
extern  void  end_arg (void);

/* from "argparse.y" */
extern  int  yyparse (void *data);

#endif /* FILE_SANDUHR_H_SEEN */
