/* argparse.y - parse sanduhr's command line arguments
 *
 * Copyright 2000  Jochen Voss  */

%{
static const  char  rcsid [] = "$Id: argparse.y,v 1.7 2000/09/04 17:38:34 voss Rel $";

#include <stdlib.h>
#include <time.h>
 
#include "sandcommon.h"

#define  YYPARSE_PARAM  data
 
static  void  yyerror (char *);
%}

%union {
  int  number;
  double  dist;
  time_t  absolute;
  struct tm  broken;
}

%token DAYS HOURS MINUTES SECONDS
%token <number> NUMBER
%type <dist> dist  stail mtail htail  sspec mspec hspec dspec
%type <absolute> absolute
%type <broken> date hour dapsmaps
%%
timespec: '+' dist		{ struct timer *timer = data;
				  timer->target_time_rel = $2;
				  timer->is_absolute = FALSE; }
	| absolute		{ struct timer *timer = data;
				  timer->target_time_abs = $1; 
				  timer->is_absolute = TRUE; }
	;

dist:	  sspec
	| mspec stail		{ $$ = $1 + $2; }
	| mspec NUMBER		{ $$ = $1 + $2; }
	| hspec mtail		{ $$ = $1 + $2; }
	| dspec htail		{ $$ = $1 + $2; }
	;

stail:	  /* empty */		{ $$ = 0; }
	| sspec
	;
mtail:	  mspec stail		{ $$ = $1 + $2; }
	| stail
	;
htail:	  hspec mtail		{ $$ = $1 + $2; }
	| mtail
	;

sspec:    NUMBER SECONDS	{ $$ = $1; }
	;
mspec:    NUMBER MINUTES	{ $$ = $1*60.0; }
	;
hspec:    NUMBER HOURS		{ $$ = $1*60.0*60; }
	;
dspec:	  NUMBER DAYS		{ $$ = $1*24.0*60*60; }
	;

absolute: dapsmaps		{ time_t  now = time (NULL);
				  struct tm *broken = localtime (&now);
				  if ($1.tm_year != 0) {
				    broken->tm_year = $1.tm_year;
				    broken->tm_mon = $1.tm_mon;
				    broken->tm_mday = $1.tm_mday;
				  }
				  broken->tm_hour = $1.tm_hour;
				  broken->tm_min = $1.tm_min;
				  broken->tm_sec = $1.tm_sec;
				  broken->tm_isdst = -1;
				  $$ = mktime (broken);
				  if ($$ <= now
				      && $1.tm_year == 0
				      && $$+24*60*60 > now) {
				    $$ += 24*60*60;
				  }
				}
	;
dapsmaps: date hour		{ $$.tm_year = $1.tm_year;
				  $$.tm_mon = $1.tm_mon;
				  $$.tm_mday = $1.tm_mday;
				  $$.tm_hour = $2.tm_hour;
				  $$.tm_min = $2.tm_min;
				  $$.tm_sec = $2.tm_sec;
				}
	| hour			{ $$.tm_year = 0;
				  $$.tm_hour = $1.tm_hour;
				  $$.tm_min = $1.tm_min;
				  $$.tm_sec = $1.tm_sec;
				}
	;
date:     NUMBER '-' NUMBER '-' NUMBER {
				  if ($1 < 100) {
				    $$.tm_year = $1+100;
				  } else if ($1 > 1970) {
				    $$.tm_year = $1-1900;
				  } else {
				    YYABORT;
				  }
				  $$.tm_mon = $3-1;
				  $$.tm_mday = $5;
				}
	;
hour:     NUMBER ':' NUMBER     {
				  $$.tm_hour = $1;
				  $$.tm_min = $3;
				  $$.tm_sec = 0;
				}
	| NUMBER ':' NUMBER ':' NUMBER {
				  $$.tm_hour = $1;
				  $$.tm_min = $3;
				  $$.tm_sec = $5;
				}
	;
%%
static void
yyerror (char *s)
{
  return;
}
