/*
    Sabre Fighter Plane Simulator 
    Copyright (c) 1997/98 Dan Hammer
    Portions Donated By Antti Barck

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*************************************************************
 * fltlite.h                                                 *
 * a lighter flight class for projectiles, etc               *
 * tastes good, less filling                                 *
 *************************************************************/
#ifndef __fltlite_h
#define __fltlite_h

#include "dvmath.h"

#ifndef __flight_h
#include "flight.h"
#endif

extern const float nz;
extern const float wb_damp;
extern float p_height;
extern float time_factor;
extern float world_scale;

class Unguided_Manager;

class FlightLight_Specs
{
public:
  float weight;
  float mass;
  float thrust;
  float drag_factor;
  float lift_factor;
  float time_limit;
  float init_speed;
  float init_pitch_rate;
  float init_yaw_rate;
  float init_roll_rate;

  FlightLight_Specs()
  {
    weight = 0.0;
    mass = 0.0;
    thrust = 0.0;
    drag_factor = 0.0;
    lift_factor = 0.0;
    time_limit = 0.0;
    init_speed = 0.0;
    init_pitch_rate = 0.0;
    init_yaw_rate = 0.0;
    init_roll_rate = 0.0;
  }

  FlightLight_Specs(FlightLight_Specs &fs)
  {
    weight = fs.weight;
    mass = fs.mass;
    thrust = fs.thrust;
    drag_factor = fs.drag_factor;
    lift_factor = fs.lift_factor;
    time_limit = fs.time_limit;
    init_speed = fs.init_speed;
    init_pitch_rate = fs.init_pitch_rate;
    init_yaw_rate = fs.init_yaw_rate;
    init_roll_rate = fs.init_roll_rate;
  }

  FlightLight_Specs & operator =(FlightLight_Specs &fs)
  {
    weight = fs.weight;
    mass = fs.mass;
    thrust = fs.thrust;
    drag_factor = fs.drag_factor;
    lift_factor = fs.lift_factor;
    time_limit = fs.time_limit;
    init_speed = fs.init_speed;
    init_pitch_rate = fs.init_pitch_rate;
    init_yaw_rate = fs.init_yaw_rate;
    init_roll_rate = fs.init_roll_rate;
    return *this;
  }
  
  void read(istream &);
  void write(ostream &);
  friend istream &operator >>(istream &, FlightLight_Specs &fs);
  friend ostream &operator <<(ostream &, FlightLight_Specs &fs);
};



// Keeps track of the current
// forces acting on this flight
class FlightLight_Forces
{
public:
  Vector_Q thrust;	// The thrust generated by the engine
  Vector_Q drag;	// Opposing force of friction along axis
  Vector_Q lift;        //
  Vector_Q g;		// Gravity
};

// This class keeps track of the current state of the
// flight, i.e. its current velocity & orientation.
class FlightLight_State
{
public:
  Vector_Q velocity;			// current velocity
  Port_3D flight_port;			// 3D port which gives us position &
  int on_ground;					// true if on ground
  FlightLight_State()
  {
    on_ground = 0;
  }
};

class FlightLight
{
public:
  float l_time;
  int do_rotations;

  FlightLight_State state;
  //	FlightLight_Forces forces;

  FlightLight_Specs *specs;

  FlightLight(FlightLight_Specs *spcs);
  ~FlightLight()
  { }
  void activate(Flight &);
  void activate(Port_3D &, FlightLight_Specs *,
		R_3DPoint &, Vector &, Vector_Q * = NULL);
  void activate(R_3DPoint &, Vector &);
  void start();
  void update();
  void pause();
  void calc_state();
  //	void calc_forces();
  void apply_forces(float);
  void apply_rotations(float);
  DVector to_port(DVector &);
  DVector to_world(DVector &);
  void set_specs(FlightLight_Specs *spcs);
};

#endif
