/*
 * robwxdlgs.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// visualization: dialogs

#ifndef __RT_WXDIALOGS_H__
#define __RT_WXDIALOGS_H__

#include <wx/wx.h>
#include "robbase.h"
#include "robglob.h"

#include "robwxstruct.h"

class ImprovedListCtrl;

class TourSetupDialog : public wxDialog, public rt::ErrorHandler
{
public:
	TourSetupDialog(TourSetupInfo* data);


	virtual void handleBotError(const rt::Bot* affectedBot, rt::ExecReturnType type) const {}
	virtual void handleLoadError(const lrt::String& affectedFile, const lrt::String& message) const;
	virtual void handleSystemError(int num, const lrt::String& message) const {}

	DECLARE_EVENT_TABLE()
private:
	// helpey functions because it's just insanely complex to do in wxWin
	wxString GetItemText(wxListCtrl* ctrl, long row, int col);
	void GetItemInfo(wxListCtrl* ctrl, long row, int col, wxListItem& info);
	lrt::Vector<long> GetSelectedItems(wxListCtrl* ctrl);
	void SelectOnly(wxListCtrl* ctrl, long row);

	void AddBot(const wxString&);
	void SwapBots(long b1, long b2);

	void OnAdd(wxCommandEvent&);
	void OnRemove(wxCommandEvent&);
	void OnMoveUp(wxCommandEvent&);
	void OnMoveDown(wxCommandEvent&);
	void OnOptionSet(wxCommandEvent&);

	void OnOK(wxCommandEvent&);

	wxString robotPath;
	TourSetupInfo* data;
	rt::Globals assemblyGlob;
	mutable lrt::String loadErrors;
};

class wxCheckListBox;

class BotErrFilterDialog : public wxDialog
{
public:
	BotErrFilterDialog();
	bool Filter(int errnum) { if(allowAny) return allowSpecific[-errnum]; else return false; }

	virtual bool Destroy() { StoreSettings(); return wxDialog::Destroy(); }

	DECLARE_EVENT_TABLE()
private:
	void LoadSettings();
	void StoreSettings();

	void OnToggleAny(wxCommandEvent&);
	void OnToggleSpecific(wxCommandEvent&);

	void OnCloseButton(wxCommandEvent&) { StoreSettings(); Hide(); }
	void OnCloseWindow(wxCloseEvent&) { StoreSettings(); Hide(); }

	bool allowAny;
	lrt::Array<bool> allowSpecific;

	wxCheckBox* anyCB;
	wxCheckListBox* specificCLB;
};

class BotPainter; 

class ProgramColourDialog : public wxDialog 
{
public:
	ProgramColourDialog(const BotPainter& prevSettings);
	~ProgramColourDialog();

	BotPainter& GetPainter() { return *painter; }

private:
	BotPainter* painter; 
};


class DebugDialog : public wxDialog
{
public:
	DebugDialog(DebugInfo& initialInfo);
	~DebugDialog();

	void HandleUpdate(DebugInfo& newInfo, bool first = false); // evt_debug_update
	void HandleProgramColourChange();

	DECLARE_EVENT_TABLE()
private:
	void StoreSettings();
	void LoadSettings();

	void FindWindows();
	void SetupColumns();
	void SetLCLength(wxListCtrl* lc, long numEntries); // makes sure that exactly numEntries exist in lc

	void UpdateTaskData(DebugInfo& info, bool force = false);
	void UpdateInstrList(DebugInfo& info);
	void UpdateBankImageList();

	void OnTask(wxCommandEvent&);
	void OnFollow(wxCommandEvent&);
	void OnBankList(wxListEvent&);

	void OnCloseWindow(wxCloseEvent&);

	DebugInfo info;

	// wxComponentPointers
	wxCheckBox* followCB;
	wxSlider* taskSL;

	ImprovedListCtrl* bankLC;
	wxListBox* instrLB;
	ImprovedListCtrl* unnamedVarLC;
	lrt::Array<wxStaticText*> namedVarT;
	wxPanel* colourP;
	wxPanel* taskViewP;
	wxStaticText* programT;
	wxStaticText* taskNumT;
	wxStaticText* curInstrT;
	wxStaticText* curBankT;
	wxStaticText* curInstrTextT;

	// status
	int curBank, curTask;
	bool follow;
};

#endif


//#define DD_INSTRSET 10014
//#define DD_MOBILE 10015
//#define DD_GENERATION 10016
//#define DD_ACTIVE 10017
//#define DD_XPOS 10018
//#define DD_YPOS 10019
//#define DD_COLOUR 10020
//#define DD_FOLLOW 10021
//#define DD_BANKS 10022
//#define DD_PROGRAM 10023
//#define DD_TASK 10024
//#define DD_TASKNUM 10025
//#define DD_CURINSTR 10026
//#define DD_CURBANK 10027
//#define DD_BOTPAINT 10028
//#define DD_CURINSTRTEXT 10029
//#define DD_INSTR 10030
//#define DD_VARIABLES 10031
