#ifndef ROBODOC_CONFIG_H
#define ROBODOC_CONFIG_H


typedef enum
{
    CFL_REMARK = 0,
    CFL_PARAMETER,
    CFL_SECTION,
    CFL_EMPTYLINE,
    CFL_UNKNOWN
} T_Line_Kind;

typedef enum
{
    SK_ITEMS = 0,
    SK_IGNOREITEMS,
    SK_OPTIONS,
    SK_EXTENSIONS,
    SK_HEADERTYPES,
    SK_IGNORE_FILES,
    SK_UNKNOWN
} T_Block_Kind;


/****s* Configuration/Parameters
 * FUNCTION
 *    Structure to store all the paramters found in a block in the
 *    robodoc configuation file.
 * ATTRIBUTES
 *    number -- the number of parameters found.
 *    size   -- the maximum size of the names array.
 *    names  -- an array with the values of the parameters.
 * NOTES
 *    Find a better name for the attribute 'names'
 * SOURCE
 */

struct Parameters {
    unsigned int        number;
    unsigned int        size;
    char              **names;  
};

/*****/


/****s* Configuration/RB_Configuration
 * FUNCTION
 *   All the data from the robodoc.rc file is stored in this
 *   structure.
 * ATTRIBUTES
 *   itemnames       -- an array with names that robodoc recognizes as
 *                      items.  Alsways includes the name "SOURCE" as
 *                      the first element.
 *   ignore_items    -- an array with the names of items that ROBODoc
 *                      should ignore.
 *
 *
 *   options         -- Array with all options specified both on the
 *                      commandline as well as in the robodoc.rc file.
 *   custom_headertypes -- list with custom header types.
 *   ignore_files    -- list with wildcard expressions that specifies
 *                      files and directories that robodoc should skip
 *                      while scanning the source tree.
 * SOURCE
 */

struct RB_Configuration
{
    /* Itemnames  */
    unsigned int        no_items;
    char              **item_names;     /* Array with itemnames. */
    /* IgnoreItems */
    unsigned int        no_ignore_items;
    char              **ignore_items;

    /* TODO, the following mechanism should also be used
     * for the above arrays.
     */
    struct Parameters   options;
    struct Parameters   custom_headertypes;
    struct Parameters   ignore_files;
};

/*******/

char               *RB_GetParameter( char *line );
void                RB_ReadConfiguration( unsigned int argc, char **argv, char* filename );
void                RB_StripCR( char *line );
void                RB_Free_Configuration( void );

extern struct RB_Configuration configuration;

#endif
