# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("File", "IO", "class")
aClass.addFragment(Paragraph.new("A <code>File</code> is an abstraction of any file object accessible by the program and is closely associated with class <code>IO</code>, page 329. <code>File</code> includes the methods of module <code>FileTest</code> as class methods, allowing you to write (for example) <code>File.exist?(\"foo\")</code>.\n"))
aClass.addFragment(Paragraph.new("In this section, <em>permission bits</em> are a platform-specific set of bits that indicate permissions of a file. On Unix-based systems, permissions are viewed as a set of three octets, for the owner, the group, and the rest of the world. For each of these entities, permissions may be set to read, write, or execute (or search, if a directory) the file:\n"))
aClass.addFragment(Paragraph.new("The permission bits <code>0644</code> (in octal) would thus be interpreted as read/write for owner, and read-only for group and other. Higher-order bits may also be used to indicate the type of file (plain, directory, pipe, socket, and so on) and various other special features.\n"))
aClass.addFragment(Paragraph.new("On non-Posix operating systems, there may be only the ability to make a file read-only or not. In this case, the remaining permission bits will be synthesized to resemble typical values. For instance, on Windows NT the default permission bits are <code>0644</code>, which means read/write for owner, read-only for all others. The only change that can be made is to make the file read-only, which is reported as <code>0444</code>.\n"))
m0002 = MethodDesc.new("atime", "class", "File.atime( <i>fileName</i> ) -> <i>aTime</i>")
m0002.addFragment(Paragraph.new("Returns the last access time for the named file.\n"))
m0002.addFragment(Verbatim.new("File.atime(\"testfile\")   \#=> Sun Mar 04 23:25:54 CST 2001\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("basename", "class", "File.basename( <i>fileName</i> <i>[</i>, <i>aSuffix</i><i>]</i> ) -> <i>aNewString</i>")
m0003.addFragment(Paragraph.new("Returns the last component of the filename given in <i>fileName</i>, which must be formed using forward slashes (``<code>/</code>'') regardless of the separator used on the local file system. If <i>aSuffix</i> is given and present at the end of <i>fileName</i>, it is removed.\n"))
m0003.addFragment(Verbatim.new("File.basename(\"/home/gumby/work/ruby.rb\")          \#=> \"ruby.rb\"\nFile.basename(\"/home/gumby/work/ruby.rb\", \".rb\")   \#=> \"ruby\"\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("chmod", "class", "File.chmod( <i>aModeInt</i> <i>[</i>, <i>fileName</i><i>]+></i> ) -> <i>anInteger</i>")
m0004.addFragment(Paragraph.new("Changes permission bits on the named file(s) to the bit pattern represented by <i>aModeInt</i>. Actual effects are operating system dependent (see the beginning of this section). On Unix systems, see <code>chmod(2)</code> for details. Returns the number of files processed.\n"))
m0004.addFragment(Verbatim.new("File.chmod(0644, \"testfile\", \"out\")   \#=> 2\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("chown", "class", "File.chown( <i>anOwnerInt</i>, <i>aGroupInt</i> <i>[</i>, <i>fileName</i><i>]+></i> ) -> <i>anInteger</i>")
m0005.addFragment(Paragraph.new("Changes the owner and group of the named file(s) to the given numeric owner and group id's. Only a process with superuser privileges may change the owner of a file. The current owner of a file may change the file's group to any group to which the owner belongs. A <code>nil</code> or -1 owner or group id is ignored. Returns the number of files processed.\n"))
m0005.addFragment(Verbatim.new("File.chown(nil, 100, \"testfile\")"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("ctime", "class", "File.ctime( <i>fileName</i> ) -> <i>aTime</i>")
m0006.addFragment(Paragraph.new("Returns the change time for the named file (the time at which directory information about the file was changed, not the file itself).\n"))
m0006.addFragment(Verbatim.new("File.ctime(\"testfile\")   \#=> Sun Mar 04 23:28:25 CST 2001\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("delete", "class", "File.delete( <i>[</i><i>fileName</i><i>]+></i> ) -> <i>aFixnum</i>")
m0007.addFragment(Paragraph.new("Deletes the named file(s). Returns the number of files processed. See also <code>Dir::rmdir</code>.\n"))
m0007.addFragment(Verbatim.new("File.new(\"testrm\", \"w+\").close   \#=> nil\nFile.delete(\"testrm\")            \#=> 1\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("dirname", "class", "File.dirname( <i>fileName</i> ) -> <i>fileName</i>")
m0008.addFragment(Paragraph.new("Returns all components of the filename given in <i>fileName</i> except the last one. The filename must be formed using forward slashes (``<code>/</code>'') regardless of the separator used on the local file system.\n"))
m0008.addFragment(Verbatim.new("File.dirname(\"/home/gumby/work/ruby.rb\")   \#=> \"/home/gumby/work\"\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("expand_path", "class", "File.expand_path( <i>fileName</i> <i>[</i>, <i>aDirString</i><i>]</i> ) -> <i>fileName</i>")
m0009.addFragment(Paragraph.new("Converts a pathname to an absolute pathname. Relative paths are referenced from the current working directory of the process unless <i>aDirString</i> is given, in which case it will be used as the starting point. The given pathname may start with a ``<code>~</code>'', which expands to the process owner's home directory (the environment variable <code>HOME</code> must be set correctly). ``<code>~</code><i>user</i>'' expands to the named user's home directory.\n"))
m0009.addFragment(Verbatim.new("File.expand_path(\"~oracle/bin\")           \#=> \"/home/oracle/bin\"\nFile.expand_path(\"../../bin\", \"/tmp/x\")   \#=> \"/bin\"\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("ftype", "class", "File.ftype( <i>fileName</i> ) -> <i>fileType</i>")
m0010.addFragment(Paragraph.new("Identifies the type of the named file; the return string is one of ``<code>file</code>'', ``<code>directory</code>'', ``<code>characterSpecial</code>'', ``<code>blockSpecial</code>'', ``<code>fifo</code>'', ``<code>link</code>'', or ``<code>socket</code>''.\n"))
m0010.addFragment(Verbatim.new("File.ftype(\"testfile\")            \#=> \"file\"\nFile.ftype(\"/dev/tty\")            \#=> \"characterSpecial\"\nFile.ftype(\"/tmp/.X11-unix/X0\")   \#=> \"socket\"\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("join", "class", "File.join( <i>[</i><i>aString</i><i>]+></i> ) -> <i>fileName</i>")
m0011.addFragment(Paragraph.new("Returns a new string formed by joining the strings using <code>File::SEPARATOR</code> (see Table 22.2 on page 308).\n"))
m0011.addFragment(Verbatim.new("File.join(\"usr\", \"mail\", \"gumby\")   \#=> \"usr/mail/gumby\"\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("link", "class", "File.link( <i>anOldName</i>, <i>aNewName</i> ) -> 0")
m0012.addFragment(Paragraph.new("Creates a new name for an existing file using a hard link. Will not overwrite <i>aNewName</i> if it already exists (raising a subclass of <code>SystemCallError</code>). Not available on all platforms.\n"))
m0012.addFragment(Verbatim.new("File.link(\"testfile\", \".testfile\")   \#=> 0\nIO.readlines(\".testfile\")[0]         \#=> \"This is line one\\n\"\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("lstat", "class", "File.lstat( <i>fileName</i> ) -> <i>aStat</i>")
m0013.addFragment(Paragraph.new("Same as <code>IO\#stat</code>, but does not follow the last symbolic link. Instead, reports on the link itself.\n"))
m0013.addFragment(Verbatim.new("File.symlink(\"testfile\", \"link2test\")   \#=> 0\nFile.stat(\"testfile\").size              \#=> 66\nFile.lstat(\"link2test\").size            \#=> 8\nFile.stat(\"link2test\").size             \#=> 66\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("mtime", "class", "File.mtime( <i>fileName</i> ) -> <i>aTime</i>")
m0014.addFragment(Paragraph.new("Returns the modification time for the named file.\n"))
m0014.addFragment(Verbatim.new("File.mtime(\"testfile\")   \#=> Tue Feb 27 00:11:18 CST 2001\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("new", "class", "File.new( <i>fileName</i>, <i>aModeString</i>=\"r\" ) -> <i>file</i><br></br>File.new( <i>fileName</i> <i>[</i>, <i>aModeNum</i> <i>[</i><i>aPermNum</i><i>]</i><i>]</i> ) -> <i>file</i>")
m0015.addFragment(Paragraph.new("Opens the file named by <i>fileName</i> according to <i>aModeString</i> (default is ``r'') and returns a new <code>File</code> object. See Table 22.5 on page 331 for a description of <i>aModeString</i>. The file mode may optionally be specified as a <code>Fixnum</code> by <em>or</em>-ing together the flags described in Table 22.3 on page 309. Optional permission bits may be given in <i>aPermNum</i>. These mode and permission bits are platform dependent; on Unix systems, see <code>open(2)</code> for details.\n"))
m0015.addFragment(Verbatim.new("f = File.new(\"testfile\", \"r\")\nf = File.new(\"newfile\",  \"w+\")\nf = File.new(\"newfile\", File::CREAT|File::TRUNC|File::RDWR, 0644)"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("open", "class", "File.open( <i>fileName</i>, <i>aModeString</i>=\"r\" ) -> <i>file</i><br></br>File.open( <i>fileName</i> <i>[</i>, <i>aModeNum</i> <i>[</i><i>aPermNum</i><i>]</i><i>]</i> ) -> <i>file</i><br></br>File.open( <i>fileName</i>, <i>aModeString</i>=\"r\" ) {| <i>file</i> | block } -> <code>nil</code><br></br>File.open( <i>fileName</i> <i>[</i>, <i>aModeNum</i> <i>[</i><i>aPermNum</i><i>]</i><i>]</i> ) {| <i>file</i> | block } -> <code>nil</code><br></br>")
m0016.addFragment(Paragraph.new("With no associated block, <code>open</code> is a synonym for <code>File::new</code>. If the optional code block is given, it will be passed <i>file</i> as an argument, and the file will automatically be closed when the block terminates. In this instance, <code>File::open</code> returns <code>nil</code>.\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("readlink", "class", "File.readlink( <i>fileName</i> ) -> <i>fileName</i>")
m0017.addFragment(Paragraph.new("Returns the given symbolic link as a string. Not available on all platforms.\n"))
m0017.addFragment(Verbatim.new("File.symlink(\"testfile\", \"link2test\")   \#=> 0\nFile.readlink(\"link2test\")              \#=> \"testfile\"\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("rename", "class", "File.rename( <i>anOldName</i>, <i>aNewName</i> ) -> 0")
m0018.addFragment(Paragraph.new("Renames the given file to the new name. Raises a <code>SystemCallError</code> if the file cannot be renamed.\n"))
m0018.addFragment(Verbatim.new("File.rename(\"afile\", \"afile.bak\")   \#=> 0\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("size", "class", "File.size( <i>fileName</i> ) -> <i>anInteger</i>")
m0019.addFragment(Paragraph.new("Returns the size of the file in bytes.\n"))
m0019.addFragment(Verbatim.new("File.size(\"testfile\")   \#=> 66\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("split", "class", "File.split( <i>fileName</i> ) -> <i>anArray</i>")
m0020.addFragment(Paragraph.new("Splits the given string into a directory and a file component and returns them in a two-element array. See also <code>File::dirname</code> and <code>File::basename</code>.\n"))
m0020.addFragment(Verbatim.new("File.split(\"/home/gumby/.profile\")   \#=> [\"/home/gumby\", \".profile\"]\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("stat", "class", "File.stat( <i>fileName</i> ) -> <i>aStat</i>")
m0021.addFragment(Paragraph.new("Returns a <code>File::Stat</code> object for the named file (see <code>File::Stat</code>, page 313).\n"))
m0021.addFragment(Verbatim.new("File.stat(\"testfile\").mtime   \#=> Tue Feb 27 00:11:18 CST 2001\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("symlink", "class", "File.symlink( <i>anOldName</i>, <i>aNewName</i> ) -> 0 or <code>nil</code>")
m0022.addFragment(Paragraph.new("Creates a symbolic link called <i>aNewName</i> for the existing file <i>anOldName</i>. Returns <code>nil</code> on all platforms that do not support symbolic links.\n"))
m0022.addFragment(Verbatim.new("File.symlink(\"testfile\", \"link2test\")   \#=> 0\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("truncate", "class", "File.truncate( <i>fileName</i>, <i>anInteger</i> ) -> 0")
m0023.addFragment(Paragraph.new("Truncates the file <i>fileName</i> to be at most <i>anInteger</i> bytes long. Not available on all platforms.\n"))
m0023.addFragment(Verbatim.new("f = File.new(\"out\", \"w\")\nf.write(\"1234567890\")     \#=> 10\nf.close                   \#=> nil\nFile.truncate(\"out\", 5)   \#=> 0\nFile.size(\"out\")          \#=> 5\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("umask", "class", "File.umask( <i>[</i><i>anInteger</i><i>]</i> ) -> <i>anInteger</i>")
m0024.addFragment(Paragraph.new("Returns the current umask value for this process. If the optional argument is given, set the umask to that value and return the previous value. Umask values are <em>subtracted</em> from the default permissions; so a umask of <code>0222</code> would make a file read-only for everyone. See also the discussion of permissions on page 305.\n"))
m0024.addFragment(Verbatim.new("File.umask(0006)   \#=> 18\nFile.umask         \#=> 6\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("unlink", "class", "File.unlink( <i>[</i><i>fileName</i><i>]+></i> ) -> <i>anInteger</i>")
m0025.addFragment(Paragraph.new("Synonym for <code>File::delete</code>. See also <code>Dir::rmdir</code>.\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("utime", "class", "File.utime( <i>anAccessTime</i>, <i>aModTime</i> <i>[</i>, <i>fileName</i><i>]+></i> ) -> <i>aFixnum</i>")
m0026.addFragment(Paragraph.new("Changes the access and modification times on a number of files. The times must be instances of class <code>Time</code> or integers representing the number of seconds since epoch. Returns the number of files processed. Not available on all platforms.\n"))
m0026.addFragment(Verbatim.new("File.utime(0, 0, \"testfile\")          \#=> 1\nFile.mtime(\"testfile\")                \#=> Wed Dec 31 18:00:00 CST 1969\nFile.utime(0, Time.now, \"testfile\")   \#=> 1\nFile.mtime(\"testfile\")                \#=> Sun Mar 04 23:28:25 CST 2001\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("atime", "instance", "<i>file</i>.atime -> <i>aTime</i>")
m0027.addFragment(Paragraph.new("Returns the last access time for <i>file</i>, or epoch if <i>file</i> has not been accessed.\n"))
m0027.addFragment(Verbatim.new("File.new(\"testfile\").atime   \#=> Wed Dec 31 18:00:00 CST 1969\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("chmod", "instance", "<i>file</i>.chmod( <i>aModeInt</i> ) -> <code>0</code>")
m0028.addFragment(Paragraph.new("Changes permission bits on <i>file</i> to the bit pattern represented by <i>aModeInt</i>. Actual effects are platform dependent; on Unix systems, see <code>chmod(2)</code> for details. See the discussion of permissions on page 305.\n"))
m0028.addFragment(Verbatim.new("f = File.new(\"out\", \"w\");\nf.chmod(0644)   \#=> 0\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("chown", "instance", "<i>file</i>.chown( <i>anOwnerInt</i>, <i>aGroupInt</i> ) -> 0")
m0029.addFragment(Paragraph.new("Changes the owner and group of <i>file</i> to the given numeric owner and group id's. Only a process with superuser privileges may change the owner of a file. The current owner of a file may change the file's group to any group to which the owner belongs. A <code>nil</code> or -1 owner or group id is ignored.\n"))
m0029.addFragment(Verbatim.new("File.new(\"testfile\").chown(502, 1000)"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("ctime", "instance", "<i>file</i>.ctime -> <i>aTime</i>")
m0030.addFragment(Paragraph.new("Returns the change time for <i>file</i> (that is, the time directory information about the file was changed, not the file itself).\n"))
m0030.addFragment(Verbatim.new("File.new(\"testfile\").ctime   \#=> Sun Mar 04 23:28:25 CST 2001\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("flock", "instance", "<i>file</i>.flock ( <i>aLockingConstant</i> ) -> 0 or <code>false</code>")
m0031.addFragment(Paragraph.new("Locks or unlocks a file according to <i>aLockingConstant</i> (a logical <em>or</em> of the values in Table 22.4 on page 312). Returns <code>false</code> if <code>File::LOCK_NB</code> is specified and the operation would otherwise have blocked. Not available on all platforms.\n"))
m0031.addFragment(Verbatim.new("File.new(\"testfile\").flock(File::LOCK_UN)   \#=> 0\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("lstat", "instance", "<i>file</i>.lstat -> <i>aStat</i>")
m0032.addFragment(Paragraph.new("Same as <code>IO\#stat</code>, but does not follow the last symbolic link. Instead, reports on the link itself.\n"))
m0032.addFragment(Verbatim.new("File.symlink(\"testfile\", \"link2test\")   \#=> 0\nFile.stat(\"testfile\").size              \#=> 66\nf = File.new(\"link2test\")\nf.lstat.size                            \#=> 8\nf.stat.size                             \#=> 66\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("mtime", "instance", "<i>file</i>.mtime -> <i>aTime</i>")
m0033.addFragment(Paragraph.new("Returns the modification time for <i>file</i>.\n"))
m0033.addFragment(Verbatim.new("File.new(\"testfile\").mtime   \#=> Sun Mar 04 23:28:25 CST 2001\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("path", "instance", "<i>file</i>.path -> <i>fileName</i>")
m0034.addFragment(Paragraph.new("Returns the pathname used to create <i>file</i> as a string.\n"))
m0034.addFragment(Verbatim.new("File.new(\"testfile\").path   \#=> \"testfile\"\n"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("truncate", "instance", "<i>file</i>.truncate( <i>anInteger</i> ) -> 0")
m0035.addFragment(Paragraph.new("Truncates <i>file</i> to at most <i>anInteger</i> bytes. The file must be opened for writing. Not available on all platforms.\n"))
m0035.addFragment(Verbatim.new("f = File.new(\"out\", \"w\")\nf.syswrite(\"1234567890\")   \#=> 10\nf.truncate(5)              \#=> 0\nf.close()                  \#=> nil\nFile.size(\"out\")           \#=> 5\n"))
aClass.addMethod(m0035)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
