# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Enumerable", "", "module")
aClass.addFragment(Paragraph.new("The <code>Enumerable</code> mixin provides collection classes with several traversal and searching methods, and with the ability to sort. The class must provide a method <code>each</code>, which yields successive members of the collection. If <code>Enumerable\#max</code>, <code>\#min</code>, or <code>\#sort</code> is used, the objects in the collection must also implement a meaningful <code><=></code> operator, as these methods rely on an ordering between members of the collection.\n"))
m0002 = MethodDesc.new("collect", "instance", "<i>enumObj</i>.collect {| obj | block } <p></p> -> <i>anArray</i>")
m0002.addFragment(Paragraph.new("Returns a new array with the results of running <em>block</em> once for every element in <i>enumObj</i>.\n"))
m0002.addFragment(Verbatim.new("(1..4).collect {|i| i*i }   \#=> [1, 4, 9, 16]\n(1..4).collect { \"cat\"  }   \#=> [\"cat\", \"cat\", \"cat\", \"cat\"]\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("detect", "instance", "<i>enumObj</i>.detect {| obj | block } <p></p> -> <i>anObject</i> or <code>nil</code>")
m0003.addFragment(Paragraph.new("Passes each entry in <i>enumObj</i> to <em>block</em>. Returns the first for which <em>block</em> is not <code>false</code>. Returns <code>nil</code> if no object matches.\n"))
m0003.addFragment(Verbatim.new("(1..10).detect  {|i| i % 5 == 0 and i % 7 == 0 }   \#=> nil\n(1..100).detect {|i| i % 5 == 0 and i % 7 == 0 }   \#=> 35\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("each_with_index", "instance", "<i>enumObj</i>.each_with_index {| obj, i | block } <p></p> -> <code>nil</code>")
m0004.addFragment(Paragraph.new("Calls <em>block</em> with two arguments, the item and its index, for each item in <i>enumObj</i>.\n"))
m0004.addFragment(Verbatim.new("hash = Hash.new\n%w(cat dog wombat).each_with_index {|item, index|\n  hash[item] = index\n}\nhash   \#=> {\"dog\"=>1, \"wombat\"=>2, \"cat\"=>0}\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("entries", "instance", "<i>enumObj</i>.entries -> <i>anArray</i>")
m0005.addFragment(Paragraph.new("Synonym for <code>Enumerable\#to_a</code>.\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("find", "instance", "<i>enumObj</i>.find {| obj | block } <p></p> -> <i>anObject</i> or <code>nil</code>")
m0006.addFragment(Paragraph.new("Synonym for <code>Enumerable\#detect</code>.\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("find_all", "instance", "<i>enumObj</i>.find_all {| obj | block } <p></p> -> <i>anArray</i>")
m0007.addFragment(Paragraph.new("Returns an array containing all elements of <i>enumObj</i> for which <em>block</em> is not <code>false</code> (see also <code>Enumerable\#reject</code>).\n"))
m0007.addFragment(Verbatim.new("(1..10).find_all {|i|  i % 3 == 0 }   \#=> [3, 6, 9]\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("grep", "instance", "<i>enumObj</i>.grep( <i>pattern</i> ) -> <i>anArray</i><br></br><i>enumObj</i>.grep( <i>pattern</i> ) {| obj | block } -> <i>anArray</i>")
m0008.addFragment(Paragraph.new("Returns an array of every element in <i>enumObj</i> for which <code>Pattern === element</code>. If the optional <em>block</em> is supplied, each matching element is passed to it, and the block's result is stored in the output array.\n"))
m0008.addFragment(Verbatim.new("(1..100).grep 38..44   \#=> [38, 39, 40, 41, 42, 43, 44]\nc = IO.constants\nc.grep(/SEEK/)         \#=> [\"SEEK_END\", \"SEEK_CUR\", \"SEEK_SET\"]\nres = c.grep(/SEEK/) {|v| IO.const_get(v) }\nres                    \#=> [2, 1, 0]\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("include?", "instance", "<i>enumObj</i>.include?( <i>anObject</i> ) -> <code>true</code> or <code>false</code>")
m0009.addFragment(Paragraph.new("Returns <code>true</code> if any member of <i>enumObj</i> equals <i>anObject</i>. Equality is tested using <code>==</code>.\n"))
m0009.addFragment(Verbatim.new("IO.constants.include? \"SEEK_SET\"          \#=> true\nIO.constants.include? \"SEEK_NO_FURTHER\"   \#=> false\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("map", "instance", "<i>enumObj</i>.map {| obj | block } <p></p> -> <i>anArray</i>")
m0010.addFragment(Paragraph.new("Synonym for <code>Enumerable\#collect</code>.\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("max", "instance", "<i>enumObj</i>.max -> <i>anObject</i><br></br><i>enumObj</i>.max {| a,b | block } -> <i>anObject</i>")
m0011.addFragment(Paragraph.new("Returns the object in <i>enumObj</i> with the maximum value. The first form assumes all objects implement <code>Comparable</code>; the second uses the block to return <em>a <=> b</em>.\n"))
m0011.addFragment(Verbatim.new("a = %w(albatross dog horse)\na.max                                  \#=> \"horse\"\na.max {|a,b| a.length <=> b.length }   \#=> \"albatross\"\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("member?", "instance", "<i>enumObj</i>.member?( <i>anObject</i> ) -> <code>true</code> or <code>false</code>")
m0012.addFragment(Paragraph.new("Synonym for <code>Enumerable\#include?</code>.\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("min", "instance", "<i>enumObj</i>.min -> <i>anObject</i><br></br><i>enumObj</i>.min {| a,b | block } -> <i>anObject</i>")
m0013.addFragment(Paragraph.new("Returns the object in <i>enumObj</i> with the minimum value. The first form assumes all objects implement <code>Comparable</code>; the second uses the block to return <em>a <=> b</em>.\n"))
m0013.addFragment(Verbatim.new("a = %w(albatross dog horse)\na.min                                  \#=> \"albatross\"\na.min {|a,b| a.length <=> b.length }   \#=> \"dog\"\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("reject", "instance", "<i>enumObj</i>.reject {| obj | block } <p></p> -> <i>anArray</i>")
m0014.addFragment(Paragraph.new("Returns an array for all elements of <i>enumObj</i> for which <em>block</em> is <code>false</code> (see also <code>Enumerable\#find_all</code>).\n"))
m0014.addFragment(Verbatim.new("(1..10).reject {|i|  i % 3 == 0 }   \#=> [1, 2, 4, 5, 7, 8, 10]\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("select", "instance", "<i>enumObj</i>.select {| obj | block } <p></p> -> <i>anArray</i>")
m0015.addFragment(Paragraph.new("Synonym for <code>Enumerable\#find_all</code>.\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("sort", "instance", "<i>enumObj</i>.sort -> <i>anArray</i><br></br><i>enumObj</i>.sort {| a, b | block } -> <i>anArray</i>")
m0016.addFragment(Paragraph.new("Returns an array containing the items in <i>enumObj</i> sorted, either according to their own <code><=></code> method, or by using the results of the supplied block. The block should return -1, 0, or +1 depending on the comparison between <i>a</i> and <i>b</i>.\n"))
m0016.addFragment(Verbatim.new("%w(rhea kea flea).sort         \#=> [\"flea\", \"kea\", \"rhea\"]\n(1..10).sort {|a,b| b <=> a}   \#=> [10, 9, 8, 7, 6, 5, 4, 3, 2, 1]\n"))
m0016.addFragment(Paragraph.new("The following code sorts some files on modification time.\n"))
m0016.addFragment(Verbatim.new("files = Dir[\"*\"]\nsorted = files.sort {|a,b| File.new(a).mtime <=> File.new(b).mtime}\nsorted   \#=> [\"mon\", \"tues\", \"wed\", \"thurs\"]\n"))
m0016.addFragment(Paragraph.new("This sort is inefficient: it generates two new <code>File</code> objects during every comparison. A slightly better technique is to use the <code>Kernel\#test</code> method to generate the modification times directly.\n"))
m0016.addFragment(Verbatim.new("files = Dir[\"*\"]\nsorted = files.sort { |a,b|\n  test(?M, a) <=> test(?M, b)\n}\nsorted   \#=> [\"mon\", \"tues\", \"wed\", \"thurs\"]\n"))
m0016.addFragment(Paragraph.new("This still generates many unnecessary <code>Time</code> objects. A more efficient technique is to cache the sort keys (modification times in this case) before the sort. Perl users often call this approach a Schwartzian Transform, after Randal Schwartz. We construct a temporary array, where each element is an array containing our sort key along with the filename. We sort this array, and then extract the filename from the result.\n"))
m0016.addFragment(Verbatim.new("sorted = Dir[\"*\"].collect { |f|\n   [test(?M, f), f]\n}.sort.collect { |f| f[1] }\nsorted   \#=> [\"mon\", \"tues\", \"wed\", \"thurs\"]\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("to_a", "instance", "<i>enumObj</i>.to_a -> <i>anArray</i>")
m0017.addFragment(Paragraph.new("Returns an array containing the items in <i>enumObj</i>.\n"))
m0017.addFragment(Verbatim.new("(1..7).to_a                       \#=> [1, 2, 3, 4, 5, 6, 7]\n{ 'a'=>1, 'b'=>2, 'c'=>3 }.to_a   \#=> [[\"a\", 1], [\"b\", 2], [\"c\", 3]]\n"))
aClass.addMethod(m0017)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
