### pkgInfo object system

setClass("pkgInfo", representation(pkgName="character",
                                   pkgVersion="VersionNumber",
                                   pkgRelLevel="character",
                                   pkgContains="character",
                                   pkgPath="character"))

if (is.null(getGeneric("pkgName")))
    setGeneric("pkgName", function(object)
               standardGeneric("pkgName"))

if (is.null(getGeneric("pkgVersion")))
    setGeneric("pkgVersion", function(object)
               standardGeneric("pkgVersion"))

if (is.null(getGeneric("pkgRelLevel")))
    setGeneric("pkgRelLevel", function(object)
               standardGeneric("pkgRelLevel"))

if (is.null(getGeneric("pkgPath")))
    setGeneric("pkgPath", function(object)
               standardGeneric("pkgPath"))

if (is.null(getGeneric("pkgContains")))
    setGeneric("pkgContains", function(object)
               standardGeneric("pkgContains"))

if (is.null(getGeneric("==")))
    setGeneric("==", function(e1, e2)
                   standardGeneric("=="))

setMethod("pkgRelLevel", "pkgInfo", function(object)
          object@pkgRelLevel)

    setMethod("pkgName", "pkgInfo", function(object)
              object@pkgName)
    setMethod("pkgVersion", "pkgInfo", function(object)
              object@pkgVersion)
    setMethod("pkgPath", "pkgInfo", function(object)
              object@pkgPath)
setMethod("pkgContains", "pkgInfo", function(object)
          object@pkgContains)


    setMethod("==","pkgInfo", function(e1, e2) {
        if (!is(e2, "pkgInfo"))
            stop("Right hand argument is not of class 'pkgInfo'")

        if (pkgName(e1) != pkgName(e2))
            return(FALSE)
        if (pkgVersion(e1) != pkgVersion(e2))
            return(FALSE)
        pathA <- pkgPath(e1)
        pathB <- pkgPath(e2)
        if (length(pathA) != length(pathB))
            return(FALSE)
        if ((length(pathA) > 0)&&(pkgPath(e1) != pkgPath(e2)))
            return(FALSE)
        TRUE
    })

    setMethod("show","pkgInfo",function(object) {
        if (length(as.character(pkgVersion(object))) > 0)
            print(paste(pkgName(object),": ",
                        stringRep(pkgVersion(object)),sep=""))
        else
            print(pkgName(object))
    })


buildPkgInfo <- function(name, vers, path="", relLevel="release",
                         contains=character()) {
    if (missing(name))
        stop("Need a package name")

     if (missing(vers)) {
        if (missing(path))
            return(new("pkgInfo",pkgName=name,
                       pkgVersion=new("VersionNumber"),
                       pkgRelLevel=relLevel,
                       pkgContains=contains))
        else
            return(new("pkgInfo",pkgName=name,
                       pkgVersion=new("VersionNumber"), pkgPath=path,
                       pkgRelLevel=relLevel, pkgContains=contains))
    }
    else {
        if (is.character(vers)) {
            vers <- buildVersionNumber(vers)
        }
        if (missing(path))
            return(new("pkgInfo",pkgName=name,pkgVersion=vers,
                       pkgRelLevel=relLevel, pkgContains=contains))
        else
           return(new("pkgInfo",pkgName=name,pkgVersion=vers,pkgPath=path,
                      pkgRelLevel=relLevel, pkgContains=contains))
    }
}

