#define SPRAY
#ifndef lint
static char *rcsid =
	"@(#)$Header: traceroute.c,v 2.9.2 1999/02/26 gavron(gavron@aces.com)";
#endif
#define TR_VERSION "2.9.2tee0.0"

#include <config.h>
#include <stdio.h>

#define IP_VERSION 4	/* We can't work with anything else... */
#define CISCO_ICMP 1	/* We check for loss+unreachables = probes */

/* if we haven't got it, soldier on; maybe it'll work */
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

#ifdef _AIX		/* Aix has its own set of fd_* macros */
#include <sys/select.h>           
#endif

/* need one of these */
#ifdef HAVE_STRING_H
#include <string.h>
#else
#ifdef HAVE_STRINGS_H
#include <strings.h>
#else
#error "don't have either strings.h or string.h"
#endif /* HAVE_STRINGS_H */
#endif /* HAVE_STRING_H */

#include <sys/param.h>

#ifndef HAVE_STRCHR
#ifdef HAVE_INDEX
#define strchr(x,y) index(x,y) /* Use ansi strchr() if no index() */
#else
#error "don't have either strchr or index"
#endif /* HAVE_INDEX */
#endif /* HAVE_STRCHR */

#ifndef HAVE_BZERO
#ifdef HAVE_MEMSET
#define bzero(x,y) memset((void *)x,(int)0,(size_t) y)
#else
#error "don't have either bzero or memset"
#endif /* HAVE_MEMSET */
#endif /* HAVE_BZERO */

#ifndef HAVE_BCOPY
#ifdef HAVE_MEMCPY
#define bcopy(x,y,z) memcpy((void *)y, (const void *)x, (size_t) z)
#else
#error "don't have either bcopy or memcpy"
#endif /* HAVE_MEMCPY */
#endif /* HAVE_BCOPY */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>		/* For atof(), etc. */
#else
#error "don't have stdlib.h"
#endif /* HAVE_STDLIB_H */


#ifdef HAVE_UNISTD_H
#include <unistd.h>		/* For getpid(), etc. */
#else
#error "don't have unistd.h and I don't know how to work around"
#endif /* HAVE_UNISTD_H */

/* _POSIX_VERSION will be defined by unistd.h if it's POSIX.1 compliant */
#ifdef _POSIX_VERSION
#define POSIX
#else
#undef POSIX
#endif /* _POSIX_VERSION */

/* I'm not touching this as I have no VMS here */
/* The VMS stuff follows, all in aid of errno.h?! */
#ifdef	vms
pid_t decc$getpid(void);	/* Just don't ask...*/
#define getpid decc$getpid	/* Really... don't ask.*/
#define perror socket_perror	/* MultiNet wants this */
#ifdef MULTINET_V3
#define errno socket_errno	/* MultiNet wants this */
#include "multinet_root:[multinet.include]errno.h"
#else /* MULTINET_V4 */
#define MULTINET_V4
#include <errno.h>
#ifdef errno
#undef errno
#include "multinet_root:[multinet.include]errno.h"
#define errno socket_errno	/* Multinet 4.1 */
#endif /* errno defined */
#endif /* MULTINET_V3 */
#define write socket_write	/* MultiNet wants this */
#define read socket_read	/* MultiNet wants this */
#define close socket_close	/* MultiNet wants this */
#include <signal.h>
#ifdef __alpha
#define BYTE_ORDER 1234		/* The include files for Alpha are bad. */
#define LITTLE_ENDIAN 1234	/* They incorrectly swap ip_v and ip_hl */
#define BIG_ENDIAN 4321		/* Which makes packet_ok fail.  New diag */
#endif /* __alpha */		/* Info says:  packet version not 4: 5 */
#ifdef VMS_CLD			/* use separate qualifers instead of options */
#include "clis.h"
#else /* No CLD */
int fixargs(int *, char **, char **);
#endif /* VMS_CLD */
#else /* not VMS */
#include <errno.h>
#endif	/* vms */

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif /* HAVE_SYS_TIME_H */
#endif /* TIME_WITH_SYS_TIME */

#ifndef vms			/* Not VMS */
#include <resolv.h>
#else /* vms */			/* else VMS */
#ifdef MULTINET_V4	/* they didn't put the prototypes in the file */
#include <resolv.h>
int res_send(unsigned char *, int, unsigned char *, int);
int res_mkquery(int op, const char *dname,
          int class, int type, const char *data, int datalen,
          void *, u_char *buf, int buflen);
int gettimeofday(struct timeval *, void *);
#endif /* MULTINET_V4 */
#endif /* __vms */		/* Endif VMS */

#ifdef __linux__                /* Wrapping this may be excessive */
#define __FAVOR_BSD
#endif


#ifndef MAX_DATALEN
#define MAX_DATALEN 32000	/* Maximum size of MTU discovery packet length*/
#endif

#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>
#ifdef HAVE_NETINET_IP_VAR_H
#include <netinet/ip_var.h>
#else /* HAVE_NETINET_IP_VAR_H */
#ifdef HAVE_NETINET_IF_TR_H
#include <sys/time.h>
#include <netinet/if_tr.h>
#else
#error "don't have either netinet/if_tr.h or netinet/ip_var.h"
#endif /* HAVE_NETINET_IF_TR_H */
#endif /* HAVE_NETINET_IP_VAR_H */
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <netdb.h>
#include <ctype.h>
#include <math.h>		/* After resolv.h for gcc2.7/sun __p redef */

#ifndef NO_PROTOTYPES		/* By default, have prototypes */
int send_probe(int, int);
int wait_for_reply(int, struct sockaddr_in *, struct timeval *);
int packet_ok(u_char *, int, struct sockaddr_in *, int);
int tvsub(struct timeval *, struct timeval *);
int print(u_char *, int, struct sockaddr_in *);
int reduce_mtu(int);
int doqd(unsigned char *, int);
int dorr(unsigned char *, int, char **);
int doclass(unsigned char *, int);
int dordata(unsigned char *, int, int, int, char *, char **);
int dottl(unsigned char *,int);
int doname(unsigned char *, int, char *);
int dotype(unsigned char *, int);
void AbortIfNull (char *);
void print_ttl(int);
void print_packet(struct ip *, int);
#endif /* NO_PROTOTYPES */

#define	MAXPACKET	65535	/* max ip packet size */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	64
#endif

#define SIZEOFstructip sizeof(struct ip)

#ifndef FD_SET
#define NFDBITS         (8*sizeof(fd_set))
#define FD_SETSIZE      NFDBITS
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif

#define Fprintf (void)fprintf
#define Sprintf (void)sprintf
#define Printf (void)printf

#define NOERR(val,msg) {if (((int)(val)) < 0) {perror(msg);exit(1);}}

#ifndef NO_SOA_RECORD
#define NO_SOA_RECORD "no SOA record"
#endif

#ifndef NO_RADB_RECORD
#define NO_RADB_RECORD "no RADB record"
#endif

/*  For some reason, IP_HDRINCL and LSRR don't interact well on SGI;
 *  so turn it off:  */
#ifdef sgi
#undef IP_HDRINCL
#endif

#ifndef vms
extern	int errno;
#endif

extern  char *inet_ntoa();
extern  u_long inet_addr();

void halt();   /* signal handler */

/*
 * format of a (udp) probe packet.
 */
struct opacket {
	struct ip ip;
	struct udphdr udp;
	u_char seq;		/* sequence number of this packet */
	u_char ttl;		/* ttl packet left with */
	struct timeval tv;	/* time packet left */
};

#ifdef SPRAY
/*
 * format of a spray data cell.
 */
#define SPRAYMAX 256		/* We'll only do up to 256 TTLs at once */
struct {
        u_long  dport;          /* check for matching dport */
        u_char  ttl;            /* ttl we sent it to */
        u_char  type;           /* icmp response type */
        struct  timeval out;    /* time packet left */
        struct  timeval rtn;    /* time packet arrived */
        struct  sockaddr_in from; /* whom from */
} spray[SPRAYMAX];
int spray_rtn[SPRAYMAX];	/* See which TTLs have responded */
int spray_target;		/* See which TTL the host responds on */
int spray_max;			/* See which is the highest TTL we've seen */
int spray_min;			/* See smallest host-returned TTL */
int spray_total;		/* total of responses seen */
int spray_mode =0;		/* By default, turned off */
#endif /* SPRAY */

u_char	packet[512];		/* last inbound (icmp) packet */
struct opacket	*outpacket;	/* last output packet */
char *inetname();
u_char  optlist[MAX_IPOPTLEN];  /* IP options list  */
int _optlen;
struct icmp *icp;               /* Pointer to ICMP header in packet */


int s;				/* receive (icmp) socket file descriptor */
int sndsock;			/* send (udp) socket file descriptor */
struct sockaddr whereto;	/* Who to try to reach */
int datalen;			/* How much data */


char *source = 0;
char *hostname;
char hnamebuf[MAXHOSTNAMELEN];

int nprobes = 3;
int min_ttl = 1;
int max_ttl = 30;
u_short ident;
u_short port = 32768+666;	/* start udp dest port # for probe packets */
u_short sport = 1000;		/* source port ... */

int options;			/* socket options */
int verbose;
int mtudisc=0;                  /* do MTU discovery in path */
int pingmode=0;			/* replacing ping functionality? */
#ifndef vms
float waittime = 3.0;		/* time to wait for response (in seconds) */
#else /* vms */
double waittime = 3.0;
#endif
int nflag;			/* print addresses numerically */

#define TERM_SIZE 32		/* Size of line terminator... */
char terminator[TERM_SIZE];	/* Line terminator... */
int haltf=0;                    /* signal happened */
int ppdelay=1;                  /* we normally want per-packet delay */
int pploss=0;                   /* we normally don't want packet loss */
int lost;                       /* how many packets did we not get back */ 
double throughput;              /* percentage packets not lost */
int consecutive=0;              /* the number of consecutive lost packets */
int automagic=0;                /* automatically quit after 10 lost packets? */
int hurry_mode=0;		/* only do one on successful ttls */
int utimers=0;                  /* Print timings in microseconds */
int dns_owner_lookup=0;         /* Look up owner email in DNS */
int as_lookup=0;                /* Look up AS path in routing registries */
int got_there;
int unreachable;
int mtu, new_mtu = 0;

char usage[] = "%s: Usage: traceroute [-adnruvAMOQ] [-w wait] [-S start_ttl] [-m max_ttl] [-p port#] [-q nqueries] [-g gateway] [-t tos] [-s src_addr] [-g router] host [data size]\n\
      -a: Abort after 10 consecutive drops\n\
      -d: Socket level debugging\n\
      -g: Use this gateway as an intermediate hop (uses LSRR)\n\
      -S: Set start TTL (default 1)\n\
      -m: Set maximum TTL (default 30)\n\
      -n: Report IP addresses only (not hostnames)\n\
      -p: Use an alternate UDP port\n\
      -q: Set the number of queries at each TTL (default 3)\n\
      -r: Set Dont Route option\n\
      -s: Set your source address\n\
      -t: Set the IP TOS field (default 0)\n\
      -u: Use microsecond timestamps\n\
      -v: Verbose\n\
      -w: Set timeout for replies (default 5 sec)\n\
      -A: Report AS# at each hop (from GRR)\n\
      -M: Do RFC1191 path MTU discovery\n\
      -O: Report owner at each hop (from DNS)\n\
      -P: Parallel probing\n\
      -Q: Report delay statistics at each hop (min/avg+-stddev/max) (ms)\n\
      -T: Terminator (line end terminator)\n\
      -U: Go to next hop on any success\n";

float deltaT();

main(argc, argv)
	int argc;
	char *argv[];
{
	struct sockaddr_in from;
	char **av = argv;
#ifdef VMS_CLD
	char *ptr;
#endif /* VMS_CLD */
#ifdef SPRAY
        float ddt=0;	/* Delta delta time... for subtracting packet time */
#endif

	struct sockaddr_in *to = (struct sockaddr_in *) &whereto;
	int on = 1;
	int alloc_len;
	struct protoent *pe;
	int ttl, probe, i;
        int last_i;
	int last_ttl;
	int ttl_diff;
	int spr_ttl;
	int idx;		/* index to ttl based on spray sequence */
	int seq = 0;
	int tos = 0;
	struct hostent *hp;
	unsigned int lsrr = 0;
	u_long gw;
	u_char *oix;
#ifdef TEST			/* For testing purposes.  This will one day */
	u_long gw_list[10];	/* be the list of intermediate gateways for */
#endif				/* LSRR on netbsd kernels. */
	u_long lastaddr;
	u_long curaddr;
	float min;
	float max;
	float sum;
	float sumsq;
	int cc;
	struct timeval tv;
	struct timeval deadline;
	struct ip *ip;



	sprintf(terminator,"\n");	/* Standard line terminator */
	oix = optlist;
	bzero(optlist, sizeof(optlist));

#ifndef VMS_CLD
#ifdef __vms
	if (argc < 3) fixargs(&argc,argv,av);	
#endif
	argc--, av++;
	while (argc && *av[0] == '-')  {
		while (*++av[0])
			switch (*av[0]) {
			case 'a':
			        automagic = 1;
				break;
			case 'U':
				hurry_mode =1;
				break;
			case 'A':
				as_lookup = 1;
				break;
			case 'd':
				options |= SO_DEBUG;
				break;
			case 'g':
				argc--, AbortIfNull((++av)[0]);
				if ((lsrr+1) >= ((MAX_IPOPTLEN-IPOPT_MINOFF)/sizeof(u_long))) {
				  Fprintf(stderr,"No more than %d gateway%s",
					  ((MAX_IPOPTLEN-IPOPT_MINOFF)/sizeof(u_long))-1,terminator);
				  exit(1);
				}
				if (lsrr == 0) {
				  *oix++ = IPOPT_LSRR;
				  *oix++;	/* Fill in total length later */
				  *oix++ = IPOPT_MINOFF; /* Pointer to LSRR addresses */
				}
				lsrr++;
                                if (*av[0] ==0) {
                                    Fprintf(stderr,"Hosts are not blank.%s",terminator);
                                    exit(1);
                                }
				if (isdigit(*av[0])) {
				  gw = inet_addr(*av);
				  if (gw) {
				    bcopy(&gw, oix, sizeof(u_long));
				  } else {
				    Fprintf(stderr, "Unknown host %s%s",av[0],terminator);
				    exit(1);
				  }
				} else {
				  hp = gethostbyname(av[0]);
				  if (hp) {
				    bcopy(hp->h_addr, oix, sizeof(u_long));
				  } else {
				    Fprintf(stderr, "Unknown host %s%s",av[0],terminator);
				    exit(1);
				  }
				}
#ifdef TEST	/* store gateways for netbsd kernels */
                                bcopy(oix,&gw_list[lsrr],sizeof(u_long));
#endif
				oix += sizeof(u_long);
				goto nextarg;
			case 'S':
				argc--, AbortIfNull((++av)[0]);
				min_ttl = atoi(av[0]);
				if (min_ttl > max_ttl) {
					Fprintf(stderr, "min ttl must be >=%d%s",max_ttl,terminator);
					exit(1);
				}
				goto nextarg;
			case 'm':
				argc--, AbortIfNull((++av)[0]);
				max_ttl = atoi(av[0]);
				if (max_ttl < min_ttl) {
					Fprintf(stderr, "max ttl must be >%d%s",min_ttl,terminator);
					exit(1);
				}
				goto nextarg;
			case 'n':
				nflag++;
				break;
			case 'O':
				dns_owner_lookup = 1;
				break;
			case 'p':
				argc--, AbortIfNull((++av)[0]);
				port = atoi(av[0]);
				if (port < 1) {
					Fprintf(stderr, "port must be >0%s",terminator);
					exit(1);
				}
				goto nextarg;
			case 'P':
				spray_mode = 1;
				break;
			case 'f':
				argc--, AbortIfNull((++av)[0]);
				sport = atoi(av[0]);
				goto nextarg;
			case 'q':
				argc--, AbortIfNull((++av)[0]);
				nprobes = atoi(av[0]);
				if (nprobes < 1) {
					Fprintf(stderr, "nprobes must be >0%s",terminator);
					exit(1);
				}
				goto nextarg;
			case 'r':
				options |= SO_DONTROUTE;
				break;
			case 's':
				/*
				 * set the ip source address of the outbound
				 * probe (e.g., on a multi-homed host).
				 */
				argc--, AbortIfNull((++av)[0]);
				source = av[0];
				goto nextarg;
			case 't':
				argc--, AbortIfNull((++av)[0]);
				tos = atoi(av[0]);
				if (tos < 0 || tos > 255) {
					Fprintf(stderr, "tos must be 0 to 255%s",terminator);
					exit(1);
				}
				goto nextarg;
			case 'u':
				utimers = 1;
				break;
			case 'v':
				verbose++;
				break;
			case 'w':
				argc--, AbortIfNull((++av)[0]);
				waittime = atof(av[0]);
				if (waittime <= .01) {
					Fprintf(stderr, "wait must be >10 msec%s",terminator);
					exit(1);
				}
				goto nextarg;
 		        case 'M':
				mtudisc++;
				break;
			case '$':
				min_ttl = 64;
				max_ttl = 64;
				nprobes = 1;
				pingmode = 1;
				break;
                        case 'Q':
				pploss = 1;
				ppdelay = 0;
				break;
                        case 'T':
				av++;
				if (--argc < 1) {
				        Fprintf(stdout,usage,TR_VERSION);
					exit(1);
				}
				strncpy(terminator,av[0],TERM_SIZE);
				terminator[TERM_SIZE -1] = 0;
				break;
			default:  
				Fprintf(stdout,usage,TR_VERSION);
				exit(1); 
			}
	nextarg:
		argc--, av++;
	}
#else /* VMS_CLD defined */
#include "clis.h"
#endif /* VMS_CLD */

	if (argc < 1)  {
		Fprintf(stdout,usage,TR_VERSION);
		exit(1);
	}
#ifndef vms
	setlinebuf (stdout);
#endif

	(void) bzero((char *)&whereto, sizeof(struct sockaddr));
	to->sin_family = AF_INET;
#ifdef VMS_CLD
	av[0] = hostname;
#endif
	to->sin_addr.s_addr = inet_addr(av[0]);
	if ((int)to->sin_addr.s_addr != -1) {
		(void) strcpy(hnamebuf, av[0]);
		hostname = hnamebuf;
	} else {
		hp = gethostbyname(av[0]);
		if (hp) {
			to->sin_family = hp->h_addrtype;
			bcopy(hp->h_addr, (caddr_t)&to->sin_addr, hp->h_length);
			hostname = hp->h_name;
		} else {
			Fprintf(stderr,"%s: unknown host %s%s", argv[0], av[0],terminator);
			exit(1);
		}
	}

#ifndef VMS_CLD
	if (argc >= 2)
		datalen = atoi(av[1]);
	if (datalen < 0 || datalen >= MAXPACKET) {
		Fprintf(stderr, "traceroute: packet size must be 0 <= s < %ld%s",
			(long) MAXPACKET - sizeof(struct opacket),terminator);
		exit(1);
	}
#else /* VMS_CLD defined */
#include "clis.h"
#endif /* VMS_CLD */
	if (mtudisc) 
	  /*  Ignore data length as set.  Set it to a large value to 
	      start things off...  */
	  datalen=MAX_DATALEN;

	if (datalen < (int) (sizeof(struct opacket) + MAX_IPOPTLEN)) {
	  alloc_len = sizeof(struct opacket) + MAX_IPOPTLEN;
	} else {
	  alloc_len = datalen;
	}

	outpacket = (struct opacket *)malloc((unsigned)alloc_len);

	if (! outpacket) {
		perror("traceroute: malloc");
		exit(1);
	}
	(void) bzero((char *)outpacket, alloc_len);
	outpacket->ip.ip_dst = to->sin_addr;
	outpacket->ip.ip_tos = tos;

	ident = (getpid() & 0xffff) | 0x8000;

	if ((pe = getprotobyname("icmp")) == NULL) {
		Fprintf(stderr, "icmp: unknown protocol%s",terminator);
		exit(10);
	}
	if ((s = socket(AF_INET, SOCK_RAW, pe->p_proto)) < 0) {
		perror("traceroute: icmp socket");
		exit(5);
	}
	if (options & SO_DEBUG)
		(void) setsockopt(s, SOL_SOCKET, SO_DEBUG,
				  (char *)&on, sizeof(on));
	if (options & SO_DONTROUTE)
		(void) setsockopt(s, SOL_SOCKET, SO_DONTROUTE,
				  (char *)&on, sizeof(on));

	if ((sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0) {
		perror("traceroute: raw socket");
		exit(5);
	}

	/*  ^C punts you to the next hop.  Twice will exit.  */

#ifndef __linux__
	NOERR(signal(SIGINT,halt),"signal SIGINT");   
#endif /* __linux__ */
	
	if (lsrr > 0) {
	  lsrr++;
	  optlist[IPOPT_OLEN]=IPOPT_MINOFF-1+(lsrr*sizeof(u_long));
	  bcopy((caddr_t)&to->sin_addr, oix, sizeof(u_long));
	  oix += sizeof(u_long);
	  while ((oix - optlist)&3) oix++;		/* Pad to an even boundry */
	  _optlen = (oix - optlist);

	  if ((pe = getprotobyname("ip")) == NULL) {
	    perror("traceroute: unknown protocol ip");
	    exit(10);
	  }
#ifndef TEST
	  if ((setsockopt(sndsock, pe->p_proto, IP_OPTIONS, optlist, oix-optlist)) < 0) {
	    perror("traceroute: lsrr options");
	    exit(5);
	  }
#else /* TEST manual lsrr */
	  Fprintf(stderr,"Current test IP header length: %d\n",outpacket->ip.ip_hl);
#endif
	}

	if (datalen < (int) (sizeof (struct opacket) + _optlen)) {
	  /*  The chosen size is too small to fit everything...
	      make it bigger:  */
	  datalen = sizeof (struct opacket) + _optlen;
      }


#ifdef SO_SNDBUF
	if (setsockopt(sndsock, SOL_SOCKET, SO_SNDBUF, (char *)&datalen,
		       sizeof(datalen)) < 0) {
		perror("traceroute: SO_SNDBUF");
		exit(6);
	}
#endif /* SO_SNDBUF */
#ifdef IP_HDRINCL
	if (setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on,
		       sizeof(on)) < 0) {
		perror("traceroute: IP_HDRINCL");
		exit(6);
	}
#endif /* IP_HDRINCL */
	if (options & SO_DEBUG)
		(void) setsockopt(sndsock, SOL_SOCKET, SO_DEBUG,
				  (char *)&on, sizeof(on));
	if (options & SO_DONTROUTE)
		(void) setsockopt(sndsock, SOL_SOCKET, SO_DONTROUTE,
				  (char *)&on, sizeof(on));

	if (source) {
		(void) bzero((char *)&from, sizeof(struct sockaddr));
		from.sin_family = AF_INET;
		from.sin_addr.s_addr = inet_addr(source);
		if ((int)from.sin_addr.s_addr == -1) {
			Fprintf(stderr,"traceroute: unknown host %s%s", source,terminator);
			exit(1);
		}
		outpacket->ip.ip_src = from.sin_addr;
#ifndef IP_HDRINCL
		if (bind(sndsock, (struct sockaddr *)&from, sizeof(from)) < 0) {
			perror ("traceroute: bind:");
			exit (1);
		}
#endif /* IP_HDRINCL */
	}

	Fprintf(stderr, "traceroute to %s (%s)", hostname,
		inet_ntoa(to->sin_addr));
	if (source)
		Fprintf(stderr, " from %s", source);
	Fprintf(stderr, ", %d hops max, %d byte packets%s", max_ttl, datalen,
		terminator);
	(void) fflush(stderr);

#ifdef TEST
	if (lsrr != 0) {
	   for (ttl = 1; ttl < lsrr ; ++ttl) {
		Fprintf(stderr,"Lsrr hop %d is %s\n",ttl,inet_ntoa(gw_list[ttl]));
	   }
	}
#endif
   if (!spray_mode) {
      /* For all TTL do */
      for (ttl = min_ttl; ttl <= max_ttl; ++ttl) {
         lastaddr = got_there = unreachable = mtu = lost = consecutive =0;
         min = max = sum = sumsq = 0.0;
         throughput = (double) 0.0;

         print_ttl(ttl);
         if (new_mtu != 0) {
            Fprintf(stdout,"MTU=%d ",new_mtu);
            new_mtu=0;
         }
         /* For all probes do */
         for (probe = 0; probe < nprobes; ++probe) {
            (void) gettimeofday(&tv, NULL);
	    send_probe(++seq, ttl);
	    deadline.tv_sec = tv.tv_sec + (int) waittime; 
	    deadline.tv_usec=tv.tv_usec+((int) (waittime*1000000.0))%1000000;
	    if (deadline.tv_usec >= 1000000) {
	       deadline.tv_usec -= 1000000;
	       deadline.tv_sec++;
	    }
            /* Get an answer */
	    while (cc = wait_for_reply(s, &from, &deadline)) {
	       if ((i = packet_ok(packet, cc, &from, seq))) {
	          float dt = deltaT(&tv);
	          if (sum == 0) {
	             sum = min = max = dt;
		     sumsq = dt*dt;
	          } else {
	             if (dt < min) min = dt;
	   	     if (dt > max) max = dt;
		     sum += dt;
		     sumsq += dt*dt;
	          }
	          if (hurry_mode) probe = nprobes;

	          if (from.sin_addr.s_addr != lastaddr) {
	             print(packet, cc, &from);
		     lastaddr = from.sin_addr.s_addr;
	          }
	          if (ppdelay) {
		     if (utimers) {
		        Fprintf(stdout,"  %3.3f ms", dt);
		     } else {
		        Fprintf(stdout,"  %d ms", (int) (dt+0.5));
                     }
		     (void) fflush(stdout);
		  }
		    
		  print_packet((struct ip *) &packet, i);

		  consecutive = 0; /* got a packet back! */
		  break;
	       } /* end if packet ok */
            } /* end while */

	       if (cc == 0) {
	          if (pingmode) exit(23);
		  Fprintf(stdout," *");
		  (void) fflush(stdout);

		  lost++;
		  consecutive++;

		  /*  Reset the ^C action from exit to skip TTL  */
 	          if (haltf==0 && lost==1)
#ifndef __linux__
		  NOERR(signal(SIGINT,halt), "signal SIGINT");
#endif /* __linux__ */
		  /* we've missed at least one packet, so let's check for the 
                     signal to go to the next ttl */
	          if (haltf > 0) {
		     haltf = 0;
		     consecutive = 0;
		     break;
		  }
	       } /* end if cc = 0 */
	       if (automagic && (consecutive > 9)) break;
         } /* end for probe */


	 if (pploss) {
	    if (lost < probe) {
	       throughput = ( 100.0 - ( ( lost * 100.0 ) / probe ));
	       Fprintf(stdout,
                       "  (%1.1f ms/%1.1f ms(+-%1.1f ms)/%1.1f ms)", 
	               min, (sum / (probe - lost)), 
		       (float)sqrt((double)sumsq)/(probe-lost), max);
	       Fprintf(stdout," %d/%d (%#3.2f%%)", (probe - lost),
	               probe, throughput);
	       (void) fflush(stdout);
            }
	 }
	 Fprintf(stdout,terminator); 

	 /* If we're running one probe and we get back one packet, that's
	    no excuse to quit unless we're really done! */

         if ( ((nprobes == 1) && (got_there || unreachable)) ||
#ifndef CISCO_ICMP
               (got_there || unreachable > nprobes - 1) )
#else /* CISCO_ICMP meaning not all our packets will be returned. */
               (got_there || unreachable > nprobes - 1) ||
               ( (unreachable+lost > nprobes - 1) && (unreachable > 0) ))
#endif /* CISCO_ICMP */
	    exit(0);
	 if (new_mtu != 0) {
	    ttl--;  /*  Redo the same TTL  */
	    datalen = new_mtu;  /*  Set the new data length  */
	 }
      } /* end for TTL */

/* end non-spray mode */

} else { 

/* 
 * Enter Spray mode
 */
   spray_target = spray_max = spray_total = 0;
   spray_min = SPRAYMAX+1;

   /* For all TTL do */
   for (ttl = min_ttl; ttl <= max_ttl; ++ttl) {
      spray_rtn[ttl]=0;
      for (probe = 0; probe < nprobes; ++probe) {
         send_probe(++seq, ttl);
      }
   }
   (void) gettimeofday(&tv, NULL);
   deadline.tv_sec = tv.tv_sec + (int) waittime; 
   deadline.tv_usec=tv.tv_usec+((int) (waittime*1000000.0))%1000000;
   if (deadline.tv_usec >= 1000000) {
      deadline.tv_usec -= 1000000;
      deadline.tv_sec++;
   }
   /* Go get responses until either we get them all, or timeout */
   while (  (spray_min > spray_total)  &&
            (cc = wait_for_reply(s,&from,&deadline))  ) {
      (void) packet_ok(packet, cc, &from, seq);
   }

   last_i = 1;
   last_ttl = 0;
   lastaddr = 0;
   for (i = 1; i <= spray_min; i++) {
      /* First see if it's valid, and if so play with its time */
      idx = spray_rtn[i];
      if ((idx > 0) && (idx < SPRAYMAX)) {
	 spr_ttl = spray[idx].ttl;
	 if (spr_ttl != i) {
	    Fprintf(stderr,"Check failure spray(rtn[i]) !=i\n");
	    exit(0);
	 }
	 ttl_diff = (spr_ttl - last_ttl);
	 if (ttl_diff > 1) {
            for (last_i = last_ttl+1; last_i < spr_ttl; last_i++) {
               print_ttl(last_i);
	       for (probe = 1; probe <= nprobes ; probe++) { 
                  Fprintf(stdout," *");
               } /* end for probes */
               Fprintf(stdout,terminator);
            } /* end for last i */
	 } /* endf if spr_ttl ... */
         if (spr_ttl > last_ttl) {
            print_ttl(spr_ttl);
            last_ttl = spr_ttl;
         }
	 memcpy(&curaddr,&spray[idx].from,
		sizeof(spray[idx].from));
	 if (lastaddr != curaddr) {
            if (nflag) {
               Fprintf(stdout, " %s", inet_ntoa(spray[idx].from));
            } else {
              Fprintf(stdout, " %s (%s)", inetname(spray[idx].from),
              inet_ntoa(spray[idx].from));
            }
         lastaddr = curaddr;
         }
         tvsub(&spray[spray_rtn[i]].rtn,&spray[spray_rtn[i]].out);
         ddt=spray[spray_rtn[i]].rtn.tv_sec*1000.0+
            ((float)spray[spray_rtn[i]].rtn.tv_usec)/1000.0;
         if (utimers) {
            Fprintf(stdout,"  %3.3f ms", ddt);
         } else {
            Fprintf(stdout,"  %d ms", (int) (ddt+0.5));
         }
   Fprintf(stdout,terminator);
      } /* end if nonzero type */
   } /* end for */
} /* end spray mode */
}

void print_packet(struct ip *ip, int i)
{
		    switch(i - 1) {
			case 13:
				Fprintf(stdout," !A"); /* admin prohibited*/
                                ++unreachable;
                                break;
			case ICMP_UNREACH_PORT:
#ifndef ARCHAIC
				ip = (struct ip *)packet;
				if (ip->ip_ttl <= 1)
				Fprintf(stdout," !");
#endif /* ARCHAIC */
				++got_there;
				break;
			case ICMP_UNREACH_NET:
				++unreachable;
				Fprintf(stdout," !N");
				break;
			case ICMP_UNREACH_HOST:
				++unreachable;
				Fprintf(stdout," !H");
				break;
			case ICMP_UNREACH_PROTOCOL:
				++got_there;
				Fprintf(stdout," !P");
				break;
			case ICMP_UNREACH_NEEDFRAG:
				if (mtudisc) {
				   /* Doing MTU discovery */
				   mtu = (ntohl(icp->icmp_void) & 0xffff);
				   if (mtu >= datalen) {
				    /*  This should never happen.  There is
					a serious bug somewhere... */
				      Fprintf (stdout," !M>");
				   } else if (mtu == 0) {
				      Fprintf (stdout," !M");
				      new_mtu = reduce_mtu(datalen);
				   } else {
				      new_mtu = mtu;
				      Fprintf (stdout," !M=%d", new_mtu);
				   }
				   break;
				} else {
				  /* Not doing MTU discovery */
				  ++unreachable;
				  Fprintf(stdout," !F");
				  break;
				}
			case ICMP_UNREACH_SRCFAIL:
				++unreachable;
				Fprintf(stdout," !S");
				break;
		    } /* end switch */
}

void print_ttl(int ttl)
{
   Fprintf(stdout,"%2d ", ttl);
   (void)fflush(stdout);
}


wait_for_reply(sock, from, deadline)
	int sock;
	struct sockaddr_in *from;
        struct timeval     *deadline;
{
	fd_set fds;
	struct timeval wait;
	struct timeval now;
	int cc = 0;
	int fromlen = sizeof (*from);

	gettimeofday(&now, NULL);
	if ((now.tv_sec > deadline->tv_sec) ||
	    ( (now.tv_sec == deadline->tv_sec) && 
	     (now.tv_usec > deadline->tv_usec) )  ) return (int)NULL;


	wait.tv_sec= deadline->tv_sec- now.tv_sec;
	if (deadline->tv_usec >= now.tv_usec) {
	  wait.tv_usec= deadline->tv_usec- now.tv_usec;
	} else {
	  wait.tv_usec= (1000000 - now.tv_usec)+ deadline->tv_usec;
	  wait.tv_sec--;
	}

	FD_ZERO(&fds);
	FD_SET(sock, &fds);

	if (select(sock+1, &fds, (fd_set *)0, (fd_set *)0, &wait) > 0)
		cc=recvfrom(s, (char *)packet, sizeof(packet), 0,
			    (struct sockaddr *)from, &fromlen);
	return((int)cc);
}


send_probe(seq, ttl)
int ttl;
int seq;
{
	struct opacket *op = outpacket;
	struct ip *ip = &op->ip;
	struct udphdr *up = &op->udp;
	int i;

      retry:
	if (mtudisc) {
	  ip->ip_off = (short) IP_DF;
	}
	else {
	  ip->ip_off = 0;
        }

	ip->ip_p = IPPROTO_UDP;
#ifndef BYTESWAP_IP_LEN
	ip->ip_len = ((u_short)datalen-_optlen);   /*  The OS inserts options  */
#else /* BYTESWAP_IP_LEN */ 
	ip->ip_len = htons((u_short)datalen-_optlen);   /*  The OS inserts options  */
#endif /* BYTESWAP_IP_LEN */
	ip->ip_ttl = ttl;
        ip->ip_v = IP_VERSION;
        ip->ip_hl = sizeof(*ip) >> 2;

	up->uh_sport = htons(ident);
	up->uh_dport = htons(port+seq);
	up->uh_ulen = htons((u_short)(datalen - sizeof(struct ip) - _optlen));
	up->uh_sum = 0;

	op->seq = seq;
	op->ttl = ttl;
	(void) gettimeofday(&op->tv, NULL);

#ifdef SPRAY
        spray[seq].dport = up->uh_dport;
        spray[seq].ttl   = ttl;
        bcopy(&op->tv, &spray[seq].out, sizeof(struct timeval));
#endif

	i = sendto(sndsock, (char *)outpacket, datalen - _optlen, 0, &whereto,
		   sizeof(struct sockaddr));

	if (i < 0 || i != datalen - _optlen)  {
		if (i<0) {
		    if (errno == EMSGSIZE) {
		        datalen = reduce_mtu(datalen);
			Fprintf (stdout," MTU=%d", datalen);
			goto retry;
		    }
		    else
			perror("sendto");
		}
		Fprintf(stderr,"traceroute: wrote %s %d chars, ret=%d%s", hostname,
			datalen, i,terminator);
		(void) fflush(stdout);
	}
}



float deltaT(tp)
	struct timeval *tp;
{
	struct timeval tv;

	(void) gettimeofday(&tv, NULL);
	tvsub(&tv, tp);
	return (tv.tv_sec*1000.0 + ((float)tv.tv_usec)/1000.0);
}


/*
 * Convert an ICMP "type" field to a printable string.
 */
char *
pr_type(t)
	u_char t;
{
	static char *ttab[] = {
	"Echo Reply",	"ICMP 1",	"ICMP 2",	"Dest Unreachable",
	"Source Quench", "Redirect",	"ICMP 6",	"ICMP 7",
	"Echo",		"ICMP 9",	"ICMP 10",	"Time Exceeded",
	"Param Problem", "Timestamp",	"Timestamp Reply", "Info Request",
	"Info Reply"
	};

	if(t > 16)
		return("OUT-OF-RANGE");

	return(ttab[t]);
}


/*
 * packet_ok - Make sure it's a real ICMP return of a real UDP packet 
 */
packet_ok(buf, cc, from, seq)
	u_char *buf;
	int cc;
	struct sockaddr_in *from;
	int seq;
{
	u_char type, code;
	int hlen, mtu;
	u_short temp;
	int tmp,tmp2;
	int spr_seq;
	int spr_ttl;
	
#ifndef ARCHAIC
	struct ip *ip;

	ip = (struct ip *) buf;
	/* get header length and convert from longwords to bytes */
	if ((ip->ip_v) != IP_VERSION) {
		Fprintf(stderr,"packet version not 4: %d%s",ip->ip_v,terminator);
		return (0);
	}
	hlen = ip->ip_hl <<2 ;
	if (cc < hlen + ICMP_MINLEN) {
		if (verbose)
			Fprintf(stderr,"packet too short (%d bytes) from %s%s", cc,
				inet_ntoa(from->sin_addr),terminator);
		return (0);
	}
	/* go from returned length of packet to cc=data portion */
	cc -= hlen;
	/* make icp point to supposed ICMP portion */
	icp = (struct icmp *) ((u_char *)buf+hlen);
#else
	icp = (struct icmp *)buf;
#endif /* ARCHAIC */
	type = icp->icmp_type; code = icp->icmp_code;
	if ((type == ICMP_TIMXCEED && code == ICMP_TIMXCEED_INTRANS) ||
	    type == ICMP_UNREACH) {
		struct ip *hip;
		struct udphdr *up;
		      
                hip = &icp->icmp_ip;
		hlen = hip->ip_hl << 2;
                up = (struct udphdr *)((u_char *)hip + hlen);
#ifdef SPRAY
/*
 * First we make sure we got a legal response back, and if so we
 * get the sequence number and ttl out of it 
 */
		spr_seq = ntohs(up->uh_dport)-port;
	   	if ( (spr_seq >=0) && (spr_seq < max_ttl*nprobes+1) ) {
                   spr_ttl = spray[spr_seq].ttl;
/*
 * Now we increment the response count for this ttl, and then if it's the 
 * first, increment the total of ttl's seen 
 */
		   if (spray_rtn[spr_ttl] == 0) {
                      spray_total++;
		   }
		   spray_rtn[spr_ttl] = spr_seq;
/*
 * We want to do some heuristics on the smallest TTL received from the target
 * host, but we need the type for that...
 */
                   spray[spr_seq].type = type;
                   if (type == ICMP_UNREACH_PORT) {
		      if (spr_ttl < spray_min) 
			 spray_min = spr_ttl;
			 spray_target = spr_ttl;
		   }
/*
 * We also want the largest TTL we've seen...
 */
                   if (spr_ttl > spray_max)
                      spray_max = spr_ttl;
/*
 * And finally, fill the data structure with the other things we'll need
 * to spit out later, namely the packet transit type and the source IP.
 */
                   gettimeofday(&(spray[spr_seq].rtn),0);
                   bcopy(&from->sin_addr, 
			 &spray[spr_seq].from,
                         sizeof(struct sockaddr_in));

                } /* end if sequence number valid */
#endif

		if (hlen + 12 <= cc && hip->ip_p == IPPROTO_UDP &&
		    up->uh_sport == htons(ident) &&
		    up->uh_dport == htons(port+seq))
			return (type == ICMP_TIMXCEED? -1 : code+1);

	} /* end if valid ICMP type */
#ifndef ARCHAIC
	if (verbose) {
		int i;
		u_long *lp = (u_long *)&icp->icmp_ip;

		Fprintf(stderr,"\n%d bytes from %s to %s", cc,
			inet_ntoa(from->sin_addr), inet_ntoa(ip->ip_dst));
		Fprintf(stderr,": icmp type %d (%s) code %d%s", type, pr_type(type),
		       icp->icmp_code,terminator);
		for (i = 4; i < cc ; i += sizeof(long))
			Fprintf(stderr,"%2d: x%8.8lx\n", i, *lp++);
	}
#endif /* ARCHAIC */
	return(0);
}




int reduce_mtu(value)
int value;
{
  /*  The following heuristic taken from RFC1191  */
  static int mtuvals[11]={32000, 17914, 8166, 4352, 2002, 1492, 1006, 508, 296, 68, -1};
  int i=0;

  while (value <= mtuvals[i]) i++;
  if (mtuvals[i] > 0) {
    value = mtuvals[i];
  }
  else {
    Fprintf (stderr," No valid MTU!!!%s",terminator);
    exit (1);
  }
  return (value);
}

char *lookup_owner();
char *doresolve ();
char *lookup_as();


print(buf, cc, from)
	u_char *buf;
	int cc;
	struct sockaddr_in *from;
{
	struct ip *ip;
	int hlen;

	ip = (struct ip *) buf;
	hlen = ip->ip_hl << 2;
	cc -= hlen;

	if (nflag)
		Fprintf(stdout, " %s", inet_ntoa(from->sin_addr));
	else
		Fprintf(stdout, " %s (%s)", inetname(from->sin_addr),
		       inet_ntoa(from->sin_addr));

	if (as_lookup) 
		Fprintf(stdout," [%s]", lookup_as(from->sin_addr));

	if (dns_owner_lookup)
	  Fprintf(stdout," %s", lookup_owner(from->sin_addr));
	
	if (verbose)
	  Fprintf (stderr," %d bytes to %s", cc, inet_ntoa (ip->ip_dst));
      }



/*
 * Subtract 2 timeval structs:  out = out - in.
 * Out is assumed to be >= in.
 */
tvsub(out, in)
     register struct timeval *out, *in;
{
  if ((out->tv_usec -= in->tv_usec) < 0)   {
    out->tv_sec--;
    out->tv_usec += 1000000;
  }
  out->tv_sec -= in->tv_sec;
}


/*
 * Construct an Internet address representation.
 * If the nflag has been supplied, give 
 * numeric value, otherwise try for symbolic name.
 */
char *
inetname(in)
     struct in_addr in;
{
  register char *cp;
  static char line[50];
  struct hostent *hp;
  static char domain[MAXHOSTNAMELEN + 1];
  static int first = 1;

  if (first && !nflag) {
    first = 0;
    if (gethostname(domain, MAXHOSTNAMELEN) == 0 &&
	(cp = strchr(domain, '.')))
      (void) strcpy(domain, cp + 1);
    else
      domain[0] = 0;
  }
  cp = 0;
  if (!nflag && in.s_addr != INADDR_ANY) {
    hp = gethostbyaddr((char *)&in, sizeof (in), AF_INET);
    if (hp) {
      if ((cp = strchr(hp->h_name, '.')) &&
	  !strcmp(cp + 1, domain))
	*cp = 0;
      cp = hp->h_name;
    }
  }
  if (cp)
    (void) strcpy(line, cp);
  else {
    in.s_addr = ntohl(in.s_addr);
#define C(x)	((x) & 0xff)
#ifndef __linux__
    sprintf(line, "%lu.%lu.%lu.%lu", C(in.s_addr >> 24),
#else /* __linux__ */
    sprintf(line, "%u.%u.%u.%u", C(in.s_addr >> 24),	/* Why no lu??? */
#endif /* __linux__ */

	    C(in.s_addr >> 16), C(in.s_addr >> 8), C(in.s_addr));
  }
  return (line);
}

void halt()
{
  haltf++;

#ifndef __linux__
  NOERR(signal(SIGINT,0), "signal SIGINT,0");
#endif /* __linux__ */

}


/*
 *  Lookup owner of the net in DNS.
 */


char *lookup_owner(in)
     struct in_addr in;
{
  char dns_query[100];
  char *owner, *dot_ptr;
  unsigned char *addr_ptr;

  addr_ptr = (unsigned char *) (&in.s_addr);
  
  /* Try /24 */
  sprintf (dns_query, "%d.%d.%d.in-addr.arpa", addr_ptr[2], addr_ptr[1], addr_ptr[0]);
  if (!(owner = doresolve(dns_query))) {
    /* Failed, try /16 */
    sprintf (dns_query, "%d.%d.in-addr.arpa", addr_ptr[1], addr_ptr[0]);
    if (!(owner = doresolve(dns_query))) {
    /* Failed.  If eligible try /8 */
       if (addr_ptr[0] < 128) {
          sprintf (dns_query, "%d.in-addr.arpa", addr_ptr[0]);
          owner = doresolve(dns_query);
       } /* tried /8 for A's */
    } /* tried /16 */
  } /* tried /24 */

  /*  reformat slightly  */
  if (owner == NULL) {
     owner = NO_SOA_RECORD;
  } else {
    dot_ptr = (char *)strchr (owner, (int)'.');
    if (dot_ptr != NULL) 
      *dot_ptr = '@';
    
    if (strlen(owner) > 0) {
      dot_ptr=owner + strlen (owner) - 1;
      while (*dot_ptr == ' ' || *dot_ptr == '.' ) {
	*dot_ptr = 0;
        dot_ptr--;
      }
    }
  }

  return (owner);

}


/*
 *  Lookup origin of the net in radb.
 */

char *lookup_as(in)
struct in_addr in;
{
  static char query[100];
  static unsigned char *addr_ptr;
  static char *sp;
  char *get_origin();

  addr_ptr = (unsigned char *) (&in.s_addr);
  
  if (addr_ptr[0] >= 192) {
    sprintf (query, "%d.%d.%d.0",addr_ptr[0],addr_ptr[1],addr_ptr[2]);
  } else if (addr_ptr[0] >= 128) {
    sprintf (query, "%d.%d.0.0",addr_ptr[0],addr_ptr[1]);
  } else {
    sprintf (query, "%d.0.0.0",addr_ptr[0]);
  }
   
  return(get_origin(query));
}


/*
 * get_origin 	- Return origin (ASnnnn) given a network designation
 *
 * char *get_origin(char *net_designation)
 *
 * Returns:	0 - Error occurred, unable to get origin
 *		!0  Pointer to origin string
 *
 * Define STANDALONE to use this as a client.  Also define EXAMPLE_NET for
 * an example for the truly clueless...
 *
 *	20-May-1995	Ehud Gavron	gavron@aces.com
 */


/* The following are used to determine which service at which host to
   connect to.  A getenv() of the following elements occurs at run-time,
   which may override these values. */

#define RA_SERVER "whois.ra.net"
#define RA_SERVICE "whois"

/* The following determines what fields will be returned for the -A value
   (/AS_LOOKUP for VMS).  This is the "origin" of the route entry in the 
   RADB. */

#define DATA_DELIMITER "origin:"

/* Since now the RADB has multiple route objects, we will list only the
   origin of the most specific one.  To do so we actually have to parse
   the route lines and look for the most specific route.  To do so we
   parse:
		net.net.net.net/prefix
  
   and use the most specific (largest) prefix.  The following determine
   how we get this.  */

#define ROUTE_DELIMITER "route:"
#define PREFIX_DELIMITER "/"

#ifdef STANDALONE
#ifdef __vms
#include "multinet_root:[multinet.include.sys]types.h"
#include "multinet_root:[multinet.include.sys]socket.h"
#include "multinet_root:[multinet.include.netinet]in.h"
#include <stdio.h>
#include "multinet_root:[multinet.include]netdb.h"
#define perror socket_perror
#define write socket_write
#define read socket_read
#define close socket_close
#else /* not VMS */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <netdb.h>
#endif /* VMS */
#endif /* STANDALONE */

#ifndef boolean
#define boolean int
#endif

#ifndef TRUE
#define TRUE (1==1)
#endif

#ifndef FALSE
#define FALSE (!(TRUE))
#endif
#define MAXREPLYLEN 8192

#ifdef STANDALONE
main(argc,argv)
int argc;
char **argv;
{
	char buffer[100];
	char *p;
	char *get_origin();
#ifdef EXAMPLE_NET
	strcpy(buffer,"192.195.240.0/24");
#else
	strcpy(buffer,argv[1]);
#endif /* EXAMPLE_NET */
	p = get_origin(buffer);
	if (p) {
	   strcpy(buffer,p);
	   Fprintf(stdout,"origin is: %s\n",buffer);
	} else {
    	   Fprintf(stderr,"unable to get origin.\n");
	}
}
#endif /* STANDALONE */

char *get_origin(net)
char *net;
{
	char *i,*j,*k;
	char tmp[100],tmp2[100],tmp3[100]; /* store string delimiters */
	char tmp4[100];			/* here's where we store the AS */
	static	char origin[100];	/* the returned route origin */
	char *rp;			/* pointer to route: line */
	char *pp;			/* pointer to /prefix part of route */
	int prefix;			/* prefix off this line (decimal) */
	int best_prefix;		/* best prefix thus far */
	int s, n, count;
	char buf[256];
	boolean done;
	static char reply[MAXREPLYLEN];
	struct sockaddr_in sin;
	struct hostent *hp;
	struct servent *sp;
	char *getenv();

	/*
 	 * Get the IP address of the host which serves the routing arbiter
	 * database.  We use RA_SERVER.  On the offchance that someone wants
	 * to query another database, we check for the environment variable
	 * RA_SERVER to have been set.
	 */
	if ((i = getenv("RA_SERVER")) == 0) {
	   strcpy(tmp,RA_SERVER);
	} else {
           strncpy(tmp,i,sizeof(tmp));
           tmp[(sizeof(tmp))-1] = '\0';          /* strncpy may not null term */
	} 

	hp = gethostbyname(tmp);
	if (hp == NULL) {
	   Fprintf(stderr, "get_origin: localhost unknown%s",terminator);
	   return(NO_RADB_RECORD);
	}

	/*
	 *  Create an IP-family socket on which to make the connection
	 */

	s = socket(hp->h_addrtype, SOCK_STREAM, 0);
	if (s < 0) {
	   perror("get_origin: socket");
	   return(NO_RADB_RECORD);
	}

	/*
	 *  Get the TCP port number of the "whois" server.
	 *  Again if this needs to be updated, the environment variable
	 *  RA_SERVICE should be set.
	 */
	if ((i = getenv("RA_SERVICE")) == 0) {
	   strcpy(tmp,RA_SERVICE);
	} else {
           strncpy(tmp,i,sizeof(tmp));
           tmp[(sizeof(tmp))-1] = '\0';          /* strncpy may not null term */
	} 

	sp = getservbyname(tmp,"tcp");
	if (sp == NULL) {
	   Fprintf(stderr, "get_origin: getservbyname: unknown service%s",terminator);
	   return(NO_RADB_RECORD);
	}

	/*
	 *  Create a "sockaddr_in" structure which describes the remote
	 *  IP address we want to connect to (from gethostbyname()) and
	 *  the remote TCP port number (from getservbyname()).
	 */

	sin.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (caddr_t)&sin.sin_addr, hp->h_length);
	sin.sin_port = sp->s_port;

	/*
	 *  Connect to that address...
	 */

	if (connect(s, (struct sockaddr *)&sin, sizeof (sin)) < 0) {
	   perror("get_origin: connect");
	   return(NO_RADB_RECORD);
	}

	/*
	 * Now send the request out to the server...
	 */

	done = FALSE;
	sprintf(buf,"%s\r\n",net);
	n = write(s, buf, strlen(buf));
	if (n < 0) {
		perror("get_origin: write");
		return(NO_RADB_RECORD);
	}

	/*
	 * Now get the entire answer in one long buffer...
	 */
	count = 0;
	while ((n = read(s, buf, sizeof(buf))) > 0 &&
			(n+count < sizeof(reply))) {
	    strcpy((char *)&reply[count],(char *)buf);
	    count += n;
	}

	if (n < 0) {
	    perror("get_origin: read");
	    return(NO_RADB_RECORD);
	}

	reply[count] = '\0';	/* Terminate it - thanks Joey! */

	/*
	 * sometimes there's no answer
	 */
	if (strncmp(reply, "%%  No entries found for the selected source(s).",
			strlen("%%  No entries found for the selected source(s).")) == 0) {
		return(NO_RADB_RECORD);
	}

	/* 
	 * So now we have a large string, somewhere in which we can
	 * find  origin:*AS%%%%%%<lf>.  We parse this into AS%%%%%.
	 */
	
	if ((i = getenv("DATA_DELIMITER")) == 0) {
	   strcpy(tmp,DATA_DELIMITER);
	} else {
           strncpy(tmp,i,sizeof(tmp));
           tmp[(sizeof(tmp))-1] = '\0';          /* strncpy may not null term */
	} 

	/* TMP2 will have the route delimiter... */

	if ((i = getenv("ROUTE_DELIMITER")) == 0) {
	   strcpy(tmp2,ROUTE_DELIMITER);
	} else {
           strncpy(tmp,i,sizeof(tmp));
           tmp[(sizeof(tmp))-1] = '\0';          /* strncpy may not null term */
	} 

	if ((i = getenv("PREFIX_DELIMITER")) == 0) {
	   strcpy(tmp3,PREFIX_DELIMITER);
	} else {
           strncpy(tmp3,i,sizeof(tmp3));
           tmp3[(sizeof(tmp3))-1] = '\0';          /* strncpy may not null term */
	} 
	
/*
 * The next while statement was put in because of SPRINTLINK's ingeneous
 * Reasonable Default announcement project.  They registered nets in the 
 * RADB of the ilk of 0.0.0.0/1, 128.0.0.0/1, 192..../2, etc... just so 
 * that ANS wouldn't be such a pain in the butt.
 *
 * For us this means instead of taking the first origin...we take the best...
 */

/*
 * Initialize it so far as we've seen no prefixes, and are still looking
 * for route entries...
 */
	best_prefix = 0;		/* 0 bits is not very specific */
	done = FALSE;			/* not done finding route: entries */

	rp = (char *)reply;		/* initialize main pointer to buffer */
	origin[0]='\0';			/* initialize returned string */
	reply[MAXREPLYLEN-1]='\0';

	rp = (char *)strstr(rp,tmp2);	/* Find route: in the string */
	while (rp != 0) {		/* If there is such a thing... */
					/*  find it again later */
           pp = (char *)strstr(rp,tmp3);	/* Find / in the route entry */
           if (pp == 0) {		/* No prefix... */
              prefix = 0;		/* So we bias it out of here */
	   } else {
	      prefix = atoi(pp+1);	/* convert to decimal*/
           }

 	   if (prefix >= best_prefix) {	/* it's equal to or better */
	      i = (char *)strstr(pp,tmp);	/* find origin: delimiter */
              if (i != 0) {			/* it's nice if there is one */
	         i += strlen(DATA_DELIMITER);	/* skip delimiter... */
	         i++;				/* and the colon... */
	         while (*i == ' ') i++;		/* skip spaces */
		 /* i now points to start of origin AS string */
	         j = i;				/* terminate... */
		 while (*j >= '0') j++;
	         if (prefix > best_prefix) {
	            strcpy(origin,"/");		/* put a slash in */
	            best_prefix = prefix;		/* update best */
	         } else {
	            strcat(origin,"/");		/* put a mutiple as separator*/
	         }
	         strncpy(tmp4,i,(j-i));		/* copy new origin */
		 tmp4[j-i] = '\0';		/* null terminate it */
	         if (!(strstr(origin,tmp4))) {	/* if it's not a dup */
	            strncat(origin,i,(j-i));	/*  stick it in */
	         } else {
                    if (prefix == best_prefix) 	/* Otherwise remove slash */
                       origin[strlen(origin)-1] = '\0';
                 } /* end if not a dup */
	      } /* end if origin found */
	   } /* endif  prefix > best_prefix */
	   rp = (char *)strstr(rp+1,tmp2);	/* Find route: in the string */
	} /* end while */
	/*
	 * Go home... 
	 */
	close(s);
	if (best_prefix != 0) {			/* did we get anything? */
	   return((char *)&origin[1]);		/* strip off leading slash */
	} else {
	   return(NO_RADB_RECORD);
	}	   
}




short getshort(ptr)
char *ptr;
{
    union {
	short retval;
	char ch[2];
    } foo;

    foo.ch[0] = (*ptr & 0xff);
    foo.ch[1] = (*(ptr+1) & 0xff);

    return (foo.retval);
}

char *doresolve (name)
char *name;
{
  int query=QUERY;
  int qtype=T_SOA;
  int qclass=C_IN;
  unsigned char buf[256];
  char *ans;
  int blen, alen, got;
  int anssiz, i;
  short shrt;
  HEADER *h;
  char *contact_ptr;
  int ptr;

  anssiz = 512;
  ans = (char *)malloc(anssiz);
  if (!ans) {
    return(0);
  }

  blen = res_mkquery(query,name,qclass,qtype,NULL,0,NULL,(u_char *)buf,sizeof(buf));
  if (blen < 0) {
    return (0);
  }

  alen = res_send((unsigned char *)buf,blen,(unsigned char *)ans,anssiz);
  if (alen == -1) {
    return (0);
  }
 
  if (alen < 12) {
    return (0);
  }

  h = (HEADER *)ans;
  
  h->id = ntohs(h->id);
  h->qdcount = ntohs(h->qdcount);
  h->ancount = ntohs(h->ancount);
  h->nscount = ntohs(h->nscount);
  h->arcount = ntohs(h->arcount);

  if (h->ancount == 0) return(0);

  ptr = 12;	/* point at first question field */
  for (i=0; i< (int)h->qdcount && ptr<alen; i++) {
    ptr=doqd((unsigned char *)ans,ptr);
  }

  for (i=0; i< (int)h->ancount && ptr<alen; i++) {
    ptr=dorr((unsigned char *)ans,ptr,&contact_ptr);
  }

  return (contact_ptr);
}


doqd(ans,off)
unsigned char *ans;
int off;
{
    char name[256];

    name[0]=0;
    off = doname(ans,off,name);
    off = dotype(ans,off);
    off = doclass(ans,off);
    return (off);
}


dorr(ans,off,contact_ptr)
unsigned char *ans;
int off;
char **contact_ptr;
{
    int class, typ;
    char name[256];

    name[0]=0;
    off = doname(ans,off,name);
    typ = ntohs(getshort(ans+off));
    off = dotype(ans,off);
    class = ntohs(getshort(ans+off));
    off = doclass(ans,off);
    off = dottl(ans,off);
    off = dordata(ans,off,class,typ,name,contact_ptr);
    return(off);
}

doname(ans,off,name)
int off;
unsigned char *ans;
char *name;
{
    int newoff, i;
    char tmp[50];

	/* redirect? */
    if ((*(ans+off) & 0xc0) == 0xc0) {
	newoff = getshort(ans+off);
	newoff = 0x3fff & ntohs(newoff);
	doname(ans,newoff,name);
	return (off+2);
    }
	/* end of string */
    if (*(ans+off) == 0) {
	strcat(name," ");
	return(off+1);
    }
	/* token */
    for (i=1; i<=(int)*(ans+off); i++)
	tmp[i-1]=ans[off+i];
    tmp[i-1] = '.';
    tmp[i]=0;
    strcat(name,tmp);
    return (doname(ans,off+1+(*(ans+off)), name));
}


dotype(ans,off)
int off;
unsigned char *ans;
{
    return(off+2);
}


doclass(ans,off)
int off;
unsigned char *ans;
{
    return(off+2);
}


dottl(ans,off)
int off;
unsigned char *ans;
{
    return(off+4);
}


dordata(ans,off,class,typ,fname,contact_ptr)
unsigned char *ans;
int off,class,typ;
char *fname;
char **contact_ptr;
{
    int len = ntohs(getshort(ans+off));
    int retval = off+len+2;
    int i,j;
    char name[256];

    off += 2;
    switch (typ) {
	case T_SOA:
	    name[0]=0;
	    off = doname(ans,off,name);
	    name[0]=0;
	    off = doname(ans,off,name);
	    *contact_ptr=name;
	    return (0);
	default:
	    return (0);
    }
}

/*
	The VMS command line interface, DCL, uppercases all unquoted input.
	By default this program can be executed via
		$ mc location:traceroute options

	However, since this program needs case sensitivity for the various 
	options to work, it is defined as an alias ``symbol'' with open 
	quotes:
		$ traceroute == "location:traceroute """

	Unfortunately, this has the side effects of making argc=2, where 
	argv[0]	is the image location and name, and argv[1] is the entire 
	option line.  Thus for VMS we need to break the options up...

	Note that if the symbol VMS_CLD is defined, then this is not used
	at all, but rather the VMS Command Language Definition facility
	is used.

*/

void AbortIfNull (ThePointer)                                    
char *ThePointer;                                                
{                                                                
        if (ThePointer == NULL) {                                
                Fprintf(stderr, "bad flags on that switch!%s",terminator);
                exit(666);                                       
        };                                                       
}                                                                


#ifdef __vms		

			
fixargs(a,b,c)
int *a;			/* argc */
char **b;		/* argv */
char **c;		/* av */
{	
	char *ptr, *space;
	/* Set the image name */
	c[0] = b[0];

	/* Initialize pointers */
	*a = 1;
	ptr = b[1];
	if (*ptr == ' ') ptr++;		/* eliminate first space */

	/* Delineate all strings ending with space */
	while ((space = strchr(ptr,' ')) != 0) {
	   *space = '\0';
	   c[(*a)++] = ptr;
	   ptr = space + 1;
	}
	
	/* Transfer last one - ending with null */
	c[*a] = ptr;

	/* Update argc */
	(*a)++;
}

#endif /* vms */

