require 'net/http'
require 'uri/common'
Net::HTTP.version_1_2

class TVPlugin < Plugin

  $channellist = {
    "BBC1" => 92,
    "BBC1 Scotland" => 101,
    "BBC2" => 105,
    "BBC2 Scotland" => 113,
    "ITV" => 26,
    "ITV1 London" => 26,
    "Scottish" => 37,
    "Channel 4" => 132,
    "Five" => 134,
    "Animal Planet" => 39,
    "Artsworld" => 40,
    "BBC3" => 45,
    "BBC4" => 47,
    "BBC News 24" => 48,
    "BBC Parliament" => 49,
    "Biography Channel" => 119,
    "Bravo" => 122,
    "British Eurosport" => 123,
    "Carlton Cinema" => 127,
    "CBBC" => 482,
    "CBeebies" => 483,
    "Discovery Channel" => 147,
    "Discovery Home & Leisure" => 150,
    "Disney Channel" => 156,
    "E4" => 158,
    "FilmFour" => 160,
    "FilmFour Weekly" => 1041,
    "Ftn" => 921,
    "Granada Plus" => 177,
    "Hallmark" => 180,
    "History Channel" => 182,
    "ITV News" => 184,
    "ITV2" => 185,
    "Living" => 197,
    "National Geographic" => 213,
    "Paramount Comedy Channel" => 441,
    "Sci-Fi" => 244,
    "Sky 1" => 248,
    "Sky Movies Cinema 1" => 249,
    "Sky Movies Cinema 2" => 250,
    "Sky Movies Max 1" => 251,
    "Sky Movies Max 2" => 252,
    "Sky Movies Max 3" => 253,
    "Sky Movies Max 4" => 254,
    "Sky Movies Max 5" => 255,
    "Sky News" => 256,
    "Sky Movies Premier 1" => 257,
    "Sky Movies Premier 2" => 258,
    "Sky Movies Premier 3" => 259,
    "Sky Movies Premier 4" => 260,
    "Sky Sports 1" => 262,
    "Sky Sports 2" => 264,
    "Sky Sports 3" => 265,
    "Sky Sports Extra" => 263,
    "Sky Travel" => 266,
    "Sky Sports News" => 300,
    "TCM" => 271,
    "TV Travel Shop" => 274,
    "UK Bright Ideas" => 923,
    "UK Drama" => 292,
    "UK Food" => 423,
    "UK Gold" => 288,
    "UK History" => 801,
    "UK Horizons" => 290,
    "UK Style" => 291 }


  def help (plugin, topic="")
    "tvsearch <search terms> - search\ntvmore - see more results\ntvinfo <number> - see info about numbered programme\ntvchannels <comma separated list> - set the channels you want to search\ngetchannels - lists the channels you are currently set to search\ntvchanlist - lists all available channels"
  end

  # set users channel preferences
  def set_channels(m)
    line = m.params
    names = line.split(/,\s*/)

    channels = Array.new

    for chan in names
      if ($channellist.has_key?(chan))
	channels.push($channellist[chan])
      end
    end

    reply = "Set channels to: "
    for chan in channels
      reply = reply + $channellist.index(chan) + ", "
    end

    reply.chomp(", ")
    m.reply reply

    @registry[m.sourcenick] = channels
  end

  # retrieve the channel list from the registry
  def get_channels(m)
    channels = String.new("")
    if (@registry.has_key?(m.sourcenick))
      for num in @registry[m.sourcenick]
	channels = channels + num.to_s + ","
      end
      channels = channels.chomp(",")
      return channels
    else
      return "92,105,26,132,134"
    end
  end

  # Tell the user what channels are available
  def list_channels(m)
    list=$channellist.keys
    list.each_index{|num| list[num]=list[num]+", "}
    list[list.length-1].chomp(", ")
    m.reply list
  end

  def find_program(line)
    if line =~ /<b>(.*)<\/b><br>/
      $date[$prog_num] = $1
    end
    if line =~ /<a class="bluelink" href=".*">(.*)<\/a>/
      $channel[$prog_num] = $1
    end
    if line =~ /<a href="javascript:spawn_window\(.*src=(http:.*prog_details.jsp)'.*" class="bluelink".*/
      $url[$prog_num] = $1
    end
    if line =~ /<a href=".*" class="bluelink" title="(.*)"/
      $nameandtime[$prog_num] = $1
      $prog_num += 1
    end
  end

  def search(m)
    $prog_num = 0
    $listpos=0
    
    $date = Array.new
    $channel = Array.new
    $nameandtime = Array.new
    $url = Array.new
    
    if m.params
      search_term=m.params
      search_term.gsub!(/\s/, '+')
    else
      m.reply "I need something to search for"
    end
    
    connection = Net::HTTP.new("www.radiotimes.beeb.com", 80)
    
    response = connection.get("http://www.radiotimesbeeb.com/ListingsServlet?event=3&jspGridLocation=%2Fjsp%2Ftv_listings_grid.jsp&jspListLocation=%2Fjsp%2Ftv_listings_list.jsp&jspError=%2Fjsp%2Ferror.jsp&channels="+get_channels(m)+"&searchString=#{search_term}&go.x=40&go.y=9", nil)
    
    if response.code == "200"
      response.body.each_line {|line| find_program(line)}
    else
      m.reply "Failed to get any results"      
    end
    
    if $nameandtime.empty?
      m.reply "No programmes found"
    else
      if $prog_num > 5
	reply = sprintf("%d programmes found\nShowing the first 5\n", $nameandtime.length)
      else
	reply = sprintf("%d programmes found\n", $nameandtime.length)
      end
      m.reply reply
      
      while $listpos < $prog_num && $listpos < 5
	
	$nameandtime[$listpos] =~ /(.*)  \(.*\)/
	name = $1
	$nameandtime[$listpos] =~ /.*  \((.*)\)/
	time = $1
	
	reply = sprintf("%d: %s on %s at %s on %s\n", $listpos+1, name, $channel[$listpos], time, $date[$listpos])
	m.reply reply
	
	$listpos += 1
      end
    end
  end

  def tvmore(m)
    i = $listpos
    $listpos+=4

    if $listpos >= $prog_num
      $listpos = $prog_num-1
    end
    
    if $listpos == i-1
      m.reply "No more programmes listed"
    else
      reply = sprintf("Showing the next %d programme(s)\n", $listpos-i+1)
      m.reply reply
      
      while i <= $listpos
	$nameandtime[i] =~ /(.*)  \(.*\)/
	name = $1
	$nameandtime[i] =~ /.*  \((.*)\)/
	time = $1
	
	reply = sprintf("%d: %s on %s at %s on %s\n", i+1, name, $channel[i], time, $date[i])
	m.reply reply
	
	i += 1
      end
    end
  end
  
  def tvinfo(m)

    if !m.params
      m.reply "I need something to search for"
    end

    reply=printf("URL: %s", $url[m.params.to_i-1])
    m.reply reply

    connection = Net::HTTP.new("www.radiotimes.beeb.com", 80)
    response = connection.get($url[m.params.to_i-1], nil)

    if response.code == "200"
      response.body =~ /<br><b>Episode<\/b><br>\s*(.*?)\s*<br>/mu
      title = $1
      
      response.body =~ /<br><b>Review<\/b><br>\s*(.*?)\s*<br>/mu
      description = $1

      response.body =~ /<br><b>Cast List<\/b><br>\s*(.*?)\s*<br>/mu
      castlist = $1

    else
      m.reply "something went wrong"
    end

    

    if title
      m.reply "Episode Title: " + title
    end
    if description
      m.reply "Episode Description: " + description
    end
    if castlist
      m.reply "Cast: " + castlist
    end
    
  end


  def privmsg(m)
    if m.plugin == "tvsearch"
      search(m)
    elsif m.plugin == "tvmore"
      tvmore(m)
    elsif m.plugin == "tvinfo"
      tvinfo(m)
    elsif m.plugin == "tvchannels"
      set_channels(m)
    elsif m.plugin == "tvchanlist"
      list_channels(m)
    elsif m.plugin == "getchannels"
      reply = "Your channels are: "
      for chan in @registry[m.sourcenick]
	reply = reply + $channellist.index(chan) + ", "
      end
      reply.chomp(", ")
      m.reply reply
    end
  end

end
plugin = TVPlugin.new
plugin.register("tvsearch")
plugin.register("tvmore")
plugin.register("tvinfo")
plugin.register("tvchannels")
plugin.register("tvchanlist")
plugin.register("getchannels")
