/***************************************************************************
                          qsaneoption.h  -  description
                             -------------------
    begin                : Sat Mar 17 2001
    copyright            : (C) 2001 by Michael Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSANEOPTION_H
#define QSANEOPTION_H

#include <qwidget.h>
#include <qstrlist.h>
#include <sane/sane.h>
#include <sane/saneopts.h>

/**The base class for all
option widgets.
  *@author Michael Herder
  */
class QLabel;
class QString;

class QSaneOption : public QWidget
{
   Q_OBJECT
public: 
  QSaneOption(QString title,QWidget *parent,const char *name=0);
  ~QSaneOption();
  /**  */
  void setOptionNumber(int number);
  /**  */
  int optionNumber();
  /**  */
  void setOptionDescription(QString desc);
  /**  */
  QString optionDescription();
  /**  */
  QString optionName();
  /**  */
  void setSaneOptionNumber(int num);
  /**  */
  int saneOptionNumber();
  /**  */
  void setSaneConstraintType(SANE_Constraint_Type type);
  /**  */
  SANE_Constraint_Type saneConstraintType();
  /**  */
  void setSaneValueType(SANE_Value_Type type);
  /**  */
  SANE_Value_Type saneValueType();
  /**  */
  QString optionTitle();
  /**  */
  void setOptionSize(int size);
  /**  */
  int optionSize();
  /** No descriptions */
  void setSaneWordArray(QArray<SANE_Word> wa);
  /** No descriptions */
  QArray <SANE_Word> & saneWordArray();
  /** No descriptions */
  void setSaneRange(SANE_Range* sr);
  /** No descriptions */
  bool compareSaneRange(const SANE_Range* sr);
  /** No descriptions */
  QStrList strList();
  /** No descriptions */
  void setStrList(QStrList sl);
protected:
  /**  */
  void assignPixmap();
  /**  */
  QWidget* pixmapWidget();
private:
  /**  */
  QStrList mStringList;
  /**  */
  SANE_Range mSaneRange;
  /**  */
  int mOptionSize;
  /**  */
  int mOptionNumber;
  /**  */
  QString mOptionName;
  /**  */
  int mSaneOptionNumber;
  /**  */
  QString mOptionDescription;
  /**  */
  QLabel* mpPixmapWidget;
  /**  */
  QString mTitleText;
  /**  */
  SANE_Constraint_Type mSaneConstraintType;
  /**  */
  SANE_Value_Type mSaneValueType;
  /**  */
  QArray<SANE_Word> mSaneWordArray;
public slots:
  /**  */
  void slotEmitOptionChanged();
signals:
  /**  */
  void signalOptionChanged(int);
};

#endif
