import pygtk; pygtk.require("2.0")
import gtk
import gnome.vfs

def task_done():
    global counter
    counter -= 1
    if not counter:
        gtk.main_quit()

def write_callback(handle, bytes, exception, bytes_requested):
    print 'Write done:', handle, bytes, exception
    handle.close(lambda *args: None)
    task_done()
    
def read_callback(handle, buffer, exception, bytes_requested):
    print 'Read done:', handle, buffer, exception
    handle.close(lambda *args: None)
    task_done()

def create_callback(handle, exception):
    print 'Create done', handle, exception
    if not exception:
        handle.write('Hello world!\n', write_callback)
    else:
        task_done()

def symlink_callback(handle, exception):
    print 'Symlink done:', handle, exception
    task_done()

def open_callback(handle, exception):
    print 'Open done:', handle, exception
    if not exception:
        handle.read(14, read_callback)
    else:
        task_done()

def info_callback(handle, results):
    for uri, exception, info in results:
        print '-'*len(str(uri))
        print uri
        print '-'*len(str(uri))
        if not exception:
            try:
                print 'mime_type:\t', info.mime_type
                print 'size (bytes):\t', info.size
                print 'permissions:\t%o' % (info.permissions,)
            except ValueError:
                pass
            print
        else:
            print 'Error:\t', exception
    task_done()

def dir_callback(handle, results, exception):
    if not exception or exception == gnome.vfs.EOFError:
        for result in results:
            print result.name
            print '-'*len(str(result.name))
            try:
                print 'mime_type:\t', result.mime_type
                print 'size (bytes):\t', result.size
                print 'permissions:\t%o' % (result.permissions,)
            except ValueError:
                pass
            print
        if exception == gnome.vfs.EOFError:
            task_done()
    else:
        print 'Error:\t', exception
        task_done()

counter = 0

print 'Current job limit:', gnome.vfs.async.get_job_limit()

if 1:
    counter += 1
    print gnome.vfs.async.get_file_info(('/etc/fstab',
                                         'http://www.gnome.org/index.html'),
                                        info_callback,
                                        options = gnome.vfs.FILE_INFO_DEFAULT |
                                        gnome.vfs.FILE_INFO_GET_MIME_TYPE)
if 1:
    counter += 1
    print gnome.vfs.async.load_directory('fonts:',
                                         dir_callback,
                                         options =gnome.vfs.FILE_INFO_DEFAULT |
                                         gnome.vfs.FILE_INFO_GET_MIME_TYPE)


if 1:
    counter += 1
    print gnome.vfs.async.open('/etc/fstab', open_callback)

if 1:
    counter += 1
    print gnome.vfs.async.create('/tmp/test_file', create_callback)

if 1:
    counter += 1
    print gnome.vfs.async.create_symbolic_link('/tmp/test_link',
                                               '/etc/fstab',
                                               symlink_callback)

if counter:
    gtk.main()
