package Field;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Field.pm,v 1.5 2001/04/07 01:31:28 muaddie Exp $

use strict;
$Field::VERSION = '0.505';

=head1 NAME

Field - a named field maintaining an aggregated model and view.

=head1 SYNOPSIS

  ...
  use Field;

  my $field;
  my $html = init_html_page();
  $field = Field->new("example1");
  $field->set_value($cgi->param('example1'));
  my ($success,$problems) = $prev_input->verify();
  if (!$success) {
    $html .= 'You entered an invalid name.';
    return;
  }

=head1 DESCRIPTION

More to come.

=cut

use AtomicData;
use HTMLIO;

=head1 METHODS

In order to derive a non-virtual subclass, the public fucntion
C<html_input> must be implemented.

=head2 new

 FIXME
 class
 (Field $obj) new
   (string $name, string $data_class, variable @values)

DESCRIPTION:

More to come.

=cut

sub new {
  my ($proto, $name, $data, $view, $container) = @_;
  my $data_class      = ref($data)      || $data      || "AtomicData";
  my $view_class      = ref($view)      || $view      || "HTMLIO";
  my $container_class = ref($container) || $container || undef;

  my $this = {};
  bless $this, ref($proto)||$proto;

  if ($container_class) {
    my $container_obj = ref($container) ? $container : $container_class->new();
    $container_obj->set_data_class( ref($data_class) || $data_class );
    $this->{_data} = $container_obj;
  } else {
    $this->{_data} = ref($data) ? $data : $data_class->new();
  }

  $this->{_name} = $this->{_alias} = $name;
  $this->{_view} = ref($view) ? $view : $view_class->new();

  return $this;
}

=head2 name

 instance
 (string $name) name ()

DESCRIPTION:

Possibly sets and returns the simplified name of this field.

=cut

sub name {
  my ($this,$new_name) = @_;
  defined $new_name and $this->{_name} = $new_name;
  return $this->{_name};
}

=head2 alias

 instance
 (string $name) alias ([string $new_name])

DESCRIPTION:

Possibly sets and returns the viewable name of this field.

Example:

 $field->name('name');
 $field->alias('Name of Person');
 $html = $data->alias().': '.$data->html_input();

might set C<$html> to:

 'Name of Person: <input type="text" name="example" value="Zane">'

=cut

sub alias {
  my ($this,$new_alias) = @_;
  defined $new_alias and $this->{_alias} = $new_alias;
  return $this->{_alias};
}

sub set_attributes  { shift->{_view}->set_attributes(@_) }
sub attributes      { shift->{_view}->attributes(@_) }
sub set_display     { shift->{_view}->set_display(@_) }
sub raw_view { 
  my $f=shift; my $v=$f->{_view}; 
  return $v->raw_view( $f->{_data},@_ );
}
sub html_view { 
  my $f=shift; my $v=$f->{_view}; 
  return $v->html_view( $f->{_data},@_ );
}
sub html_hidden { 
  my $f=shift; my $v=$f->{_view}; 
  return $v->html_hidden( $f->name,$f->{_data},@_ );
}
sub html_input { 
  my $f=shift; my $v=$f->{_view}; 
  return $v->html_input( $f->name,$f->{_data},@_ );
}

sub set_data_class       { shift->{_data}->set_data_class(@_) }
sub data_class           { shift->{_data}->data_class(@_) }
sub set_parameters       { shift->{_data}->set_parameters(@_) }
sub set_parameter        { shift->{_data}->set_parameter(@_) }
sub parameters           { shift->{_data}->parameters(@_) }
sub reset_possible       { shift->{_data}->reset_possible(@_) }
sub set_possible_hash    { shift->{_data}->set_possible_hash(@_) }
sub set_possible         { shift->{_data}->set_possible(@_) }
sub possible_hash        { shift->{_data}->possible_hash(@_) }
sub set_value            { shift->{_data}->set_value(@_) }
sub value                { shift->{_data}->value(@_) }
sub canonical_value      { shift->{_data}->canonical_value(@_) }
sub canonicalize         { shift->{_data}->canonicalize(@_) }
sub set_format           { shift->{_data}->set_format(@_) }
sub get_format           { shift->{_data}->get_format(@_) }
sub format               { shift->{_data}->format(@_) }
sub set_orig_value       { shift->{_data}->set_orig_value(@_) }
sub prev_value           { shift->{_data}->prev_value(@_) }
sub orig_value           { shift->{_data}->orig_value(@_) }
sub poss_changed_p       { shift->{_data}->poss_changed_p(@_) }
sub changed_p            { shift->{_data}->changed_p(@_) }
sub verify               { shift->{_data}->verify(@_) }

sub free_internals { 
  my ($this,@args) = @_;

  $this->{_data} and $this->{_data}->free_internals(@args);
  delete $this->{_data};

  $this->{_view} and $this->{_view}->free_internals(@args);
  delete $this->{_view};

  return;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<CGI>, L<PSP::Loader>, L<PSP::Log>, L<PSP::Conf>

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
