/***************************************************************************
                          job_deletemediumfromdatabase.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_deletemediumfromdatabase.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#include "gui.h"

Job_DeleteMediumFromDatabase::Job_DeleteMediumFromDatabase(LVI_Medium *_lvi)
  : lvi(_lvi)
{}

void Job_DeleteMediumFromDatabase::run()
{
  int error = 0;

  app->lock();
  datadispatcher->eventAddEditLock();
  datadispatcher->eventMediumIsBusy(lvi);
  app->unlock();

  database->lock();
  database->deleteMedium(lvi->getID());
  error = database->getError();
  database->unlock();
  
  if(!error) {
    database->lock();
    app->lock();

    datadispatcher->eventMediumRemoved(lvi->getID());
    datadispatcher->eventNewArtistDelta(database->getArtistDelta());
    datadispatcher->eventNewTrackListing(database->getLastQuery());
    datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
    int ID = gui->getPlaylisting()->getDisplayedPlaylistID();
    if(ID > 0) datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(ID),ID);
    datadispatcher->eventRemoveEditLock();

    error  = database->getError();

    app->unlock();
    database->unlock();
  }

  if(error) {
    jobman->lock();
    jobman->addJob(new Job_DisconnectFromDatabase());
    jobman->unlock();
  }

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_DeleteMediumFromDatabase::~Job_DeleteMediumFromDatabase() {}
