#ifndef _Ui_h_
#define _Ui_h_
/* Ui.h
 *
 * Copyright (C) 1992-2004 Paul Boersma
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * pb 2004/12/06
 */

#include "Thing.h"
#include "Gui.h"
#ifndef _Interpreter_h_
	#include "Interpreter.h"
#endif

/* Forms for getting arguments from the user. */

/* Example of usage:
{
	static Any dia = NULL;
	if (dia == NULL) {
		Any radio;
		dia = UiForm_create
		  (topShell,			// The parent Widget of the dialog window.
			"Create a new person",		// The window title.
			DO_Person_create,		// The routine to call when the user clicks OK.
			NULL,				// The second argument to this routine (first is 'dia').
							// Normally the creator/owner, if dynamic.
			"Create person...");		// The help string; may be NULL.
		UiForm_addNatural (dia, "Age (years)",		"18");
		UiForm_addPositive (dia, "Length (metres)",	"1.68 (average)");
		UiForm_addBoolean (dia, "Beard",			FALSE);
		radio = UiForm_addRadio ("Sex",				1);
			UiRadio_addButton (radio, "Female");
			UiRadio_addButton (radio, "Male");
		UiForm_addWord (dia, "Colour",			"black");
		UiForm_addLabel (dia, "features", "Some less conspicuous features:");
		UiForm_addNatural (dia, "Number of birth marks",	"28");
		UiForm_addSentence (dia, "Favourite greeting",	"Good morning");
		UiForm_finish (dia);
	}
	UiForm_setReal (dia, "Length", myLength);
	UiForm_setInteger (dia, "Number of birth marks", 30);
	UiForm_do (dia, 0);   			// Show dialog box.
}
	Real, Positive, Integer, Natural, Word, and Sentence
		show a label (name) and an editable text field (value).
	Radio shows a label (name) and has RadioButton children.
	Label only shows its value.
	Text only shows an editable text field (value).
	Boolean shows a labeled toggle button which is on (1) or off (0).
	RadioButton does the same inside a radio box.
	As shown in the example, Real, Positive, Integer, Natural, and Word may contain extra text;
	this text is considered as comments and is erased as soon as you click OK.
	When you click "Use defaults", the default values (including comments)
	are restored to all items in the form.
*/

/* The following routines work on the screen and from batch. */
Any UiForm_create (Widget parent, const char *title,
	int (*okCallback) (Any dia, void *closure), void *okClosure,
	const char *helpTitle);
Any UiForm_addReal (I, const char *label, const char *defaultValue);
Any UiForm_addPositive (I, const char *label, const char *defaultValue);
Any UiForm_addInteger (I, const char *label, const char *defaultValue);
Any UiForm_addNatural (I, const char *label, const char *defaultValue);
Any UiForm_addWord (I, const char *label, const char *defaultValue);
Any UiForm_addSentence (I, const char *label, const char *defaultValue);
Any UiForm_addLabel (I, const char *name, const char *label);
Any UiForm_addBoolean (I, const char *label, int defaultValue);
Any UiForm_addText (I, const char *name, const char *defaultValue);
Any UiForm_addRadio (I, const char *label, int defaultValue);
	Any UiRadio_addButton (I, const char *label);
Any UiForm_addOptionMenu (I, const char *label, int defaultValue);
	Any UiOptionMenu_addButton (I, const char *label);
Any UiForm_addEnum (I, const char *label, void *enumerated, int defaultValue);
Any UiForm_addList (I, const char *label, long numberOfStrings, const char **strings, long defaultValue);
Any UiForm_addColour (I, const char *label, const char *defaultValue);
void UiForm_finish (I);
void UiForm_destroyWhenUnmanaged (I);

/* The following three routines set values in widgets. */
/* Do not call from batch. */
/* 'fieldName' is name from UiForm_addXXXXXX (), */
/* without anything from and including the first " (" or ":". */
void UiForm_setString (I, const char *fieldName, const char *text);
	/* Real, Positive, Integer, Natural, Word, Sentence, Label, Text, Radio, Enum, List. */
void UiForm_setReal (I, const char *fieldName, double value);
	/* Real, Positive. */
void UiForm_setInteger (I, const char *fieldName, long value);
	/* Integer, Natural, Boolean, Radio, Enum, List. */

void UiForm_do (I, int modified);
/*
	Function:
		put the form on the screen.
	Behaviour:
		If the user clicks "OK",
		the form will call the okCallback that was registered with UiForm_create ().

		If the okCallback returns 1, the form will disappear from the screen;
		if it returns 0, the form will stay on the screen; this can be used
		for enabling the user to repair mistakes in the form.

		If the user clicks "Cancel", the form disappears from the screen.

		If the user clicks "Help", the form calls "help" with the "helpTitle"
		and stays on the screen.

		When the form disappears from the screen, the values in the fields
		will remain until the next invocation of UiForm_do () for the same form.
	Arguments:
		the above behaviour describes the action when 'modified' is 0.
		If 'modified' is set, the user does not have to click OK.
		The form will still appear on the screen,
		but the okCallback will be called immediately.
*/

/* The 'okCallback' can use the following four routines to ask arguments. */
/* The field names are the 'label' or 'name' arguments to UiForm_addXXXXXX (), */
/* without anything from parentheses or from a colon. */
/* These routines work from the screen and from batch. */
double UiForm_getReal (I, const char *fieldName);	/* Real, Positive. */
long UiForm_getInteger (I, const char *fieldName);	/* Integer, Natural, Boolean, Radio, Enum, List. */
char * UiForm_getString (I, const char *fieldName);	/* Word, Sentence, Text, Radio, Enum, List. */
MelderFile UiForm_getFile (I, const char *fieldName); /* FileIn, FileOut */

double UiForm_getReal_check (I, const char *fieldName);
long UiForm_getInteger_check (I, const char *fieldName);
char * UiForm_getString_check (I, const char *fieldName);

int UiForm_parseString (I, const char *arguments);

Any UiInfile_create (Widget parent, const char *title,
  int (*okCallback) (Any dia, void *closure), void *okClosure,
  const char *helpTitle);

Any UiOutfile_create (Widget parent, const char *title,
  int (*okCallback) (Any dia, void *closure), void *okClosure,
  const char *helpTitle);

void UiInfile_do (Any dia);

void UiOutfile_do (Any dia, const char *defaultName);

MelderFile UiFile_getFile (Any dia);

void UiFile_hide (void);
/*
	Hides the visible UiFile that was opened most recently.
	Normally, file selectors stay open until their okCallback has completed.
	However, the okCallback may initiate an event loop allowing the user
	to interact with the application, for instance in Melder_pause ().
	In order that the user does not have to hide the modal file selector
	manually (by clicking the Cancel button), the application can call
	UiFile_hide () before Melder_pause ().
*/

void UiHistory_write (const char *format, ...);
char *UiHistory_get (void);
void UiHistory_clear (void);

void Ui_setAllowExecutionHook (int (*allowExecutionHook) (void *closure), void *allowExecutionClosure);
void UiInterpreter_set (Interpreter interpreter);
Interpreter UiInterpreter_get (void);

#endif
/* End of file Ui.h */
