#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <stdlib.h>

#include <config.h>
#include <support.h>

#include <xcio.h>
#include "Parts.h"
#include "Indicator.h"
#include "Time.h"
#include "xppxp.h"

static int auto_state = False;

void
NewLabel(char *label)
{
        strncpy(sc_name, label, sizeof(sc_name)-1);
        sc_name[sizeof(sc_name)-1]=0;
        reload_label();
}

void
ButtonSet(int auto_b, int link_b)
{
        Boolean auto_s;
        Boolean connect_s;

        XtVaGetValues((Widget)button1, XtNstate, &auto_s, NULL);
        XtVaGetValues((Widget)button2, XtNstate, &connect_s, NULL);

        if (auto_b != BS_Unchange) {
                XtVaSetValues((Widget)button1, 
                              XtNstate, (Boolean)auto_b, NULL);
                if (auto_b) {
                        auto_state = True;
                } else {
                        auto_state = False;
                }
        }
        if (link_b != BS_Unchange) {
                XtVaSetValues((Widget)button2, 
                              XtNstate, (Boolean)link_b, NULL);
                XtVaSetValues((Widget)button3, 
                              XtNstate, (Boolean)(!link_b), NULL);
        }
}

void
showLeds(int p_auto, int p_chat, int p_estb, int p_line, int p_auth, int p_net)
{
        int l1 = p_auto;
        int l2 = (p_chat | p_estb);
        int l3 = p_line;
        int l4 = p_auth;
        int l5 = p_net;

        if (l1 != BS_Unchange)
                XtVaSetValues((Widget)led1, XtNstate, (Boolean)l1, NULL);
        if (l2 != BS_Unchange)
                XtVaSetValues((Widget)led2, XtNstate, (Boolean)l2, NULL);
        if (l3 != BS_Unchange)
                XtVaSetValues((Widget)led3, XtNstate, (Boolean)l3, NULL);
        if (l4 != BS_Unchange)
                XtVaSetValues((Widget)led4, XtNstate, (Boolean)l4, NULL);
        if (l5 != BS_Unchange)
                XtVaSetValues((Widget)led5, XtNstate, l5, NULL);
}

void
showMeters(int in, int out)
{
        if (in != BS_Unchange)
                XtVaSetValues((Widget)indc, XtNinRate,  in,  NULL);
        if (out != BS_Unchange)
                XtVaSetValues((Widget)indc, XtNoutRate, out, NULL);
}

void
showConnectTime(int ct)
{
        if (ct != BS_Unchange)
                XtVaSetValues((Widget)tdisp, XtNtime,  ct,  NULL);
}

void
AutoButton(Widget w, XButtonEvent *event)
{
        Boolean auto_s;
        XtVaGetValues((Widget)button1, XtNstate, &auto_s, NULL);

        if (event->type == ButtonPress) {
                if (!auto_s) {
                        XtVaSetValues(w, XtNstate, True, NULL);
                }
        } else if (event->type == ButtonRelease) {
                if (auto_state) {
                        XtVaSetValues(button1, XtNstate, False, NULL);
                        PPxPCommandv(ppxpFd, XCMD_AUTO, "off", NULL);
                        auto_state = False;
                } else {
                        PPxPCommandv(ppxpFd, XCMD_AUTO, NULL);
                        auto_state = True;
                }
        }
}

void
ConnectButton(Widget w, XButtonEvent *event)
{
        if (event->type == ButtonPress) {
                XtVaSetValues(w, XtNstate, True, NULL);
                XtVaSetValues(button3, XtNstate, False, NULL);
        } else if (event->type == ButtonRelease) {
                PPxPCommandv(ppxpFd, XCMD_CONNECT, NULL);
        }
}

void
DisconnectButton(Widget w, XButtonEvent *event)
{
        if (event->type == ButtonPress) {
                XtVaSetValues(w, XtNstate, True, NULL);
                XtVaSetValues(button2, XtNstate, False, NULL);
        } else if (event->type == ButtonRelease) {
                PPxPCommandv(ppxpFd, XCMD_DISCONNECT, NULL);
        }
}

void
ByeButton(Widget w, XButtonEvent *event)
{
        Dimension width, height;

        if (event->type == ButtonPress) {
                XtVaSetValues(w, XtNstate, True, NULL);
        } else if (event->type == ButtonRelease) {
                XtVaSetValues(w, XtNstate, False, NULL);
                XtVaGetValues(w, XtNwidth, &width, NULL);
                XtVaGetValues(w, XtNheight, &height, NULL);
                if (event->x >= 0 && event->x < width
                    && event->y >= 0 && event->y < height) {
                        PPxPCommandv(ppxpFd, XCMD_BYE, NULL);
                }
        }
}

void
QuitButton(Widget w, XButtonEvent *event)
{
        Dimension width, height;
        if (event->type == ButtonPress) {
                XtVaSetValues(w, XtNstate, True, NULL);
        } else if (event->type == ButtonRelease) {
                XtVaSetValues(w, XtNstate, False, NULL);
                XtVaGetValues(w, XtNwidth, &width, NULL);
                XtVaGetValues(w, XtNheight, &height, NULL);
                if (event->x >= 0 && event->x < width
                    && event->y >= 0 && event->y < height) {
                        PPxPCommandv(ppxpFd, XCMD_QUIT, NULL);
                }
        }
}

void
Idling(Widget w, XButtonEvent *event)
{
        if (event->type == ButtonPress) {
                PPxPCommandv(ppxpFd, XCMD_SET, "IDLE.TIME", "300", NULL);
        }
}

void
Terminal(Widget w, XButtonEvent *event)
{
        if (event->type == ButtonPress) {
                if (event->x >= 121 && event->x < 185
                    && event->y >= 4 && event->y < 28) {
                    if (fork()==0) {
                            execlp("xterm", "xterm", "-e", "ppxp", NULL);
                    }
                }
        }
}
