/*
    Controller.m - Application controller for Poe.app
    Copyright (C) 2003 Rob Burns

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02111, USA.
*/

#include "Controller.h"

@implementation Controller

- (void) awakeFromNib
{
  NSUserDefaults *def = [NSUserDefaults standardUserDefaults];
  NSArray *temp;

  if([def arrayForKey: @"defaultTags"] == nil)
    {
      temp = [NSArray arrayWithObjects: @"TITLE",@"ARTIST",@"ALBUM",nil];
      [def setObject: temp forKey: @"defaultTags"];
    }
}

- (void) openFile: (id) sender
{
  OGGEditor *anOgg;
  NSOpenPanel *openPanel;
  NSArray *myTypes = [NSArray arrayWithObject:@"ogg"];
  int i;
  EditorWindowController *anEditor;

  openPanel = [NSOpenPanel openPanel];
  [openPanel setAllowsMultipleSelection: YES];
  [openPanel setCanChooseDirectories: NO];
  [openPanel setCanChooseFiles: YES];
  if([openPanel runModalForTypes: myTypes]==NSOKButton)
    {
      for(i=0;i<[[openPanel filenames] count];i++)
        {
          anOgg =AUTORELEASE(
            [[OGGEditor alloc] 
            initWithFile:[[openPanel filenames] objectAtIndex: i]]);

          anEditor = [[EditorWindowController alloc] 
            initWithEditor: anOgg];

          [[anEditor window] makeKeyAndOrderFront: self];
       }
    }
}

- (void) saveFile: (id) sender
{
  if([[[NSApp keyWindow] delegate] respondsToSelector: @selector(saveFile:)])
    {
      [[[NSApp keyWindow] delegate] saveFile: self];
    }
}

- (void) showInfo: (id) sender
{
  [NSApp orderFrontStandardInfoPanel: self];
}

- (void) showPrefs: (id) sender
{
  [[PreferencesWindowController singleInstance] showWindow: self];
}

- (void) addComment: (id) sender
{
  if([[[NSApp keyWindow] delegate] respondsToSelector: @selector(addComment:)])
    {
      [[[NSApp keyWindow] delegate] addComment: sender];
    }
}

- (void) deleteComment: (id) sender;
{
  if([[[NSApp keyWindow] delegate] respondsToSelector: @selector(deleteComment:)])
    {
      [[[NSApp keyWindow] delegate] deleteComment: sender];
    }
}

// NSApplication delegate methods
//********************************

- (void) applicationWillFinishLaunching: (NSNotification *)not
{
  [NSApp setApplicationIconImage:
    AUTORELEASE([NSImage imageNamed: @"Poe"])];
}

- (BOOL)application:(NSApplication*)application openFile:(NSString *)fileName
{
   OGGEditor *oggf;
   EditorWindowController *anEditor;

   if((oggf=AUTORELEASE([[OGGEditor alloc] initWithFile: fileName])))
    {
      anEditor = [[EditorWindowController alloc]
        initWithEditor: oggf];
      [[anEditor window] makeKeyAndOrderFront: self];
      return YES;
    }
  return NO;
}

@end
