/*
 * PIMPPA - adopter
 *
 * Adopter goes through matching fileareas (default=all) and adds 
 * missing files to the databases. (==File exists in directory, 
 * but not in database)
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <dirent.h>
#include <limits.h>
#include <ctype.h>

#include "pimppa.h"
#include "md5.h"
#include "adopt.h"

int Verbose=0;
int Options=0;
int NoSpace=0;
int NeedNumbers=0;
int NeedOthers=0;

MYSQL *src_db, *dst_db;

char AreaPattern[256]="%";				// Areas to operate on. Def=all

struct fileareas
{
	char area_filepath[PATH_MAX];
	int area_id;
	unsigned long area_flags;
	struct fileareas *next;
};

void usage(char *name)
{
	fprintf(stderr, "Usage: %s <options>\n\n"
					"-a <pattern>     Area SQL pattern to operate on, def=all\n"
					"-m <area_id>     Move from current dir, unknown to def. area_id\n"
					"-n               Nazi adopter. See docs.\n"
					"-v               Verbose execution\n", name);
}

int adopt(void)
{
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	int added_files=0, added_per_area=0;
	struct fileareas *areas=NULL;
	struct fileareas *tmp;

/******** find directories of matching fileareas  *******/

	fprintf(stderr, "Browsing fileareas...\n");

	p_query(src_db, "SELECT area_path, area_id, area_flags "
			"FROM p_areas "
			"WHERE area_name like '%s' AND area_id>=0 "
			"ORDER BY area_name DESC",
		AreaPattern);
	if(mysql_error(src_db)[0])
		return(-1);
	sql_res=mysql_use_result(src_db);
	if(!sql_res)
		return(-2);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		tmp=malloc(sizeof(struct fileareas));
		strcpy(tmp->area_filepath, sql_row[0]);
		if(!p_checkp(tmp->area_filepath))
			strcat(tmp->area_filepath, "/");
		tmp->area_id=atoi(sql_row[1]);
		tmp->area_flags=atol(sql_row[2]);
		tmp->next=NULL;

		if(!areas)
			areas=tmp;
		else
		{
			tmp->next=areas;
			areas=tmp;
		}
	}
	mysql_free_result(sql_res);
	
/**** go through the areas ******/

	tmp=areas;
	while(tmp)
	{
		added_per_area=0;

		fprintf(stderr, "Checking %s ", tmp->area_filepath);
	
		added_per_area=p_adopt(tmp->area_filepath, tmp->area_id, Options);
		added_files+=added_per_area;
			
		tmp=tmp->next;
		free(areas);
		areas=tmp;

		if(added_per_area)
			fprintf(stderr, "(%d added)\n", added_per_area);
		else
			fprintf(stderr, "\n");
	}

	return(added_files);
}
	

int main(int argc, char *argv[])
{
	int added_files;
	int domove=0,moveto=0;
	int go=1;
	char olddir[PATH_MAX];
	char *value;	

	while(go)
	{
		switch(getopt(argc, argv, "a:hm:nvV"))
		{
			case 'a':
				strcpy(AreaPattern, optarg);
				break;
			case 'h':
				usage(argv[0]);
				return(0);
				break;
			case 'm':
				domove=1;
				moveto=atoi(optarg);
				break;
			case 'n':
				Options|=OPT_NAZI;
				break;
			case 'v':
				Options|=OPT_VERBOSE;
				Verbose=1;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			default:
				go=0;
				break;
		}
	}	

	getcwd(olddir, PATH_MAX);
	
	src_db=p_connect();
	if(!src_db)
		return(0);

	dst_db=p_connect();
	if(!dst_db)
	{
		mysql_close(src_db);
		return(0);
	}

// Init some shit

    value=p_getmisc(dst_db, P_KEY_NOSPACE);
    if(value)
        NoSpace=atoi(value);
    else
    {
        NoSpace=atoi(P_NOSPACE);
        p_setmisc(dst_db, P_KEY_NOSPACE, P_NOSPACE);
    }

    value=p_getmisc(dst_db, P_KEY_NEEDNUMBERS);
    if(value)
        NeedNumbers=atoi(value);
    else
    {
        NeedNumbers=atoi(P_NEEDNUMBERS);
        p_setmisc(dst_db, P_KEY_NEEDNUMBERS, P_NEEDNUMBERS);
    }

    value=p_getmisc(dst_db, P_KEY_NEEDOTHERS);
    if(value)
        NeedOthers=atoi(value);
    else
    {
        NeedOthers=atoi(P_NEEDOTHERS);
        p_setmisc(dst_db, P_KEY_NEEDOTHERS, P_NEEDOTHERS);
    }

// Ok lets get on with it

	if(domove)
		p_adopt(olddir, moveto, Options|OPT_MOVE|OPT_STATS);
	else
	{
		added_files=adopt();
		printf("Done, %d files added.\n", added_files);
	}

	chdir(olddir);

	mysql_close(src_db);
	mysql_close(dst_db);

	return(0);
}

