/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#ifdef AIX
#include <sys/select.h>
#include <values.h>
#endif
#if !defined HP_UX
#include <fcntl.h>
#endif
#include <sys/wait.h>
#include <sys/types.h>
#include <pwd.h>
#ifdef HAS_SHADOW_PASSWD
#include <shadow.h>
#endif
#if defined SunOS_SOLARIS || defined unicos
#include <fcntl.h>
#endif
#include "main.h"
#if defined unicos || defined HP_UX
#define PFTP_THREAD_CAST (void *(*)(void *))
#else
#define PFTP_THREAD_CAST (void *)
#endif
#if defined __GNUC__ && defined __GNUC_MINOR__ && __GNUC__ > 1 && __GNUC_MINOR__ > 8 && !defined __RH_CYGLINT__
typedef socklen_t UNSIGNED_ARG_INT;
#else
typedef int UNSIGNED_ARG_INT;
#endif


extern void accs(int, int, char *);
extern void server_filter_programm(void *);
extern void receive_data(void *);
extern void free_memory(void);
extern void signal_handling(int);
extern int init_struct(void);
extern short get_var_from_pftprc(FILE *, const char *, char *, int);
extern short check_login(int);
#if !defined __RH_CYGLINT__
extern int init_user_id(int);
#endif
extern char *time_string(void);
extern int check_accepted_hosts(char **, int);
extern int search_hl_entry(int);
void login_handle(void *);
void deny_login(void *);

/*
 * Server--This is the server part of pftp.
 */
void Server(int portn)
{
   char hostname[SONAME];
   int ns=0, ws=0;
#ifdef HAVE_INET6
   struct sockaddr_in6 fsin;
#else
   struct sockaddr_in fsin;
#endif
#ifdef USE_POSIX_THREAD
   pthread_t thr[MAXCLIENTS];
   pthread_attr_t thrattr;
#else
#ifdef AIX
   SELLIST(BITS(int), BITS(int)) rfds;
#else
   fd_set rfds;
#endif
   int child_status=0;
   pftp_tv tv;
#endif
   int fsinlen=sizeof(fsin);
   int pid=0;
   int strnum=0;


   /*
    * Initialize signal thread attribute.
    */
#ifdef USE_POSIX_THREAD
   pthread_attr_init(&thrattr);
   pthread_attr_setdetachstate(&thrattr, PTHREAD_CREATE_DETACHED);
   pthread_mutex_init(&interactiv, NULL);
#endif

   /*
    * Initialize signal handling.
    */
   if ((*statstr)->ttys) {
      signal_handling((SET_SIG_SERVER | SET_SERVER_HANDLER | SET_SIGNALS));
   }

   /*
    * Set stderr.
    */
   if (!slfp) {
      char *slogname = NULL;
      if ((slogname = getenv("PFTPSLOG")));
      else {
         MEM_CHECK((slogname = (char *)calloc(SONAME, sizeof(char))));
         if (!get_var_from_pftprc((FILE *)NULL, "PFTPSLOG", slogname, 0)) {
            free(slogname);
            slogname = NULL;
         }
      }
      if (slogname) {
         if ((slfp = fopen(slogname, "a")) == NULL) {
            fprintf(stderr, "** %s: %s\n", slogname, _PFTP_ERROR_ARRAY_);
            exit(PFTP_OPEN_LOG_ERR);
         }
         chmod(slogname, 0600);
         if (!getenv("PFTPSLOG")) {
            free(slogname);
            slogname = NULL;
         }
      }
      if (!(*statstr)->OVERWRITE) (*statstr)->_SKIP_ = 1;
   }

   /*
    * Started by inetd.
    */
   if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
      (*statstr)->exit_afc = 1;
      s = dup(0);
      dup2(ns, 0);
      dup2(ws, 2);
      close(1);
   }
   else {
      /*
       * Initialize socket s, and perform some
       * socket options.  Eventually bind our
       * address to the socket.
       */
      accs((short)1, portn, hostname);
   }
   if ((*statstr)->exit_afc || (*statstr)->use_udp) {
      (*statstr)->single_connection = 1;
   }
   if (!(*statstr)->use_udp && !((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
      /*
       * Listen on the socket.
       */
      if (listen(s, (*statstr)->single_connection ? 1: (*statstr)->maxclients) < 0) {
         if (slfp) fprintf(slfp, "** listen: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_LISTEN_ERR);
      }
   }

   while (s) {
      if (!(*statstr)->use_udp) {
         if ((*statstr)->OVERWRITE == 1) (*statstr)->OVERWRITE=0;
         if (!((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
#if !defined USE_POSIX_THREAD
            if (!(*statstr)->single_connection) {
               do {
#ifdef AIX
                  /* The follwoing is just written as I understood
                   * the AIX select manual and it works.  If you
                   * know more about this construct, please drop
                   * me an e-mail.  Thanks in advance!
                   */
                  rfds.fdsmask[s / BITS(int)] = 1 << (s % BITS(s));
#else
                  FD_ZERO(&rfds);
                  FD_SET(s, &rfds);
#endif
                  tv.tv_sec = 0;
                  tv.tv_usec = 200000;
                  /*
                   * See if childs exited.
                   */
                  if (waitpid((pid_t)-1, &child_status, WNOHANG) > 0) (*statstr)->no_clients--;
               }
#ifdef AIX
               while (select(BITS(s), &rfds, NULL, NULL, (struct timeval *)&tv) <= 0);
#else
               while (select(s+1, &rfds, NULL, NULL, (struct timeval *)&tv) <= 0);
#endif
#ifdef AIX
               if (!(rfds.fdsmask[s / BITS(int)] & (1 << (s % BITS(s))))) continue;
#else
               if (!FD_ISSET(s, &rfds)) continue;
#endif
            }
#endif /* not USE_POSIX_THREAD */
            /*
             * Accept connections.  When we accept one, ns
             * will be connected to the client.
             */
            if ((ns = accept(s, (struct sockaddr *)&fsin, (UNSIGNED_ARG_INT *)&fsinlen)) < 0) {
               if (slfp) fprintf(slfp, "** accept: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_ACCEPT_ERR);
            }
            ws = ns;
         }
         else {
            if (getpeername(ns, (struct sockaddr *)&fsin, (UNSIGNED_ARG_INT *)&fsinlen) < 0) {
               close(ns);
               s = 0;
               continue;
            }
         }
      }
      else {
         ns = s;
#ifndef USE_POSIX_THREAD
         (*statstr)->no_clients = 0;
#endif
      }
      if ((*statstr)->_PFTP_DAEMON_) (*statstr)->usefilter = 0;
#ifdef USE_POSIX_THREAD
      if (!(strnum = init_struct())) {
         close(ns);
         if (slfp) {
            if ((*statstr)->_PFTP_DAEMON_) {
               fprintf(slfp, "%s Limit exceeded\n", time_string());
            }
            else {
               fprintf(slfp, "%s** Limit exceeded\n", \
                      (*statstr)->RECEIVING ? "\n": "");
               (*statstr)->RECEIVING = 0;
            }
         }
         if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) s = 0;
         continue;
      }
#else
      strnum = 0;
      if (!(*statstr)->single_connection) {
         (*statstr)->no_clients++;
         if ((*statstr)->no_clients > (*statstr)->maxclients) {
            (*statstr)->no_clients--;
            if (slfp) {
               if ((*statstr)->_PFTP_DAEMON_) {
                  fprintf(slfp, "%s Limit exceeded\n", time_string());
               }
               else {
                  fprintf(slfp, "\n** Limit exceeded\n");
               }
            }
            if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) s = 0;
            close(ns);
            continue;
         }
      }
      else if (!(*statstr)->use_udp) (*statstr)->no_clients = 1;
      if ((*statstr)->_PFTP_DAEMON_) {
         (*statstr)->rename = 0;
         (*statstr)->accept_file_info = 1;
      }
      (*statstr)->first = 0;
      (*statstr)->fad_info = 0;
      *((*statstr)->from) = 0;
      *((*statstr)->rlogin) = 0;
      *((*statstr)->pw_dir) = 0;
      *((*statstr)->pw_name) = 0;
      *((*statstr)->pw_passwd) = 0;
      *((*statstr)->uplimit_lock) = 0;
      *((*statstr)->incoming_lock) = 0;
      (*statstr)->cwd_last_ch = (*statstr)->cwd;
      *((*statstr)->cwd) = 0;
#endif
      if (!(*statstr)->use_udp) {
         if (((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
            (*(statstr+strnum))->ns = dup(ns);
            (*(statstr+strnum))->ws = dup(ws);
         }
         else {
            (*(statstr+strnum))->ns = ns;
            (*(statstr+strnum))->ws = ws;
         }

         /*
          * Save binary address for later resolvation.
          */
         memcpy(&(*(statstr+strnum))->sin, &fsin, fsinlen);
#ifdef HAVE_INET6
         (*(statstr+strnum))->sinlen = fsinlen;
#endif
      }
      if (!(*statstr)->single_connection) {
#ifdef USE_POSIX_THREAD
         if ((pid = pthread_create(&thr[strnum], &thrattr, PFTP_THREAD_CAST &login_handle, (void *)&strnum))) {
            close(ns);
            if (slfp) fprintf(slfp, "** pthread_create: %s\n", _PFTP_ERROR_ARRAY_PID_);
            (*(statstr+strnum))->free = 1;
            if ((*statstr)->_PFTP_DAEMON_ & BIT_TWO) s = 0;
            continue;
         }
#else
         if ((pid = fork()) < 0) {
            if ((*statstr)->_PFTP_DAEMON_ & BIT_TWO) s = 0;
            if (slfp) fprintf(slfp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
            close(ns);
            continue;
         }

         if (!pid) {
            if ((*statstr)->ttys) {
               signal_handling((DFL_SIGNAL | SET_SIG_SERVER | SET_SIGNALS));
            }
            (*statstr)->isparent = 0;
            login_handle((void *)&strnum);
            s = 0;
         }
         else close(ns);
#endif /* USE_POSIX_THREAD */
      }
      /*
       * Standard input/output or '-i' specified.
       */
      else {
         (*(statstr+strnum))->fd = (*(statstr+strnum))->ns;
         login_handle((void *)&strnum);
         if ((*statstr)->exit_afc) s = 0;
      }
   }
   free_memory();
}


void login_handle(void *structure_number)
{
   int strnum = (int)*(int *)structure_number;
#ifdef HAVE_INET6
   struct sockaddr_in6 *fsin = &(*(statstr+strnum))->sin;
   int fsinlen=(*(statstr+strnum))->sinlen;
   int ret=0;
   char cptmp[IPv6_BIN_ADDR_LENGTH];
#else
   struct hostent *hp;
   struct sockaddr_in *fsin = &(*(statstr+strnum))->sin;
#endif
   int goon=1, optval=(*statstr)->bsize;

   if (!(*statstr)->use_udp) {
      /*
       * Get client's host name.
       */
#ifdef HAVE_INET6
      if ((ret = getnameinfo((struct sockaddr *)fsin, fsinlen, \
         (*(statstr+strnum))->REMOTEHOSTNAME, SONAME*sizeof(char), NULL, 0, 0))) {
         if (!inet_ntop(fsin->sin6_family, fsin->sin6_addr.s6_addr, \
            (*(statstr+strnum))->REMOTEHOSTNAME, INET6_ADDRSTRLEN)) {
            if (slfp) {
               fprintf(slfp, "%s Cannot convert binary address string\n", \
                      (*statstr)->_PFTP_DAEMON_ ? time_string(): "**");
            }
            close((*(statstr+strnum))->ns);
#ifdef USE_POSIX_THREAD
            (*(statstr+strnum))->free = 1;
#endif
            return;
         }
      }
#else
      if ((hp = gethostbyaddr((char *)&(fsin->sin_addr), sizeof(fsin->sin_addr), AF_INET)) == 0) {
         strcpy((*(statstr+strnum))->REMOTEHOSTNAME, inet_ntoa(fsin->sin_addr));
      }
      else {
         strcpy((*(statstr+strnum))->REMOTEHOSTNAME, hp->h_name);
      }
#endif

      /*
       * Check if remote server has a valid host name.
       */
      if (*_CLIENTHOSTNAME_) {
         /*
          * Reading and checking PFTPCLIENTS from system resource file.
          */
         if (!check_accepted_hosts(_CLIENTHOSTNAME_, strnum)) {
            if (slfp) {
#ifdef HAVE_INET6
               fprintf(slfp, "%s Connection to %s (%s) refused\n", \
               (*statstr)->_PFTP_DAEMON_ ? time_string(): "**", \
               (*(statstr+strnum))->REMOTEHOSTNAME, \
               inet_ntop(fsin->sin6_family, fsin->sin6_addr.s6_addr, cptmp, IPv6_BIN_ADDR_LENGTH) ? \
               cptmp: (*(statstr+strnum))->REMOTEHOSTNAME);
#else
               fprintf(slfp, "%s Connection to %s (%s) refused\n", \
               (*statstr)->_PFTP_DAEMON_ ? time_string(): "**", \
               (*(statstr+strnum))->REMOTEHOSTNAME, \
               inet_ntoa(fsin->sin_addr));
#endif
            }
            close((*(statstr+strnum))->ns);
#ifdef USE_POSIX_THREAD
            (*(statstr+strnum))->free = 1;
#endif
            return;
         }
      }

      /*
       * Set receive buffer.
       */
      if (setsockopt((*(statstr+strnum))->ns, SOL_SOCKET, SO_RCVBUF, \
         (char *)&optval, sizeof(optval)) < 0) {
         goon = 0;
      }
      if (goon && write((*(statstr+strnum))->ws, "PFTP ", 5) < 0) {
         goon = 0;
      }
      if (goon && write((*(statstr+strnum))->ws, VERSION, VERSION_LENGTH) < 0) {
         goon = 0;
      }
      if (goon && write((*(statstr+strnum))->ws, "\n", 1) < 0) {
         goon = 0;
      }
      if (!goon) {
#ifdef USE_POSIX_THREAD
         (*(statstr+strnum))->free = 1;
#endif
         return;
      }
#if !defined __RH_CYGLINT__
      /*
       * If running as a daemon or
       * server started by inetd...
       */
      if ((*statstr)->_PFTP_DAEMON_) {
         if (check_login(strnum)) {
            /*
             * Set user's uid, gid, and groups.
             */
            if (goon && !init_user_id(strnum)) goon = 0;

            /*
             * Look up host in user's host name list.
             */
            if (goon && !search_hl_entry(strnum)) {
               send((*(statstr+strnum))->ws, PFTP_DATA_DENIED, PFTP_DATA_DENIED_LEN, MSG_OOB);
               if (slfp) {
                  fprintf(slfp, "%s %s accepts no data from %s\n", \
                  time_string(), (*(statstr+strnum))->pw_name, \
                  (*(statstr+strnum))->REMOTEHOSTNAME);
               }
               goon = 0;
            }
         }
         else {
            if (slfp) fflush(slfp);
            if (*((*(statstr+strnum))->incoming_lock)) {
               unlink((*(statstr+strnum))->incoming_lock);
               *((*(statstr+strnum))->incoming_lock) = '\0';
            }
            if (*((*(statstr+strnum))->uplimit_lock)) {
               unlink((*(statstr+strnum))->uplimit_lock);
               *((*(statstr+strnum))->uplimit_lock) = '\0';
            }
            if (*((*(statstr+strnum))->REMOTEHOSTNAME) \
               && write((*(statstr+strnum))->ws, "COME ON", 7) > 0) {
                  deny_login((void *)&strnum);
            }
            goon = 0;
         }
      }
      else {
#endif
         /*
          * Look if host is set in host name list.
          */
         search_hl_entry(strnum);

         /*
          * Send status to the client.
          */
         if (goon && write((*(statstr+strnum))->ws, "STAT server\n", 12) < 0) {
            if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
         }
#if !defined __RH_CYGLINT__
      }
#endif
#ifdef USE_POSIX_THREAD
      CHILDNUM++;
#endif
   }
   /*
    * UDPs are always unfiltered.
    */
   else (*(statstr+strnum))->usefilter = 0;

   if (goon) {
      /*
       * Clients sends filtered data.
       */
      if ((*(statstr+strnum))->usefilter) {
         if (slfp && !(*statstr)->_PFTP_DAEMON_) fprintf(slfp, "\n* Filter is receiving data from %s ...\n", (*(statstr+strnum))->REMOTEHOSTNAME);
         server_filter_programm((void *)&strnum);
      }
      /*
       * Client sends unfiltered data.
       */
      else {
         (*(statstr+strnum))->fd = (*(statstr+strnum))->ns;
         receive_data((void *)&strnum);
      }
   }
   if (slfp) fflush(slfp);
   if (!(*statstr)->use_udp) {
      close((*(statstr+strnum))->ns);
      if (*((*(statstr+strnum))->incoming_lock)) {
         unlink((*(statstr+strnum))->incoming_lock);
      }
      if (*((*(statstr+strnum))->uplimit_lock)) {
         unlink((*(statstr+strnum))->uplimit_lock);
      }
   }
#ifdef USE_POSIX_THREAD
   if (CHILDNUM) CHILDNUM--;
   (*(statstr+strnum))->free = 1;
#endif
}


int wait_for_data(int ns)
{
#ifdef AIX
   SELLIST(BITS(int), BITS(int)) rfds;
#else
   fd_set rfds;
#endif
   pftp_tv tv;
#ifdef AIX
   rfds.fdsmask[ns / BITS(int)] = 1 << (ns % BITS(ns));
#else
   FD_ZERO(&rfds);
   FD_SET(ns, &rfds);
#endif
   tv.tv_sec = _PFTP_TIMEOUT;
   tv.tv_usec = 0;
#ifdef AIX
   if (select(BITS(ns), &rfds, NULL, NULL, (struct timeval *)&tv) > 0)
#else
   if (select(ns+1, &rfds, NULL, NULL, (struct timeval *)&tv) > 0)
#endif
   {
#ifdef AIX
      if ((rfds.fdsmask[ns / BITS(int)] & (1 << (ns % BITS(ns))))) return 1;
#else
      if (FD_ISSET(ns, &rfds)) return 1;
#endif
   }
   return 0;
}


void deny_login(void *structure_number)
{
   int strnum = (int)*(int *)structure_number;
   int ns=(*(statstr+strnum))->ns;
   char str[SONAME];
   if (wait_for_data(ns)) read(ns, str, SONAME);
   send((*(statstr+strnum))->ws, PFTP_LOGIN_ERR, PFTP_LOGIN_ERR_LEN, MSG_OOB);
}
