/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : pentasnc.c 
 * date    : 2000-03-15
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#if 0 /* if you want to debug, set to 1 */
#define PENTASNC_DEBUG
#endif

#include <linux/modversions.h> /* to avoid unresolved symbol */
#include <linux/module.h>
#include <linux/version.h>
#include <linux/netdevice.h>   /* struct device,other headers */

#include "pridef.h"
#include "pentadrv.h"
#include "pentasn.h"
#include "pentaif.h"

#include "share/hwpacket.h"


/*--------------------------------*/
/* Constant definitions */
/*--------------------------------*/
/* Tx buffer */
#define NE2000_HEADER_SIZE 14
#define INTER_LOOKAHEAD_SIZE 4096


/*--------------------------------*/
/* Structure definitions */
/*--------------------------------*/
typedef struct _UTM_CONTEXT{
	QBUF_CONTROL RcvWrite[16];
}UTM_CONTEXT, *PUTM_CONTEXT;

struct pentanet_info {
	struct net_device *dev[MAX_CARD];
	struct pentanet_private *priv[MAX_CARD];
	UTM_CONTEXT xUtmcontext[MAX_CARD];
	unsigned char oBuf[MAX_CARD][0x2000];
	unsigned int  uiAddrlen[MAX_CARD];
	unsigned char oMultiAddr[MAX_CARD][6*100];
	unsigned long ulMipinfo[MAX_CARD][MAX_MIP_INFO];
};


/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
struct pentanet_spinfo psPentanetspinfo;
struct net_device *g_dev_base = NULL;
static struct pentanet_info psPentanetinfo;


/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/* 
 * Func : PacketProcess_Action  
 * Context :
 */
static void PacketProcess_Action( struct net_device *dev )
{
	unsigned long lDoMore,i,p;
	QBUF_CONTROL *pQueue;
	unsigned char bTemp;
		
    	struct pentanet_private *tp  = (struct pentanet_private *)(dev->priv);
    	lDoMore = 1;

    	for(i = 0;i < MAX_DATA_PID; i++){
		p = i;
		do{
			pQueue = &psPentanetinfo.xUtmcontext[g_index].RcvWrite[p];
    
			if( psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Muse == MFree){
				psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Moffset = 0;
				psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Muse = MWrite;	
			}
	
			lDoMore = HWP_GetPacketData(p,&psPentanetinfo.xUtmcontext[g_index].RcvWrite[p],INTERNET_MODE);
	
			if(psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Muse == MReady){
				if(psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Moffset){
					memcpy(psPentanetinfo.oBuf[g_index], pQueue->Mheader, NE2000_HEADER_SIZE);
					memcpy(&psPentanetinfo.oBuf[g_index][NE2000_HEADER_SIZE], pQueue->Mbuffer, pQueue->Moffset);
		
					bTemp = psPentanetinfo.oBuf[g_index][0] |
						psPentanetinfo.oBuf[g_index][1] |
						psPentanetinfo.oBuf[g_index][2] |
						psPentanetinfo.oBuf[g_index][3] |
						psPentanetinfo.oBuf[g_index][4] |
						psPentanetinfo.oBuf[g_index][5]; 

					if(bTemp == 0){
						memcpy(&psPentanetinfo.oBuf[g_index][0],&dev->dev_addr[0],6);	
					}
					psPentanetinfo.oBuf[g_index][12] = 0x08;
					psPentanetinfo.oBuf[g_index][13] = 0x00;
		
					if( (psPentanetinfo.oBuf[g_index][0]==0x01) && (psPentanetinfo.oBuf[g_index][1]==0x00) && (psPentanetinfo.oBuf[g_index][2] == 0x5e) && (g_priv->route_dev != NULL))
					{
						PentaNet_rx_tx(dev,NE2000_HEADER_SIZE+pQueue->Moffset,psPentanetinfo.oBuf[g_index]);
					} else {
						PentaNet_rx(dev,NE2000_HEADER_SIZE+pQueue->Moffset,psPentanetinfo.oBuf[g_index]);
					}

				
					tp->stats.rx_packets++;
					tp->stats.rx_bytes += pQueue->Moffset;
	    			}
	    
				psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Muse = MFree;
	    			psPentanetinfo.xUtmcontext[g_index].RcvWrite[p].Moffset = 0;
			}
		
		}while(!lDoMore);
	}
}


/* 
 * Func : PacketProcess  
 * Context :
 */
void PacketProcess( struct net_device *dev )
{
	PacketProcess_Action(dev);
}


/* 
 * Func : sub_open  
 * Context :
 */
void sub_open( struct net_device *dev )
{
    	int i;
      	
    	for(i = 0;i < MAX_DATA_PID; i++){
		psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Muse = MFree;
		psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Msize = INTER_LOOKAHEAD_SIZE;
		psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Moffset = 0;
		psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Mheader = if_kmalloc(NE2000_HEADER_SIZE,GFP_ATOMIC);
		psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Mbuffer = if_kmalloc(INTER_LOOKAHEAD_SIZE,GFP_ATOMIC);
	}
}


/* 
 * Func : sub_release  
 * Context :
 */
void sub_release( struct net_device *dev )
{
	int i;
	
	for(i = 0; i < MAX_DATA_PID; i++){
	    if_kfree( psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Mheader );
	    if_kfree( psPentanetinfo.xUtmcontext[g_index].RcvWrite[i].Mbuffer );
	}
}


/* 
 * Func : ff_get_all_packets  
 * Context : routing function
 */
void ff_get_all_packets( void )
{
	psPentanetspinfo.iFilterflag[g_index] = 0x01;
}


/* 
 * Func : ff_get_all_multicast_packets  
 * Context : route function
 */
void ff_get_all_multicast_packets( void )
{
	psPentanetspinfo.iFilterflag[g_index] = 0x02;
}


/* 
 * Func : ff_get_only_own_packets  
 * Context :
 */
void ff_get_only_own_packets( void )
{
	psPentanetspinfo.iFilterflag[g_index] = 0x00;

   	HWP_SetMultiCast( NULL, 0 );
}


/* 
 * Func : ff_clear_mc_list  
 * Context : 
 */
void ff_clear_mc_list( void )
{
    	psPentanetinfo.uiAddrlen[g_index] = 0;
}


/* 
 * Func : ff_store_mc_address  
 * Context :
 */
void ff_store_mc_address(char *dmi_addr)
{
    	memcpy(&psPentanetinfo.oMultiAddr[g_index][psPentanetinfo.uiAddrlen[g_index]],dmi_addr,6);
    	psPentanetinfo.uiAddrlen[g_index] += 6;
}


/* 
 * Func : ff_get_packets_in_multicast_list  
 * Context :
 */
void ff_get_packets_in_multicast_list( void )
{
	psPentanetspinfo.iFilterflag[g_index] = 0x00;
   	HWP_SetMultiCast( psPentanetinfo.oMultiAddr[g_index], psPentanetinfo.uiAddrlen[g_index]);
}


/* 
 * Func : sm_multi_route_device  
 * Context :
 */
unsigned int sm_multi_route_device(unsigned char *dev_name)
{
	int iresult;
	struct net_device *temp_dev;    
       
	iresult = 0;
	temp_dev = g_dev_base;

	while(temp_dev != NULL){
		if(strcmp(temp_dev->name, dev_name) == 0){
			g_priv->route_dev = temp_dev;
			iresult = 1;
			break;
		}
		temp_dev = temp_dev->next;
	}
	return iresult;
}


/* 
 * func : sm_multi_ip_all  
 * Context 
 */
void sm_multi_ip_all( int flag )
{
    	if( flag == 1){
		psPentanetspinfo.uiMipflag[g_index] = 1;
	}else{ 
		psPentanetspinfo.uiMipflag[g_index] = 0;
	}
}

/* 
 * func : sm_mmac  
 * Context :
 */
void set_mmac( int i, unsigned long mip )
{
	/* activate */
	psPentanetspinfo.oMmacinfo[g_index][i][0] = 0x00;
	psPentanetspinfo.oMmacinfo[g_index][i][1] = 0x01;
	psPentanetspinfo.oMmacinfo[g_index][i][2] = 0x01;
	psPentanetspinfo.oMmacinfo[g_index][i][3] = 0x00;
	psPentanetspinfo.oMmacinfo[g_index][i][4] = 0x5e;
	psPentanetspinfo.oMmacinfo[g_index][i][5] = (mip >> 16) & 0x07f;
	psPentanetspinfo.oMmacinfo[g_index][i][6] = (mip >> 8) & 0x0ff;
	psPentanetspinfo.oMmacinfo[g_index][i][7] = mip  & 0x0ff;
}


/* 
 * func : del_mmac  
 * COntext :
 */
void del_mmac( int i )
{
	/* deactivate */
	psPentanetspinfo.oMmacinfo[g_index][i][0] = 0x00;
	psPentanetspinfo.oMmacinfo[g_index][i][1] = 0x00;
}


/* 
 * func : sm_multi_ip_add  
 * Context :
 */
void sm_multi_ip_add( unsigned long  mip )
{
	int i;
    	
    	for( i = 0; i< psPentanetspinfo.uiMipcount[g_index]; i++){
	    	if( psPentanetinfo.ulMipinfo[g_index][i] == 0){
			psPentanetinfo.ulMipinfo[g_index][i] = mip;
		    	set_mmac(i,mip);
		    	return;
		}

	    	if( psPentanetinfo.ulMipinfo[g_index][i] == mip){
			return;
		}
	}
	
	if(( psPentanetspinfo.uiMipcount[g_index] == i) && 
	   ( psPentanetspinfo.uiMipcount[g_index] < MAX_MIP_INFO)){
	    	psPentanetinfo.ulMipinfo[g_index][psPentanetspinfo.uiMipcount[g_index]] = mip;
		set_mmac(psPentanetspinfo.uiMipcount[g_index], mip);
		psPentanetspinfo.uiMipcount[g_index]++;
	}
}


/* 
 * func : sm_multi_ip_del  
 * Context :
 */
void sm_multi_ip_del(unsigned long mip)
{
   	int i;
       
	for( i = 0; i < psPentanetspinfo.uiMipcount[g_index]; i++ ){
		if( psPentanetinfo.ulMipinfo[g_index][i] == mip){
		    	psPentanetinfo.ulMipinfo[g_index][i] = 0;
			del_mmac(i);
		}	    
	}	    
}


/* 
 * func : sm_multi_ip_clear  
 * Context :
 */
void sm_multi_ip_clear( void )
{
   	int i;
       
	for( i = 0; i < psPentanetspinfo.uiMipcount[g_index]; i++ ){
		psPentanetinfo.ulMipinfo[g_index][i] = 0;
		del_mmac(i);
	}	    
    	psPentanetspinfo.uiMipcount[g_index] = 0;
}
