#ifndef __COMMON_H
#define __COMMON_H
/* 
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) Hewlett-Packard (Paul Bame) paul_bame@hp.com
 */
#include <stdarg.h>
#include <asm/byteorder.h>
#include <linux/genhd.h>

#define PALOVERSION "1.5"

/* size of I/O block used in HP firmware */
#define FW_BLOCKSIZE	2048

#define GB	(1024 * 1024 * 1024)

/* assume kernel will always be loaded into the "lower" physical memory */
#define PHYS(virtual)	((virtual) & 0x00ffffff)

/* This struct is placed at the start of the boot loader executable.  The
 * "magic" number is the assembly-language branch needed to skip over the
 * rest of the structure.  This structure is manipulated by the program
 * which creates and updates boot media (palo).  It must stay 256 bytes
 * in length!
 *
 * kern_sz = 0 or rd_sz = 0 means no kern or ramdisk respectively.
 */
#define PALOMAGIC "PALO"
#define PALOHDRVERSION 4

#define PFLAG_INSTALL 0x1
#define PFLAG_EXT2    0x2

struct firstblock
{
    unsigned char lifmagic0;	/* 0x80 */
    unsigned char lifmagic1;	/* 0x00 */

    char palomagic[5];		/* PALO */
    unsigned char version;
    int      kern32_offset;	/* seek() here to begin loading kernel */
    int      kern32_sz;		/* # bytes to load */
    int      rd_offset;		/* seek() here to begin loading ramdisk */
    int      rd_sz;		/* # bytes in ramdisk */
    char cmdline[128];		/* Up to 127 bytes of text plus a \0 */

    unsigned char pad1[0xf0 - 8 - 7 * sizeof (int) - 128];
    unsigned int flags;
    int	     kern64_offset;
    int      kern64_sz;

    int ipl_addr;		/* offset 0xf0 */
    int ipl_size;
    int ipl_entry;

    /* offset 0x1be */
    unsigned char pad2[0x1be - (0xf0 + 3 * sizeof (int))];
    struct partition part[4];
    /* offset 0x1fe */
    unsigned char dosmagic[2];	/* 0x55, 0xaa */
    unsigned char pad4[2048 - 0x200];
};

/* we use this so that we can do without the ctype library */
#define is_digit(c)	((c) >= '0' && (c) <= '9')

struct diskpartition
{
    /* in honor of the MBR scheme, these are in 512-byte sectors */
    unsigned start;
    /* length == 0 means nothing's here */
    unsigned length;
    unsigned char id;
};

#define MAXPARTS 16

int seekread(int fd, char *buf, unsigned nbytes, unsigned devaddr);
#define STRUCTWRITE(f, data, where) seekwrite((f), (char *)&data, sizeof data, (where))
#define STRUCTREAD(f, data, where) seekread((f), (char *)&data, sizeof data, (where))

/* diskpart.c */
extern int is_extended(int id);
extern int load_partitions(int bootdev, struct diskpartition *mptab, int maxparts);
extern void print_ptab(struct diskpartition *mptab, int maxparts);
extern void print_ptab_pretty(struct diskpartition *mptab, int maxparts);

/* $Id: common.h,v 1.11 2001/06/13 05:08:55 bame Exp $ */
#endif /* __COMMON_H */
