/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos.wb;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.demos.wb.ApplFrame;
import org.javagroups.demos.wb.GraphPanel;
import org.javagroups.demos.wb.MessageDialog;
import org.javagroups.demos.wb.Node;
import org.javagroups.demos.wb.UserInfoDialog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Whiteboard
extends Applet
implements ActionListener,
MessageListener,
MembershipListener,
ComponentListener,
FocusListener {
    public RpcDispatcher disp;
    Channel channel;
    GraphPanel panel;
    private Button leave_button;
    private Label mbr_label;
    private final Font default_font;
    private String props;
    public final String groupname = "WbGrp";
    private boolean application;

    public void receive(Message m) {
    }

    public byte[] getState() {
        this.panel.saveState();
        return this.panel.getState();
    }

    public void setState(byte[] new_state) {
        this.panel.setState(new_state);
    }

    private final String getInfo() {
        StringBuffer ret = new StringBuffer();
        ret.append(" (" + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + ')');
        return ret.toString();
    }

    private final Frame findParent() {
        Container retval = this.getParent();
        while (retval != null) {
            if (retval instanceof Frame) {
                return (Frame)retval;
            }
            retval = retval.getParent();
        }
        return null;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.panel = new GraphPanel(this);
        this.panel.setBackground(Color.white);
        this.add("Center", this.panel);
        Panel p = new Panel();
        this.leave_button = new Button("Exit");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.mbr_label = new Label("1 mbr(s)");
        this.mbr_label.setFont(this.default_font);
        p.add("South", this.leave_button);
        p.add("South", this.mbr_label);
        this.add("South", p);
        if (!this.application) {
            this.props = this.getParameter("properties");
        }
        if (this.props == null) {
            this.props = "UDP:PING:FD:pbcast.PBCAST:UNICAST:FRAG:pbcast.GMS:pbcast.STATE_TRANSFER";
        }
        System.out.println("properties are " + this.props);
        try {
            this.channel = new JChannel(this.props);
            this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            this.channel.connect("WbGrp");
            System.out.println("INIT()");
            this.channel.getState(null, 0L);
        }
        catch (Exception e) {
            System.err.println("Whiteboard.init(): " + e);
        }
        this.panel.my_addr = this.channel.getLocalAddress();
        UserInfoDialog dlg = new UserInfoDialog(this.findParent());
        String n = dlg.getUserName();
        String info = this.getInfo();
        this.panel.start(n + info);
        this.addComponentListener(this);
        this.addFocusListener(this);
    }

    public void destroy() {
        if (this.disp != null) {
            try {
                this.disp.callRemoteMethods(null, "removeNode", this.panel.my_addr, 2, 0L);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            this.channel.close();
            this.disp = null;
            if (this.panel != null) {
                this.panel.stop();
                this.panel = null;
            }
        }
    }

    public void repaint() {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Exit")) {
            try {
                this.setVisible(false);
                this.destroy();
                if (this.application) {
                    ((Frame)this.getParent()).dispose();
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.out.println("Unknown action");
        }
    }

    public void viewAccepted(View v) {
        if (v != null && this.mbr_label != null) {
            this.mbr_label.setText(v.size() + " mbr(s)");
        }
        this.panel.adjustNodes(v.getMembers());
    }

    public void suspect(Address obj) {
    }

    public void block() {
    }

    public void moveNode(Node n) {
        this.panel.moveNode(n);
    }

    public void addNode(String lbl, Address addr, int xloc, int yloc) {
        this.panel.addNode(lbl, addr, xloc, yloc);
    }

    public void removeNode(Object addr) {
        this.panel.removeNode(addr);
    }

    public void displayMessage(String sender, String msg) {
        new MessageDialog(this.findParent(), sender, msg);
        this.panel.repaint();
    }

    public void componentResized(ComponentEvent e) {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void focusGained(FocusEvent e) {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public static void main(String[] args) {
        String props = null;
        int i = 0;
        while (i < args.length) {
            if (!args[i].equals("-props")) {
                Whiteboard.help();
                return;
            }
            props = args[++i];
            ++i;
        }
        Whiteboard wb = new Whiteboard(props);
        new ApplFrame("Whiteboard Application", wb);
    }

    static void help() {
        System.out.println("Whiteboard [-help] [-props <props>]");
    }

    private final /* synthetic */ void this() {
        this.default_font = new Font("Helvetica", 0, 12);
        this.props = null;
        this.groupname = "WbGrp";
        this.application = false;
    }

    public Whiteboard() {
        this.this();
    }

    public Whiteboard(String properties) {
        this.this();
        this.application = true;
        this.props = properties;
    }
}

