#!/usr/bin/wish -f
#
#
#   tkHelp. A simple Open Help App.
#
#   See OHA for ohlp description.
#
#   (C) 1999 Juan J. Martinez Siguenza (reidrac@rocketmail.com)
#   See GPL for distribution and usage details.
#
#   I used TK8.0 (try other previous versions of TK and let me
#   know if it works).
#


#
# title		-> title of help window
# helptext	-> ohlp text
#
proc openHelp {title helptext} {

  set w ".openHelpWin"

	if {[winfo exists $w]} {
  		destroy $w.text
	} else {
		toplevel $w
		  scrollbar $w.scroll -relief sunken -command "$w.text yview"

		  frame $w.f -relief raised -border 2
		  pack $w.f -side bottom -fill x 

		  button $w.f.close -text "Close" -command { destroy .openHelpWin }
		  button $w.f.about -text "OHlp" -command { aboutOpenHelp  }

		  pack $w.f.close -side left
		  pack $w.f.about -side right
		  pack $w.scroll -side right -fill y -padx 2 -pady 2
	}


  text $w.text -setgrid yes -wrap word \
    -width 55 -relief sunken -border 2 \
    -yscroll "$w.scroll set"

  pack $w.text -fill both -expand 1 -padx 5

  wm title $w "Help - $title"
  wm minsize $w 1 1

  outText $w.text $helptext
}


#
#  w 		-> text widget
#  ohlp         -> ohlp text
#
proc outText {w ohlp} {

   # normal
   $w configure -font -*-Helvetica-Medium-R-Normal-*-12-*
   # bold normal
   $w tag configure b -font -*-Helvetica-Bold-R-Normal-*-12-*
   set dtags(b) b
   # italic normal
   $w tag configure i -font -*-Helvetica-Medium-O-Normal-*-12-*
   set dtags(i) i
   # underline 
   $w tag configure u -underline 1
   set dtags(u) u
   # header 1
   $w tag configure h1 -font -*-Helvetica-Bold-R-Normal-*-24-*
   set dtags(h1) h1
   # header 2
   $w tag configure h2 -font -*-Helvetica-Bold-R-Normal-*-18-*
   set dtags(h2) h2
   # header 3
   $w tag configure h3 -font -*-Helvetica-Bold-R-Normal-*-14-*
   set dtags(h3) h3

   # justify left -default-
   # justify right
   $w tag configure right -justify right
   set dtags(right) right
   # justify center
   $w tag configure center -justify center
   set dtags(center) center

   # relief 1
   $w tag configure r1 -relief raised -border 1
   set dtags(r1) r1
   # relief 2
   $w tag configure r2 -relief raised -border 2
   set dtags(r2) r2
   # relief 3
   $w tag configure r3 -relief raised -border 3
   set dtags(r3) r3

   # color red
   $w tag configure fgr -foreground red
   set dtags(fgr) fgr
   # color blue
   $w tag configure fgb -foreground blue
   set dtags(fgb) fgb
   # color green
   $w tag configure fgg -foreground green
   set dtags(fgg) fgg
   # color white
   $w tag configure fgw -foreground white
   set dtags(fgw) fgw
   # color yellow
   $w tag configure fgy -foreground yellow
   set dtags(fgy) fgy
   # color black -default-
   $w configure -foreground black

   # bgcolor red
   $w tag configure bgr -background red
   set dtags(bgr) bgr
   # bgcolor blue
   $w tag configure bgb -background blue
   set dtags(bgb) bgb
   # bgcolor green
   $w tag configure bgg -background green
   set dtags(bgg) bgg
   # bgcolor yellow
   $w tag configure bgy -background yellow
   set dtags(bgy) bgy
   # bgcolor black
   $w tag configure bgk -background black
   set dtags(bgk) bgk
   # bgcolor white -default-
   $w configure -background white

   $w mark set insert 0.0

   # main loop
   set t $ohlp

   while {[regexp -indices {<([^@>]*)>} $t match inds] == 1} {
	set start [lindex $inds 0]
	set end [lindex $inds 1]
	set keyword [string range $t $start $end]

        set oldend [$w index end]

        if {[string range $keyword 0 0] != "/"} {
		# if is not a tag -> is a link
		if {[info exists dtags($keyword)] != 1} {
		   # links
   			set selected "$w tag configure \"$keyword\" -relief raise -border 1\
 			-background lightgrey"
   			set unselected "$w tag configure \"$keyword\" -relief flat -background white"
	   		$w tag configure "$keyword" -foreground blue -underline 1
 			$w tag bind "$keyword" <Button-1> $keyword
   			$w tag bind "$keyword" <Any-Enter> $selected
   			$w tag bind "$keyword" <Any-Leave> $unselected
			set dtags("$keyword") $keyword
		}
	}

        $w insert end [string range $t 0 [expr $start - 2]]

	quitTags $w $oldend insert

        if {[string range $keyword 0 0] == "/"} {
		set keyword [string trimleft $keyword "/"]
		if {[info exists tags($keyword)] == 0} {
			error "\nClose Tag Error: Tag not found\n"
		}
		$w tag add $keyword $tags($keyword) insert
		unset tags($keyword)
	} else {
		if {[info exists tags($keyword)] == 1} {
			error "\nOpen Tag Error: Tag found twice\n"
		}
		set tags($keyword) [$w index insert]
	}
	set t [string range $t [expr $end + 2] end]
   }
   set oldend [$w index end]
   $w insert end $t
   quitTags $w $oldend insert

   $w configure -state disabled
}

proc quitTags {w start end} {
	foreach tag [$w tag names $start] {
		w$ tag remove $tag $start $end
	}
}

proc aboutOpenHelp {} {

  openHelp "About OpenHelp" {

<h1><fgb>Open Help v1.1</fgb></h1>

Open help is a tiny <i>Tcl/Tk</i> script that makes easy to include help modules with links and rich format like text. It was developed using <b>Tk8.0</b> and was not tested with previous versions.


 <h3>Contents</h3>

      1.<ohlpInfo>Introduction to ohlp</ohlpInfo>
      2.<gplInfo>Distribution details</gplInfo>
      3.<contactInfo>Contacts and bugs</contactInfo>
      4.<futureInfo>Future versions</futureInfo>
 


 <fgr><h3>What's New on v1.1</h3></fgr>

  . Some bugs fixed
  . English traslation of <b>ohlp</b> help


}
}

proc ohlpInfo {} {

  openHelp "Introduction to ohlp" {

<h2><fgb>Introduction to ohlp</fgb></h2>

  <b>ohlp</b> works like <i>Html</i>. Uses <i>tags</i> and right slash <i>/</i> to set text properties. As in <i>Html</i>, the <i>tags</i> may be put between the symbols of <i>minor as</i> and <i>major as</i>.

  The <i>tags</i> supported under <fgb><b>Open Help v1.1</b></fgb> are:

         <u><i>tag</i></u>        <u><b>Description</b></u>

         <i>h1</i>        Big Header
         <i>h2</i>        Medium Header
         <i>h3</i>        Small Header

         <i>right</i>     Justify right
         <i>center</i>    Center Text

                     <u>Not compatible with  <i>h1 h2 h3</i></u>
         <i>b</i>          Bold Text
         <i>i</i>           Italic Text
         <i>u</i>          Underline Text

                     <u>Foreground Colors</u>
         <i>fgb</i>       Blue
         <i>fgr</i>        Red
         <i>fgg</i>       Green
         <i>fgy</i>       Yellow
         <i>fgw</i>       White

                     <u>Background Colors</u>
         <i>bgb</i>       Blue
         <i>bgr</i>        Red
         <i>bgg</i>       Green
         <i>bgy</i>       Yellow
         <i>bgk</i>       Black

         <i>r1</i>         Big Raised
         <i>r2</i>         Medium Raised
         <i>r3</i>         Small Raised


  Links are <i>tags</i> not defined by <b><fgb>Open Help</fgb></b>. If you put as <i>tag</i> the word <i>openInfo</i>, it is suposed to be a link and <b><fgb>Open Help</fgb></b> calls the <i>Tcl/Tk</i> script with that name.

  It's important remember than the close <i>tag</i> must be equal to open <i>tag</i> -with the slash <i>/</i>, of course-. Afterall you can combine some <i>tags</i> to get a lot of different text output.

  See <i>example.ohlp</i> that comes with <b><fgb>Open Help</fgb></b> for more details.


<aboutOpenHelp>Contents</aboutOpenHelp>

}
}

proc gplInfo {} {

  openHelp "Distribution Details" {

<h2><fgb>Distribution Details</fgb></h2>

  <b><fgb>Open Help v1.0</fgb></b> uses <b>GPL</b> terms in distribution.  Moreover i thanx you send a <i>mail</i> to the <contactInfo>author</contactInfo> with comments about <b>ohlp</b>.

Copyright (C)1999 Juan J. Martinez.

This program is free software; you may redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2, or (at your option) any later version.

This is distributed in the hope that it will be useful, but without any warranty; without even the implied warranty of merchantability or fitness for a particular purpose. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License with your copy of Open Help. If not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.



<aboutOpenHelp>Contents</aboutOpenHelp>

}
}

proc contactInfo {} {

  openHelp "Contacts and Bugs" {

<h2><fgb>Contacts and Bugs</fgb></h2>

  <b><fgb>Open Help</fgb></b> can have bugs -i hope this-. If you find a important bug, please send me a <i>mail</i> and i'll look what to do. Send me your comments, too.  
  
  I am here :
  <i><fgr>reidrac@rocketmail.com</fgr></i>

  Or traditional mail:

    <i>Juan Jose Martinez Siguenza</i>

   <i>C/ Fda. Sta. Maria 67 4p 4pl 
   03204 Elche (Alicante) SPAIN</i>

  I need work. Please, let me know if you are working in a project and want some help.

   <i>Elche, 16 de Febrero de 1999</i> 


 <i>Note: My english SUCKS. Sorry!</i>


<aboutOpenHelp>Contents</aboutOpenHelp>

}
}

proc futureInfo {} {

  openHelp "Future Versions" {

<h2><fgb>Future Versions</fgb></h2>

  I'm not soure to release another version of <b>ohlp</b>. This release is only for translate the help into english. The previous version have some little bugs -sure that you can fix it-, but is in spanish. You know: <i>Si eres de habla hispana, la version anterior te puede interesar</i>.

  If someone want to improve this script i would like to have a copy of the modified script. Thanx.

  Some thigs TODO:

    . Add back button -links with history-
    . Add some pretty bitmaps to the buttons and tips -so easy-
    . Add a search option
    . Add GIF support -too difficult?-


<aboutOpenHelp>Contents</aboutOpenHelp>

}
}

proc error { text } {

  destroy if exists .error

  toplevel .error

  frame .error.f0 -relief raised -border 2
  pack .error.f0 -side top -fill both -expand yes

  label .error.f0.mess -text $text
  pack .error.f0.mess

  frame .error.f1 -relief groove -border 2
  pack .error.f1 -side top -fill both -expand yes

  button .error.f1.ok -text Ok -command { destroy .error }
  pack .error.f1.ok

  wm title .error "Help Error"
}

