/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

#ifndef  INCL_HFSC_REQ
#define  INCL_HFSC_REQ

#ifdef __cplusplus
extern "C" {
#endif

/*
#define REQ_DEBUG
*/
#define INACTIVE    0
#define IN_CALENDAR 1
#define IN_HEAP     2

/* 
 *  request data structure; each request is characterized by two keyes
 *  e and d. In the case of a guaranteed request, e represents the 
 *  eligible time, while d represents the deadline. In the case of
 *  a fair request d represents the virtual time (e has no meaning in this
 *  case).
 */

typedef struct _req {
  unsigned int         e;        /* eligible key (time) */
  unsigned int         d;        /* deadline key (time) */
#ifdef REQ_DEBUG
  unsigned int         status;
#endif
  void        *pClass;
  int          idx;      /* request's index in the heap */
  struct _req *next;
  struct _req *prev;
} ReqItem;  


#define INSERT_REQ(pHead, pReq) {\
  pReq->next = pReq->prev = NULL; \
  if (!pHead) { \
    pHead = pReq; \
  } else { \
    pReq->next = (pHead); \
    (pHead) = pReq; \
    pReq->next->prev = pReq; \
  } \
}    

#define INSERT_REQ1(pHead, pReq) {\
  if (!pHead) { \
    pHead = pReq; \
  } else { \
    ReqItem *req; \
    if ((pHead)->d > pReq->d) { \
      pReq->next = (pHead); \
      (pHead) = pReq; \
      pReq->next->prev = pReq; \
    } else { \
      for (req = (pHead); req->next && req->next->d < pReq->d; req=req->next);\
      pReq->next = req->next; \
      pReq->prev = req; \
      req->next = pReq; \
      if (pReq->next) pReq->next->prev = pReq; \
    } \
  } \
}    

#define REMOVE_FIRST_REQ(pHead, pReq) {\
  pReq = pHead;\
  if (pHead) {\
    pHead = (pHead)->next;\
    if (pHead) \
      (pHead)->prev = NULL;\
  }\
  if (pReq) pReq->next = NULL; \
}    


#define REMOVE_REQ(pHead, pReq) {\
  if (pReq->prev) \
    pReq->prev->next = pReq->next; \
  else \
    pHead = pReq->next; \
  if (pReq->next) \
    pReq->next->prev = pReq->prev; \
  if (pReq) pReq->next = pReq->prev = NULL; \
}

#ifdef __cplusplus
}
#endif

#endif
