/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

#ifndef lint
static const char sccsID[] = "Revision: @(#)misc.c	1.4        8/24/93     Hui Zhang";
#endif
#include "consts.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "consts.h"

int hfsc_panic(string)
    char *string;
{
    fprintf(stderr, "%s\n", string);
    exit(-1);
}


char *smalloc(bytes)
unsigned bytes;
{
    char *addr;
    
    if (!(addr = (char *) malloc(bytes)))
        hfsc_panic("smalloc");
    return(addr);
}

#ifdef STOICA_SIM
static u_short freeHint = RESERVE_RTIPCB;
u_int NewRtCid()
{
    u_short i;
    for (i = freeHint; i< MAX_RTIPCBS-1; i++)
	if (RtipPcbTable[i] == NULL) {
	    freeHint = i+1;
	    return(i);
	}
    if (RtipPcbTable[MAX_RTIPCBS-1]) {
	freeHint = RESERVE_RTIPCB;
	return((u_short)(MAX_RTIPCBS-1));
    }
    for (i = RESERVE_RTIPCB; i<freeHint; i++)
	if (RtipPcbTable[i] == NULL) {
	    freeHint = i+1;
	    return(i);
	}
    return(0);
}

static u_short channelFreeHint = RESERVE_CHANNEL;
u_int NewChannelId()
{
    u_short i;
    for (i = channelFreeHint; i< MAX_CHANNEL-1; i++)
	if (Channel[i] == NULL) {
	    channelFreeHint = i+1;
	    return(i);
	}
    if (Channel[MAX_CHANNEL-1]) {
	channelFreeHint = RESERVE_CHANNEL;
	return((u_short)(MAX_CHANNEL-1));
    }
    for (i = RESERVE_CHANNEL; i<channelFreeHint; i++)
	if (Channel[i] == NULL) {
	    channelFreeHint = i+1;
	    return(i);
	}
    return(0);
}
#endif
