# ui-visualframe.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vic/ui-visualframe.tcl,v 1.7 2002/02/03 04:39:55 lim Exp $


import ErrorWindow Configuration

#
# This is a tk frame that offers some methods for initializing the
# visual and colormap and selecting dithering algorithms.
#
Class VisualFrame -superclass Observable -configuration {
	dither Dither
	gamma 0.7
}

#
# Look through the list of available visuals, and choose
# the best one that vic supports.
#
VisualFrame instproc lookup_visual {} {
	set vlist [winfo visualsavailable .]
	if { [lsearch -exact $vlist "truecolor 24"] >= 0 || \
		 [lsearch -exact $vlist "truecolor 32"] >= 0 } {
		set visual "truecolor 24"
	} elseif { [lsearch -exact $vlist "truecolor 16"] >= 0 } {
		set visual "truecolor 16"
	} elseif { [lsearch -exact $vlist "pseudocolor 8"] >= 0 } {
		set visual "pseudocolor 8"
	} elseif { [lsearch -exact $vlist "staticgray 1"] >= 0 } {
		set visual "staticgray 1"
	} else {
		puts stderr "[$self get_option appname]: no support for your display type {$vlist}"
		exit 1
	}
}

#
# Initialize the visual, colormap, and dither global variables
# based on  X resources, available visuals, etc.  Create the
# specified window as a frame widget and set its visual.  We pick
# the visual only once and startup -- the user cannot change it
# interactively.  But the user can change the dithering algorithms
# interactively constrained to the selected visual
# Sets the colormap global variable to <i>w</i> since this window
# will always have the reference colormap.
#
VisualFrame instproc init {w} {
	global V

	$self instvar gamma_ dither_

	Application set colormap_ $w
	set dither [$self get_option dither]
	if { $dither == "best" } {
		set dither ED
	}
	if { $dither == "dither" } {
		set dither Dither
	}
	if { $dither == "gray" } {
		set dither Gray
	}
	if { $dither == "quantize" } {
		set dither Quant
	}
	set gamma_ [$self get_option gamma]
	if { [lsearch -exact "Dither ED Gray Quant" $dither] < 0 } {
		#FIXME
		puts stderr "[$self get_option appname]: unknown dither: $dither"
		exit 1
	}
	set visual [$self get_option visual]
	if { $visual == "" } {
		set visual [$self lookup_visual]
	} elseif { $visual == "pseudocolor" } {
		set visual "pseudocolor 8"
	}
	set cmap ""
	if [$self yesno privateColormap] {
		set cmap "-colormap new"
	}
	if [catch "frame $w -visual {$visual} $cmap"] {
		$self fatal "bad visual: $visual"
	}
	if { [winfo depth $w] == 8 } {
		set dither_ $dither
	} else {
		set dither_ ""
	}
	Application set visual_ $visual

	if ![$self init_color] {
		if { [winfo depth $w] != 8 } {
			puts stderr "[$self get_option appname]: internal error: no colors"
			exit 2
		}
		puts stderr \
		    "[$self get_option appname]: warning: ran out of colors; using private colormap"
		destroy $w
		frame $w -visual [Application set visual_] -colormap new
		if ![$self init_color] {
			puts stderr "[$self get_option appname]: internal error: no colors"
			exit 2
		}
	}
}

#FIXME
set vmap(truecolor) TrueColor
set vmap(pseudocolor) PseudoColor

#
# Initialize the colormodel based on the visual, dither, and colormap
# global variables.  If we run out of colors, free the colormodel
# and return false (leaving it up to the caller to fix things);
# otherwise, return true.  Set the global variable colorModel
# to the corresponding tcl object.
#
VisualFrame instproc init_color {} {
	#FIXME
	global vmap

	$self instvar dither_ gamma_ colorModel_
	if [info exists colorModel_] {
		delete $colorModel_
		unset colorModel_
	}
	set colormap [Application set colormap_]
	set v [winfo visual $colormap]
	set v $vmap($v)
	set d [winfo depth $colormap]
	if { $d == 8 } {
		set id $v/$d/$dither_
	} else {
		set id $v/$d
	}
	if { $id == "TrueColor/32" } {
		set id TrueColor/24
	}
	set cm [new Colormodel/$id]
	if { $cm == "" } {
		puts stderr "[$self get_option appname]: unsupported visual type: $v"
		exit 1
	}
	$cm visual $colormap
	$cm gamma $gamma_
	#FIXME revert to gray?
	if ![$cm alloc-colors] {
		delete $cm
		return 0
	}
	set colorModel_ $cm
	return 1
}

#
# Set the dither to gray.
#
VisualFrame instproc revert_to_gray {} {
	$self instvar dither_
	if { $dither_ == "Gray" } {
		#FIXME
		puts stderr "[$self get_option appname]: out of colors"
		exit 1
	}
	new ErrorWindow "ran out of colors; reverting to gray"
	$self set_dither Gray
}

#
# Set the dither to <i>d</i>, initialize the colormodel, and reallocate all renderers.
#
VisualFrame instproc set-dither {d} {
	$self instvar dither_
	set dither_ $d
	if ![$self init_color] {
		$self revert_to_gray
	}
	# FIXME crufty way to reallocate all renderers
	$self notify_observers trigger_format_all
}

#
VisualFrame instproc set-gamma {s} {
	$self instvar colorModel_ gamma_
	global win_src
	set cm $colorModel_
	if ![$cm gamma $s] {
		return -1
	}
	set gamma_ $s
	$cm free-colors
	if ![$cm alloc-colors] {
		$self revert_to_gray
	}
	#
	# Need to update all the windows.  Can't just do a redraw
	# on all the windows because that won't cause the renderer's
	# to update their copy of the image (which has the old colormap
	# installed).  Instead, go through all the active decoders and
	# force them to update all the windows.
	#
	foreach src [session active] {
		set d [$src handler]
		if { $d != "" } {
			$d redraw
		}
	}

	return 0
}

