# ui-videobox.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vic/ui-videobox.tcl,v 1.10 2002/02/03 04:39:55 lim Exp $


import ActiveSource WidgetClass

#vbx which attribs are required

#
# VideoBox is a configurable widget that is, in its basic form,
# a frame for displaying the VideoWidget of an ActiveSource.
# <p>
# As with all tk widgets, the first argument to the <i>VideoBox</i> command is the widget name.
# <p>
# The available attributes are as follows... <br>
# <table>
#            <tr><td>   -attachSource <i>src</i>       </td><td>identify the source to be displayed by the VideoWidget
#  </td></tr><tr><td>   -size <i>size</i>              </td><td>set the size of the VideoWidget: thumbnail/small/medium/large
#  </td></tr><tr><td>   -updateSpeed <i>speed</i>      </td><td>set the speed with which the videowidget is updated: slow/normal
#  </td></tr><tr><td>   -cb <i>coordBus</i>            </td><td>identify the coordination-bus
#  </td></tr><tr><td>   -switchMode <i>mode</i>        </td><td>startup a switching mode: voice/timer/voice&timer
#  </td></tr><tr><td>   -switchTimer <i>timeout</i>    </td><td>set the cycle-time for sources in this VideoBox (applicable only if timer-switched)
#  </td></tr><tr><td>   -switchSet <i>set</i>          </td><td>identify a set of ActiveSources through which the VideoWindow should cycle
#  </td></tr><tr><td>   -outputMeter <i>bool</i>       </td><td>display an output meter for the source being displayed: true/false
#  </td></tr><tr><td>   -cameraCtrls <i>bool</i>       </td><td>display camera control for the source being displayed if available: true/false
#  </td></tr><tr><td>   -border <i>bool</i>            </td><td>display a border around the video window: true/false
#  </td></tr><tr><td>   -nametag <i>bool</i>           </td><td>display a nametag for the source being displayed if available: true/false
#  </td></tr><tr><td>   -ui <i>userInterface</i>       </td><td>ui identifies the user-interface by which this VideoBox is being displayed
#  </td></tr>
# </table>
# <p>
# To query the value of an attribute, use the get_attribute method. <br>
#    (ex:   $vidbox get_attribute -size)
#
WidgetClass VideoBox -configspec {
	{ -attachSource attachSource AttachSource {} attach_source get_attribute }
	{ -size size Size medium set_size get_attribute }
	{ -updateSpeed updateSpeed UpdateSpeed normal set_speed get_attribute }
	{ -cb cb CB {} set_cb get_attribute }
	{ -switchMode switchMode SwitchMode voice&timer set_switchMode get_attribute }
	{ -switchTimer switchTimer SwitchTimer 15 set_switchTimer get_attribute }
	{ -switchSet switchSet SwitchSet {} define_switchSet get_attribute }
	{ -outputMeter outputMeter OutputMeter false set_outputMeter get_attribute }
	{ -cameraCtrls cameraCtrls CameraCtrls false set_cameraCtrls get_attribute }
	{ -border border Border true set_border get_attribute }
	{ -nametag nametag Nametag true set_nametag get_attribute }
	{ -ui ui UI {} set_ui get_attribute }
} -default {
} -alias {
	{ -src -attachSource }
}

#
# Returns the default setting of an attribute.
# ex: $vidbox get_default_attr -size
#
VideoBox public get_default_attr { attributes } {
	$self instvar tkWidgetName_

	foreach attribute $attributes {
		regsub {\-} $attribute ""  attributename
		regsub {(.*)} $attributename &_ instvariable
		$self instvar $instvariable

		# yatin says this is how to get default values before build widget
		# ex:  set border_ [option get $tkWidgetName border [$self info class]]

		set $instvariable [option get $tkWidgetName_ $attributename [$self info class]]

		# set value [option get $tkWidgetName_ $attribute [$self info class]]
		# puts "set $instvariable $value"
	}
}

#
VideoBox private build_widget { tkWidgetName } {
	$self instvar tkWidgetName_
	set tkWidgetName_ $tkWidgetName

	$self get_default_attr { -border -as -size -nametag }
	$self set_dimensions

	$self instvar vw_ vbox_ width_ height_ vwPath_
	set vbox_ [frame $tkWidgetName.vbox -relief ridge -borderwidth 2]
	set vwPath_ $vbox_.vw
	set vw_ [new VideoWidget $vwPath_ $width_ $height_]
	pack $vbox_.vw -anchor c
	pack $vbox_ -fill none -expand 0

	#$self set_label_text "Waiting for a source to fill this VideoBox"
	$self set_label_text "Waiting for video"

	#vbx
	$self instvar isEmpty_
	set isEmpty_ 1
	$self unset_manager_switched
}

#
# If this VideoBox is managed by a VideoBoxManager, default switching policies will be instated.
#
VideoBox public set_manager_switched { } {
	$self instvar isManagerSwitched_
	set isManagerSwitched_ 1
}

#
# If this VideoBox is managed by a VideoBoxManager, default switching policies will be un-instated.
#
VideoBox public unset_manager_switched { } {
	$self instvar isManagerSwitched_
	set isManagerSwitched_ 0
}

#
# Accessor function to determine whether or not default switching
# policies are instated on this VideoBox (which only constitutes
# useful data if this VideoBox is managed by a VideoBoxManager.)
#
VideoBox public is_manager_switched { } {
	$self instvar isManagerSwitched_
	return $isManagerSwitched_
}

#
# Return the VideoWidget being displayed in this VideoBox.
#
VideoBox public get_video_widget {} {
	$self instvar vw_
	return [$self set vw_]
}

#
# Return the widget-path of the VideoWidget being displayed in this VideoBox.
#
VideoBox public get_video_widget_path {} {
	return [$self set vwPath_]
}

#
VideoBox private set_attribute { option value } {
	regsub {\-} $option ""  optionname
	regsub {(.*)} $optionname &_ instvariable
	$self instvar $instvariable

	set $instvariable $value

	#vbx
	puts "set_attribute: set $instvariable $value"
}

#
# Returns the value of the specified option.
# This method should only be used by options that set their value to the instvar by the same name.
# ex: $self get_attribute -size can return the value of the -size attribute because it
# can be found in the instvar size_
#
VideoBox public get_attribute { option } {
	regsub {\-} $option ""  optionname
	regsub {(.*)} $optionname &_ instvariable
	$self instvar $instvariable

	set val [$self set $instvariable]
	#vbx
	puts "get_attribute $option        returns $val"

	return [$self set $instvariable]
}

#
VideoBox private attach_source { option src } {
	if { $src != {} } {
		$self switch $src
#vbx		puts "$self switching to src = $src"
	}
}

#
VideoBox private set_size { option size } {
	$self instvar size_
	set size_ $size

	$self set_dimensions
	$self resize
}

#
VideoBox private set_dimensions {} {
	$self instvar size_ width_ height_ border_

	if { $border_ } {
		switch -- $size_ {
			"thumbnail" {
				set width_ 80
				set height_ 60
			}
			"small" {
				# QCIF
				set width_ 176
				set height_ 144
			}
			"medium" {
				# CIF
				set width_ 352
				set height_ 288
			}
			"large" {
				# SCIF
				set width_ 704
				set height_ 576
			}
			default {
				set width_ 80
				set height_ 60
			}
			"thumbnail" {
				set width_ 80
				set height_ 60
			}
			"small" {
				# 1/16 NTSC
				set width_ 160
				set height_ 120
			}
			"medium" {
				# 1/4 NTSC
				set width_ 320
				set height_ 240
			}
			"large" {
				# NTSC
				set width_ 640
				set height_ 480
			}
			default {
				set width_ 80
				set height_ 60
			}
		}
	} else {
		switch -- $size_ {
			"thumbnail" {
				set width_ 80
				set height_ 60
			}
			"small" {
				# 1/16 NTSC
				set width_ 160
				set height_ 120
			}
			"medium" {
				# 1/4 NTSC
				set width_ 320
				set height_ 240
			}
			"large" {
				# NTSC
				set width_ 640
				set height_ 480
			}
			default {
				set width_ 80
				set height_ 60
			}
		}
	}
}

#
# resize a videobox
#
VideoBox private resize { } {
	$self instvar width_ height_ vw_ as_

	if { $as_ != {} } {
		$as_ detach_videobox $self
	}

	[$vw_ window] resize $width_ $height_

	if { $as_ != {} } {
		#
		# Force an update so the window gets mapped at
		# the new size before we re-bind the window
		# to the source.
		#
		update idletasks
#vbx
		puts "RE-ATTACHING VB"
		$as_ attach_videobox $self
	}

	$self update_label
}

#
VideoBox private set_cb { option cb } {
	$self instvar cb_
	set cb_ $cb
}

#
VideoBox private set_switchMode { option mode } {
	# voice timer voice&timer
	$self instvar switchMode_
	set switchMode_ $mode
}

#
VideoBox private set_switchTimer { option timeout } {
	$self instvar switchTimer_
	set switchTimer_ $timeout
}

#
VideoBox private define_switchSet { option switchset } {
	$self instvar switchSet_
	set switchSet_ $switchset
}

#
# if audio is available for $src_, optionally show/hide output meter
#
VideoBox private set_outputMeter { option bool } {
	# true (1) or false (0)
	$self instvar outputMeter_
	set outputMeter_ $bool
}

#
# if camera_ctrls are available for $src_, optionally show/hide them
#
VideoBox private set_cameraCtrls { option bool } {
	# true (1) or false (0)
	$self instvar cameraCtrls_
	set cameraCtrls_ $bool
}

#
VideoBox private set_speed { option speed } {
	# slow or normal
	$self instvar updateSpeed_ vw_
	set updateSpeed_ $speed

	if { $updateSpeed_ == "slow" } {
		$vw_ set_slow
	} else {
		$vw_ set_normal
	}
}

#
VideoBox private set_border { option bool } {
	# true (1) or false (0)
	$self instvar border_ size_
	set border_ $bool

	$self set_dimensions
	$self resize
}

#
VideoBox private set_ui { option ui } {
	$self instvar ui_
	set ui_ $ui
}

#
VideoBox private set_nametag { option bool } {
	# true (1) or false (0)
	$self instvar nametag_
	set nametag_ $bool

	$self update_label
}

#
VideoBox private set_label_text { label_text } {
	$self instvar vbox_ vbox_label_

	if { ![winfo exists $vbox_.label] } {
		set vbox_label_ [label $vbox_.label]
	}

	$vbox_label_ config -text $label_text
	$self update_label
}

#
VideoBox private set_label_textvariable { label_textvariable } {
	$self instvar vbox_ vbox_label_

	if { ![winfo exists $vbox_.label] } {
		set vbox_label_ [label $vbox_.label]
	}

	$vbox_label_ config -textvariable $label_textvariable
	$self update_label
}

#
VideoBox private update_label {} {
	$self instvar nametag_ vbox_ vbox_label_ vbox_label_frame_ width_

	if { ![winfo exists $vbox_.label] } {
		set vbox_label_ [label $vbox_.label]
	}

	if { ![winfo exists $vbox_.label_frame] } {
		set vbox_label_frame_ [frame $vbox_.label_frame]
	}

	$vbox_label_ config -font [$self get_option medfont] -pady 1 -borderwidth 0 -anchor w
#	-background yellow

	$vbox_label_frame_ config -width $width_ -height 15

	if { $nametag_ } {
		pack $vbox_label_ -anchor c -expand 0 -side top -fill none -in $vbox_label_frame_
		pack $vbox_label_frame_ -anchor c -expand 0 -side top -fill none
		raise $vbox_label_
		pack propagate $vbox_label_frame_ 0
	} else {
		pack forget $vbox_label_
		pack forget $vbox_label_frame_
	}
}

#
VideoBox public highlight_border { } {
}

#
VideoBox public unhighlight_border { } {
}

#
VideoBox public highlight_nametag { } {
}

#
VideoBox public unhighlight_nametag { } {
}

#
VideoBox public start_border_blinking { } {
}

#
VideoBox public stop_border_blinking { } {
}

#
VideoBox public start_nametag_blinking { } {
}

#
VideoBox public stop_nametag_blinking { } {
}

#
# Display Source <i>src</i>.
#
VideoBox public switch { src } {
	$self instvar as_ ui_ src_ isEmpty_

	set src_ $src

	#FIXME map src to active source using UI's data structure
	set as [[$ui_ set asm_] get_activesource $src]

	if { $as_ != $as } {
		if { $as_ != {} } {
			$as_ detach_videobox $self
		}
		set as_ $as
		$as_ attach_videobox $self
		$self set_label_textvariable src_nickname($src_)
		set isEmpty_ 0
	}

	# in this method, probably where to reattach output meter, camctrls, to new src

	$self instvar sequenceStamp_
	set sequenceStamp_ [VideoBox incr_sequence_counter]
}

#
# Increments a counter and returns this as a sequence number that is
# unique and higher than that returned to any existing VideoBox at
# any previous time during program execution.
# (A single sequence number space is shared among ALL VideoBoxes.)
#
VideoBox proc incr_sequence_counter {} {
	$self instvar seqCounter_

	if {![info exist seqCounter_]} {
		set seqCounter_ 0
	} else {
		incr seqCounter_
	}

	return $seqCounter_
}

#
# Accessor function to return the sequence stamp of this VideoBox.  The
# higher the sequence number, then the more recently this VideoBox has
# performed a "switch".
# (A single sequence number space is shared among ALL VideoBoxes.)
#
VideoBox public get_sequence_stamp {} {
	$self instvar sequenceStamp_

	if {![info exist sequenceStamp_]} {
		return 0
	} else {
		return $sequenceStamp_
	}
}

#
# Returns 0 if this VideoBox is displaying a Source.  Otherwise, returns 1.
#
VideoBox public is_empty {} {
#vbx
	$self instvar isEmpty_
	return $isEmpty_
}

#
# If this VideoBox is displaying a Source, return it.  Otherwise return nothing.
#
VideoBox public get_src_displayed {} {
#vbx
	if {[$self is_empty]} {
		return
	} else {
		$self instvar src_
		return $src_
	}
}


VideoBox public get_activesource {} {
	return [$self set as_]
}

