# ui-grabber.tcl --
#
#       This file contains stubs for building any grabber specific controls.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
# This file contains stubs for building any grabber specific controls.
# If a device is named foo, then create define build.foo proc here
# that builds UI.  If this proc doesn't exist, then it will be ommitted.
# If there are multiple devices with the same name, they should be
# called foo-1, foo-2, etc. and you'll only need build.foo
#

#
ControlMenu instproc build.lml33 { w } {
#	puts "build.lml33 START"
	$self instvar vpipe_
#	puts "trying to extract device"
#	set dev [$vpipe_ set device_]
#	puts "trying to use puts"
#	puts [$dev info procs]
#	puts [$dev info class]
#	puts [$dev info commands]
#	set clas [$dev info class]
#	puts "class instprocs: "
#	puts [$clas info instprocs]
#	puts "heritage:"
#	puts [$clas info heritage]
#	puts "nickname:"
#	puts [$dev nickname]
#	puts "attributes:"
#	puts [$dev attributes]
#	puts {hue: }
#	puts [$dev get_attribute hue]
#	puts {contrast: }
#	puts [$dev contrast]
#	puts {color: }
#	puts [$dev color]
#	puts "build.lml33 END"

	set f [$self get_option smallfont]
	label $w.title -text "Video Input"
	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.ll -relief flat

	label $w.f.ll.clabel -font $f -text "Contrast" -anchor s

	label $w.f.ll.blabel -font $f -text "Brightness" -anchor s
	pack  $w.f.ll.clabel $w.f.ll.blabel \
			     -side left -fill x -expand 1

	frame $w.f.l  -relief flat

	scale $w.f.l.cscale   -orient horizontal -width 12 -relief groove \
                              -showvalue 0 -from 0 -to 65500 \
                              -command "$vpipe_ hardware contrast"

	scale $w.f.l.bscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 65500 \
                            -command "$vpipe_ hardware brightness"
	pack  $w.f.l.cscale $w.f.l.bscale  -side left -fill x -expand 1

	frame $w.f.cl  -relief flat

	label $w.f.cl.glabel -font $f -text "Hue" -anchor n

	label $w.f.cl.slabel -font $f -text "Color" -anchor n
	pack  $w.f.cl.glabel $w.f.cl.slabel \
			     -side left -fill x -expand 1

	frame $w.f.c -relief flat

	scale $w.f.c.hscale -orient horizontal -width 12 -relief groove \
                             -showvalue 0 -from 0 -to 65500 \
                             -command "$vpipe_ hardware hue"

	scale $w.f.c.cscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 65500 \
                            -command "$vpipe_ hardware color"
	pack  $w.f.c.hscale $w.f.c.cscale -side left -fill x -expand 1

	pack  $w.f.ll $w.f.l $w.f.c $w.f.cl \
	      -fill x -expand 1 -padx 1m


	pack $w.title $w.f -fill x -expand 1

	$w.f.l.cscale set 27648
	$w.f.l.bscale set 32768
	$w.f.c.hscale set 32768
	$w.f.c.cscale set 32512

#       if [have grabber] {
#$vpipe_ hardware
#               $w.f.l.cscale set [$vt grabber -contrast]
#               $w.f.l.bscale set [$vt grabber -brightness]
#               $w.f.c.hscale set [$vt grabber -hue]
#               $w.f.c.cscale set [$vt grabber -color]
#       } else {
#       }

}

ControlMenu instproc build.slicvideo { w } {
	$self instvar vpipe_
	set f [$self get_option smallfont]
	label $w.title -text "Video Input"
	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.h -relief flat

	label $w.f.h.label  -font $f -anchor e -text "Hue"

	scale $w.f.h.scale -orient horizontal -width 12 -length 20 \
		           -relief groove -showvalue 0 -from -128 -to 127 \
                          -command "$vpipe_ hardware set HUE"
	pack  $w.f.h.label $w.f.h.scale -side left -fill x -expand 1

	frame $w.f.ll -relief flat

	label $w.f.ll.label  -font $f -text "Luma" -anchor s

	label $w.f.ll.clabel -font $f -text "Contrast" -anchor s

	label $w.f.ll.blabel -font $f -text "Brightness" -anchor s
	pack  $w.f.ll.clabel $w.f.ll.label $w.f.ll.blabel \
			     -side left -fill x -expand 1

	frame $w.f.l  -relief flat

	scale $w.f.l.cscale   -orient horizontal -width 12 -relief groove \
                              -showvalue 0 -from 0 -to 127 \
                              -command "$vpipe_ hardware set LUMA_CONTRAST"

	scale $w.f.l.bscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 255 \
                            -command "$vpipe_ hardware set LUMA_BRIGHTNESS"
	pack  $w.f.l.cscale $w.f.l.bscale  -side left -fill x -expand 1

	frame $w.f.cl  -relief flat

	label $w.f.cl.label  -font $f -text "Chroma" -anchor n

	label $w.f.cl.glabel -font $f -text "Gain" -anchor n

	label $w.f.cl.slabel -font $f -text "Saturation" -anchor n
	pack  $w.f.cl.glabel $w.f.cl.label $w.f.cl.slabel \
			     -side left -fill x -expand 1

	frame $w.f.c -relief flat

	scale $w.f.c.gscale -orient horizontal -width 12 -relief groove \
                             -showvalue 0 -from 0 -to 255 \
                             -command "$vpipe_ hardware set CHROMA_GAIN"

	scale $w.f.c.sscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 127 \
                            -command "$vpipe_ hardware set CHROMA_SATURATION"
	pack  $w.f.c.gscale $w.f.c.sscale -side left -fill x -expand 1


	pack  $w.f.h $w.f.ll $w.f.l $w.f.c $w.f.cl \
	      -fill x -expand 1 -padx 1m


	pack $w.title $w.f -fill x -expand 1

	$w.f.h.scale  set 0
	$w.f.l.cscale set 64
	$w.f.l.bscale set 128
	$w.f.c.gscale set 44
	$w.f.c.sscale set 64
}

#
ControlMenu instproc build.still { w } {

    set f [$self get_option smallfont]
    label $w.title -text "Video Input"

    frame $w.f -relief sunken -borderwidth 2

    label $w.f.label  -font $f -anchor e -text "File"

    mk.entry $w.f set.still.frame "frame"

    pack $w.title $w.f -fill x -expand 1

    pack $w.f.label -side left
    pack $w.f.entry -side left -fill x -expand 1
}

#
ControlMenu instproc set.still.frame {w s } {
    global lastDevice
    $lastDevice file $s
}

#
ControlMenu instproc build.qcam { w } {
    $self instvar vpipe_
    global qcamwindow

    set f [$self get_option smallfont]
    label $w.title -text "Video Input"

    frame $w.f -relief sunken -borderwidth 2

    frame $w.f.s -relief flat

    frame $w.f.s.l -relief flat
    label $w.f.s.l.bright -font $f -anchor w -text "Brightness"
    label $w.f.s.l.cont   -font $f -anchor w -text "Contrast"
    label $w.f.s.l.wbal   -font $f -anchor w -text "White balance"
    pack  $w.f.s.l.bright $w.f.s.l.cont $w.f.s.l.wbal \
	-side top -fill x -expand 1

    frame $w.f.s.s -relief flat
    scale $w.f.s.s.bright -orient horizontal -width 12 \
		          -relief groove -showvalue 0 -from 1 -to 254 \
                          -command "$vpipe_ hardware set BRIGHT"
    scale $w.f.s.s.cont   -orient horizontal -width 12 \
                          -relief groove -showvalue 0 \
                          -from 0 -to 1.0 -resolution 0.002 \
                          -command "$vpipe_ hardware contrast"

    frame $w.f.s.s.wbal -relief flat
    scale $w.f.s.s.wbal.scale  -orient horizontal -width 12 \
                             -relief groove -showvalue 0 -from 1 -to 254 \
                             -command "$vpipe_ hardware set WBAL"
    button $w.f.s.s.wbal.button -font $f -text Auto \
	-command "$vpipe_ hardware set WBAL auto"
    pack  $w.f.s.s.wbal.scale $w.f.s.s.wbal.button \
	-side left -fill x -expand 1

    pack $w.f.s.s.bright $w.f.s.s.cont $w.f.s.s.wbal \
        -side top -fill x -expand 1

    pack $w.f.s.l $w.f.s.s -side left -fill x -expand 1

    frame $w.f.bpp -relief flat
    label $w.f.bpp.label  -font $f -anchor w -text "Pixel depth"
    radiobutton $w.f.bpp.bpp4 -font $f -text "4-bit" \
	-variable qcambpp -value 4 -command "$vpipe_ hardware set BPP 4"
    radiobutton $w.f.bpp.bpp6 -font $f -text "6-bit" \
	-variable qcambpp -value 6 -command "$vpipe_ hardware set BPP 6"
    pack $w.f.bpp.label $w.f.bpp.bpp4 $w.f.bpp.bpp6 \
	-side left -fill x -expand 1

    pack  $w.f.s $w.f.bpp \
	 -fill x -expand 1 -padx 1m

    pack $w.title $w.f -fill x -expand 1

    set qcamwindow(setbright) "$w.f.s.s.bright set"
    set qcamwindow(setcont) "$w.f.s.s.cont set"
    set qcamwindow(setwbal) "$w.f.s.s.wbal.scale set"
    set qcamwindow(setbpp) "set qcambpp"
}

#
ControlMenu instproc build.brooktree848 { w } {
	$self instvar vpipe_
	set f [$self get_option smallfont]
	label $w.title -text "Video Input"
	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.h -relief flat

	label $w.f.h.label  -font $f -anchor e -text "Hue"

	scale $w.f.h.scale -orient horizontal -width 12 -length 20 \
		           -relief groove -showvalue 0 -from -128 -to 127 \
                          -command "$vpipe_ hardware set HUE"
	pack  $w.f.h.label $w.f.h.scale -side left -fill x -expand 1

	frame $w.f.ll -relief flat

	label $w.f.ll.label  -font $f -text "Luma" -anchor s

	label $w.f.ll.clabel -font $f -text "Contrast" -anchor s

	label $w.f.ll.blabel -font $f -text "Brightness" -anchor s
	pack  $w.f.ll.clabel $w.f.ll.label $w.f.ll.blabel \
			     -side left -fill x -expand 1

	frame $w.f.l  -relief flat

	scale $w.f.l.cscale   -orient horizontal -width 12 -relief groove \
                              -showvalue 0 -from 0 -to 127 \
                              -command "$vpipe_ hardware set contrast"

	scale $w.f.l.bscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 255 \
                            -command "$vpipe_ hardware brightness"
	pack  $w.f.l.cscale $w.f.l.bscale  -side left -fill x -expand 1

	frame $w.f.cl  -relief flat

	label $w.f.cl.label  -font $f -text "Chroma" -anchor n

	label $w.f.cl.glabel -font $f -text "Gain" -anchor n

	label $w.f.cl.slabel -font $f -text "Saturation" -anchor n
	pack  $w.f.cl.glabel $w.f.cl.label $w.f.cl.slabel \
			     -side left -fill x -expand 1

	frame $w.f.c -relief flat

	scale $w.f.c.gscale -orient horizontal -width 12 -relief groove \
                             -showvalue 0 -from 0 -to 255 \
                             -command "$vpipe_ hardware set CHROMA_GAIN"

	scale $w.f.c.sscale -orient horizontal -width 12 -relief groove \
                            -showvalue 0 -from 0 -to 127 \
                            -command "$vpipe_ hardware set CHROMA_SATURATION"
	pack  $w.f.c.gscale $w.f.c.sscale -side left -fill x -expand 1


	checkbutton $w.f.b -text PAL -variable signalFormat -onvalue pal \
		-offvalue ntsc -command \
		"$vpipe_ hardware format \$signalFormat"

	pack  $w.f.h $w.f.ll $w.f.l $w.f.c $w.f.cl $w.f.b \
	      -fill x -expand 1 -padx 1m



	pack $w.title $w.f -fill x -expand 1

	$w.f.h.scale  set 0
	$w.f.l.cscale set 64
	$w.f.l.bscale set 128
	$w.f.c.gscale set 44
	$w.f.c.sscale set 64
}

#
ControlMenu instproc build.brooktree848 w {
	$self instvar vpipe_
	set f [$self get_option smallfont]
#	label $w.title -text "Video Input"

	frame $w.f -relief sunken -borderwidth 2

	frame $w.f.h -relief flat
	label $w.f.h.label  -font $f -text "Hue" -width 12
	scale $w.f.h.hscale -orient horizontal \
		           -relief groove -showvalue 0 -from -128 -to 127 \
                          -command "$vpipe_ hardware hue"
	pack $w.f.h.label -side left
	pack $w.f.h.hscale -side left -fill x -expand 1

	frame $w.f.l -relief flat

	frame $w.f.l.l
	label $w.f.l.l.clabel -font $f -text "Contrast" -width 12
	scale $w.f.l.l.cscale -orient horizontal -relief groove -width 12 \
                              -showvalue 0 -from 0 -to 127 \
                              -command "$vpipe_ hardware contrast"
	pack  $w.f.l.l.clabel -side left
	pack  $w.f.l.l.cscale -side left -fill x -expand 1

	frame $w.f.l.r
	label $w.f.l.r.blabel -font $f -text "Brightness" -width 12
	scale $w.f.l.r.bscale -orient horizontal -relief groove -width 12 \
                            -showvalue 0 -from -128 -to 127 \
                            -command "$vpipe_ hardware brightness"
	pack  $w.f.l.r.blabel -side left
	pack  $w.f.l.r.bscale -side left -fill x -expand 1

	pack  $w.f.l.l $w.f.l.r  -side top -fill x -expand 1

	frame $w.f.cl  -relief flat

	frame $w.f.cl.l
	label $w.f.cl.l.glabel -font $f -text "Chroma Gain" -width 12
	scale $w.f.cl.l.gscale -orient horizontal -relief groove -width 12 \
                             -showvalue 0 -from 0 -to 255 \
                             -command "$vpipe_ hardware uvgain"
	pack  $w.f.cl.l.glabel -side left
	pack  $w.f.cl.l.gscale -side left -fill x -expand 1

	frame $w.f.cl.r
	label $w.f.cl.r.slabel -font $f -text "Saturation" -width 12
	scale $w.f.cl.r.sscale -orient horizontal -relief groove -width 12 \
                            -showvalue 0 -from 0 -to 127 \
                            -command "$vpipe_ hardware saturation"
	pack  $w.f.cl.r.slabel -side left
	pack  $w.f.cl.r.sscale -side left -fill x -expand 1

	pack  $w.f.cl.r $w.f.cl.l  -side top -fill x -expand 1

	#FIXME
	checkbutton $w.f.b -text PAL -variable signalFormat -onvalue pal \
		-offvalue ntsc -command \
		"$vpipe_ hardware format \$signalFormat"


	pack $w.f.l $w.f.h $w.f.cl $w.f.b -side top -fill both -expand 1
	pack $w.f -fill both -expand 1

#	if [have grabber] {
#		$w.f.h.hscale set [grabber hue]
#		$w.f.l.l.cscale set [grabber contrast]
#		$w.f.l.r.bscale set [grabber brightness]
#		$w.f.cl.l.gscale set [grabber uvgain]
#		$w.f.cl.r.sscale set [grabber saturation]
#	} else {
		$w.f.h.hscale set 0
		$w.f.l.l.cscale set 64
		$w.f.l.r.bscale set 0
		$w.f.cl.l.gscale set 44
		$w.f.cl.r.sscale set 64
#	}
}


#
# X11 Grabber controls
#
ControlMenu instproc x11grabUpdatePos {x y w h} {

    global x11grabcontrols
    set w $x11grabcontrols

    if {[string compare $x [$w.x11grab.row1.pos.x.e get]] != 0} {
	$w.x11grab.row1.pos.x.e delete 0 end
	$w.x11grab.row1.pos.x.e insert 0 $x
    }
    if {[string compare $y [$w.x11grab.row1.pos.y.e get]] != 0} {
	$w.x11grab.row1.pos.y.e delete 0 end
	$w.x11grab.row1.pos.y.e insert 0 $y
    }
    if {[string compare $w [$w.x11grab.row1.pos.w.e get]] != 0} {
	$w.x11grab.row1.pos.w.e delete 0 end
	$w.x11grab.row1.pos.w.e insert 0 $w
    }
    if {[string compare $h [$w.x11grab.row1.pos.h.e get]] != 0} {
	$w.x11grab.row1.pos.h.e delete 0 end
	$w.x11grab.row1.pos.h.e insert 0 $h
    }
}

ControlMenu instproc x11cmd.update.geo w {
    $self instvar vpipe_
    $vpipe_ hardware fixed [$w.row.x get] [$w.row.y get]
}



ControlMenu instproc x11cmd.fixed {} {
    global x11Source x11grabcontrols
    set w $x11grabcontrols
    $w.label configure -text "$x11Source"
    if [winfo exists $w.row] {
	destroy $w.row
    }
    frame $w.row
    pack append $w.row \
	[label $w.row.xl -text "X:" -width 2 -anchor e] {left filly} \
	[entry $w.row.x -relief flat -width 4] {left filly} \
	[label $w.row.yl -text "Y:" -width 2 -anchor e] {left filly} \
	[entry $w.row.y -relief flat -width 4] {left filly}
    bind $w.row.x <Return> "$self x11cmd.update.geo $w"
    bind $w.row.y <Return> "$self x11cmd.update.geo $w"

    pack $w.row -after $w.label
}

ControlMenu instproc x11cmd.pointer {} {
    $self instvar vpipe_
    global x11Source x11grabcontrols
    set w $x11grabcontrols
    $w.label configure -text "$x11Source"
    if [winfo exists $w.row] {
	destroy $w.row
    }
    frame $w.row
    pack append $w.row \
	[button $w.row.s -text "Follow pointer" \
	     -command "$vpipe_ hardware pointer"] { left filly }
    pack $w.row -after $w.label
}

ControlMenu instproc x11cmd.window {} {
    $self instvar vpipe_
    global x11Source x11grabcontrols
    puts "x11cmd -- x11Source $x11Source"
    set w $x11grabcontrols
    $w.label configure -text "$x11Source"
    if [winfo exists $w.row] {
	destroy $w.row
    }
    frame $w.row
    pack append $w.row \
	[button $w.row.s -text "Select window" \
	     -command "$vpipe_ hardware window"] { left filly }
    pack $w.row -after $w.label
}

ControlMenu instproc build.x11 w {
    global x11grabcontrols x11Source
    set f [$self get_option smallfont]

    label $w.title -text "X11 Grabber controls"
    frame $w.x11grab -relief sunken -borderwidth 2
    set x11grabcontrols $w.x11grab
    set x11Source "Fixed"
    set w1 $w.x11grab


    set m $w1.menu
    set m1 $m.m1
    menubutton $w1.menu -menu $m1 -text "Source:" \
	-relief raised -width 7 -font $f
    label $w1.label -width 6 -font $f
    frame $w1.row
    menu $m1
    $m1 add radiobutton -label Fixed \
	-state active \
	-command "$self x11cmd.fixed" -font $f -variable x11Source
#    $m1 add radiobutton -label Pointer \
#	-command "$self x11cmd.pointer" -font $f -variable x11Source
#    $m1 add radiobutton -label Window \
#	-command "$self x11cmd.window" -font $f -variable x11Source

    pack append $w1 \
	$w1.menu {left} \
	$w1.label {left} \
	$w1.row {left}

    pack $w $w.title $w1 -fill x -expand 1

    $self x11cmd.fixed
}

ControlMenu instproc build.v4l { w } {
	$self instvar vpipe_

	set f [$self get_option smallfont]

	# the title of the frame
	label $w.title -text "Video4Linux grabber controls"
	pack $w.title  -fill x -expand 1

	frame $w.f -relief sunken -borderwidth 2

	# the reset button goes to the left
	frame $w.f.left -relief flat
	button $w.f.left.reset -font $f -width 10 -text "Reset" \
			-command "$w.f.right.top.c.cscale set 128; \
					$w.f.right.top.b.bscale set 128; \
					$w.f.right.bottom.h.hscale set 128; \
					$w.f.right.bottom.s.sscale set 128; \
					$vpipe_ hardware controls reset" \
			-padx 1 -pady 1
	pack $w.f.left.reset
	frame $w.f.right -relief flat
	frame $w.f.right.top -relief flat

	# the contrast slider
	frame $w.f.right.top.c -relief flat -borderwidth 2
	scale $w.f.right.top.c.cscale -orient horizontal -font $f -relief groove \
			-width 12  \
			-showvalue 0 -from 0 -to 255 \
			-label Contrast \
			-command "$vpipe_ hardware contrast"
	$w.f.right.top.c.cscale set 128;
	pack  $w.f.right.top.c.cscale  -fill x -expand 1

	# the brightness slider
	frame $w.f.right.top.b -relief flat -borderwidth 2
	scale $w.f.right.top.b.bscale -orient horizontal -font $f -relief groove \
			-width 12  \
			-showvalue 0 -from 0 -to 255 \
			-label Brightness \
			-command "$vpipe_ hardware brightness"
	pack  $w.f.right.top.b.bscale -fill x -expand 1
	$w.f.right.top.b.bscale set 128;
	frame $w.f.right.bottom -relief flat

	# the hue slider
	frame $w.f.right.bottom.h -relief flat -borderwidth 2
	scale $w.f.right.bottom.h.hscale -orient horizontal -font $f -relief groove \
			-width 12 \
			-showvalue 0 -from 0 -to 255 \
			-label Hue \
			-command "$vpipe_ hardware hue"
	$w.f.right.bottom.h.hscale set 128;
	pack  $w.f.right.bottom.h.hscale -fill x -expand 1

	# the saturation (colour) slider
	frame $w.f.right.bottom.s -relief flat -borderwidth  2
	scale $w.f.right.bottom.s.sscale -orient horizontal -font $f -relief groove \
			-width 12 \
			-showvalue 0 -from 0 -to 255 \
			-label Saturation \
			-command "$vpipe_ hardware saturation"
	$w.f.right.bottom.s.sscale set 128;
	pack  $w.f.right.bottom.s.sscale -fill x -expand 1

	# pack everything
	pack $w.f.right.top.b $w.f.right.top.c -side right
	pack $w.f.right.bottom.s $w.f.right.bottom.h -side right
	pack $w.f.right.top $w.f.right.bottom -side top -fill x -expand 1
	pack $w.f.left $w.f.right -side left -expand 1 -fill x
	pack $w.f -expand 1 -fill x
}


ControlMenu instproc build.test { w } {
	global testFileChoice
	global testFileNameEntry

	set f [$self get_option smallfont]

	# title of the frame
	label $w.title -text "Test capturer controls"
	pack $w.title  -fill x -expand 1

	# specific test controls
	frame $w.f -relief sunken -borderwidth 2

	# file name
	frame $w.f.file
	button $w.f.file.select -text File -borderwidth 2 \
			-anchor c -font $f -command "$self change_file 1"
	set testFileNameEntry [new TextEntry "$self change_file 1" \
			$w.f.file.name ""]
	pack $w.f.file.select -side left
	pack $w.f.file.name -side left -expand 1 -fill x -pady 2

	# pack everything
	pack $w.f.file -expand 1 -fill x
	pack $w.f -expand 1 -fill x
}


ControlMenu instproc change_file {tofile args} {
	global testFileChoice
	global testFileNameEntry
	$self instvar vpipe_

	if {$tofile == 1} {
		if {$args == ""} {
			set filename [tk_getOpenFile -filetypes {{{PPM Files} {.ppm}}}\
					-title "Choose the testcard image"]
			if {$filename != ""} {
				$testFileNameEntry set-value $filename
				set testFileChoice 1
			}
		} else {
			set filename [lindex $args 0]
			set testFileChoice 1
		}

		if {(![catch {file type $filename} res]) && ($res=="file")} {
			$vpipe_ hardware set-file $filename
			#[[$vpipe_ set tap_] set grabber_] port file
			global inputPort
			set inputPort file
		}

	} else {
		# use Matt's blue passion

		set current_filename [$testFileNameEntry entry-value]
		if {$current_filename != ""} {
			$testFileNameEntry set-value ""
		}

		$vpipe_ hardware set-bluepassion
		set testFileChoice 0
	}

	# this return is needed!
	return 0
}

