#!/bin/sh
# path trick for tclsh variants \
exec tclsh $0 ${1+"$@"}

# killrqm.tcl --
#
#       A script to gracefully kill a QM app with no gui
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source ../../../../lib/tcl/dp-lib.tcl

global g_hostname
global g_port

proc showUsage {} {
   puts stdout "usage:  killrqm \[-port <port>\] \[-host <host>\]"
}

proc getFlags {argv} {
    global g_hostname g_port

    # defaults
    set g_hostname "garfield.cs.berkeley.edu"
    set g_port 6903

    set state flag
    foreach arg $argv {
	switch -exact -- $state {
	    flag {
		switch -exact -- $arg {
		    -port {
			set state "port"
		    }
		    -host {
			set state "host"
		    }
		    -help {
			showUsage
			exit
		    }
		    default {
			showUsage
			exit
		    }
		}
	    }
	    port {
		set g_port $arg
		set state "flag"
	    }
	    host {
		set g_hostname $arg
		set state "flag"
	    }
	}
    }
}


# main function
getFlags $argv
set client_ [dp_MakeRPCClient $g_hostname $g_port]
dp_RDO $client_ rqm_killServer

