# source-srmv2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Timer/Periodic
Class SRMv2_RReqTimer -superclass Timer/Periodic

SRMv2_RReqTimer instproc init { range agent } {
	$self instvar agent_ range_
	set agent_ $agent
	set range_ $range
	$self next

	# Weight (C2/C1) = 1 now.
	$self randomize "yes" 1
}


# Exponential backoff
SRMv2_RReqTimer instproc timeout { } {
	$self instvar agent_ range_ period_
	$self instvar id_

#	[$agent_ set session_] send-rreq $id_ $range_
	set period_ [expr 2 * $period_]
}

SRMv2_Source instproc oid { name } {
	$self instvar oid_
	if [info exists oid_($name)] {
		return $oid_($name)
	}
}

SRMv2_Source instproc last { name } {
	$self instvar last_
	if [info exists last_($name)] {
		return $last_($name)
	} else {
		return 0
	}
}

SRMv2_Source instproc oid-exists { name } {
	$self instvar oid_
	return [info exists oid_($name)]
}

SRMv2_Source instproc name { oid } {
	$self instvar names_
	if [info exists names_($oid)] {
		return $names_($oid)
	}
}

#
# Create an oid
#
SRMv2_Source instproc create-oid { name } {
	$self instvar oid_ names_ cnt_ prio_ last_

	incr cnt_
	set names_($cnt_) $name
	set oid_($name) $cnt_

	set last_($name) 0
	set prio_($name) 1
	set rreq_($name) {}

	return $cnt_
}

# Gaps is a sorted list of missing ranges (start, end),
# both included in the range.
# The source ID is now the traditional IP address + user ID + instance
# This will become a variable length source address.

SRMv2_Source instproc init-vars { session srcID } {
	$self instvar cnt_ ns_ max_announce_ session_
	$self instvar id_

	set max_announce_ 10
	set cnt_ 0
	set session_ $session
	set id_ $srcID

	random 0
}

#
# combo has the format oid:name
#
SRMv2_Source instproc add-binding { combo id } {
	$self instvar oid_ rreq_ names_ last_ cnt_

	set l [split $combo ":"]
	set name [lindex $l 0]
	set oid [lindex $l 1]

	set oid_($name) $oid
	set names_($oid) $name
	set last_($name) 0
	set rreq_($name) {}

	#
	# Detect missing binds and generate
	# a repair request.
	#

	if {$oid - $cnt_  != 1}  {
		$self send-rreq $id 0 ($cnt_+1) ($oid-1)
		set cnt_ $oid
	}
}

# Increase the priority of this
# Object since it was changed since the
# last time it's state was announced.
# This is unused if the agent represents a remote
# data source. We really should fix this, since
# ours is a "scalable" reliable multicast toolkit.
SRMv2_Source instproc update-objinfo { oid first last } {
	$self instvar prio_ last_
	$self instvar is_

	set name [$self name $oid]

	incr prio_($name)

	# If some bytes were missing, send an
	# SRMv2 repair request
	if {$first - $last_($name) > 1} {
		$self send-rreq $id_ $oid ($last_($name)+1) ($first-1)
	}

	# Update last only if the data is new
	if {$last > $last_($name)} {
		set last_($name) $last
	}
}


SRMv2_Source instproc get-recent { } {
	$self instvar prio_ max_announce_

	set cdf 0
	foreach name [array names prio_] {
		set cdf [expr $cdf + $prio_($name)]
	}
	set hits { }
	set probs { }

	for {set i 0} {$i < $max_announce_} {incr i} {
		set r [expr [random]/double(0x7fffffff) * $cdf]
		lappend probs $r
	}
	lsort -real $probs
	set index 0
	set cdf   0
	foreach name [array names prio_] {
		set start $cdf
		set cdf  [expr $cdf + $prio_($name)]
		set curr [lindex $probs $index]
#puts "$start <= $curr <= $cdf"
		if [expr ($start <= $curr) && ($curr <= $cdf)] {
			set l [$self last $name]
			lappend hits "$name:$l"
			# Set it back to the base value (1)
			# since this is the beginning of the next
			# session announcement cycle.
			set prio_($name) 1
			incr index
		}
	}
	return $hits
}


SRMv2_Source instproc detect-loss { oid left right } {
	$self instvar last_ rreq_ names_

	set name [$self name $oid]
#	puts "detect-loss $left $right $last_($name)"

	if {$right < 0 || $left < 0 }  {
		puts "Invalid range $left-$right"
		return
	}
	if {$left == [expr $last_($name) + 1]} {
		set last_($name) $right
		return;
	}

	#
	# Handle the first case specially
	#
	puts "rreqs($name) : $rreq_($name)"
	if {$last_($name) < $left} {
		set r "$oid:[expr $last_($name)+1]-[expr $left-1]"
		set id [new SRMv2_RReqTimer $r $self]
		$id start 1000
		puts "id = $id"
		set rreq_($name) [linsert $rreq_($name) end \
				[list [expr $last_($name)+1] [expr $left-1] $id]]
                set last_($name) $right
		puts "Inserting range [expr $last_($name)+1] [expr $left-1] $id"
		return
	}
	set last_($name) $right
	for {set i 0} {$i < [llength $rreq_($name)]} {incr i} {
		set start [lindex 0 $g]
		set end   [lindex 1 $g]

		if {$right <= $start} {
			break
		}
		if {$left > $end} {
			continue
		}
		if {$left <= $start && $right >= $end} {
			lreplace rreq_($name) $i $i
			puts "In splitting."
			if {$left != $start} {
				set split_right [list ($right+1) $end]
				set rreq_($name) [linsert $rreq_($name) $i $split_right]
			}
			if {$left != $start} {
				set split_left [list $start ($left-1)]
				set rreq_($name) [linsert $rreq_($name) $i $split_left]
			}
			return
		}
	}

	# We'll worry about the remaining conditions later,
	# since they currently won't occur in our protocol.
}

