# source-proxy.tcl --
#
#       Defines mechanisms for using a proxy to transmit announcements.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import ProgramSource TCP/Client

#
Class ProgramSource/Proxy -superclass { ProgramSource TCP/Client }

# FIXME spec shouldn't be necessary -- should do ERS
ProgramSource/Proxy public init {ui spec} {
    #FIXME
    $self set name_ "Proxy: $spec"

    $self next $ui

    # make sure no client caching is performed
    $self instvar cache_
    catch {unset cache_}

    $self set buffer_ ""

    # FIXME ERS goes here
    $self connect $spec
}

#
ProgramSource/Proxy public destroy {} {
    $self next
}

# Used to set the name of the tag for this program source in the
# user interface.
ProgramSource/Proxy public name {} {
    return [$self set name_]
}

# FIXME
ProgramSource/Proxy public scopes {} {
    return {}
}

#
ProgramSource/Proxy private connect {spec} {
    # open tcp connection to the cache agent
    set l [split $spec /]
    set host [lindex $l 0]
    set port [lindex $l 1]
    $self open $host $port

    # ask the cache agent to send programs
    $self send "subscribe\n"
}

#
ProgramSource/Proxy public recv s {
    $self instvar buffer_
    append buffer_ "$s\n"

    # look for blank line
    if {[string trim $s] == ""} {
	set i [string wordend $buffer_ 0]
	set cmd [string trim [string range $buffer_ 0 $i]]
	set data [string trim [string range $buffer_ $i end]]

	switch $cmd {
	    "add" - "update" {
		$self next $data
	    }

	    "remove" {
		$self instvar progs_
		if ![info exists progs_($data)] {
		    $self warn "got remove for nonexistent prog \"$data\""
		} else {
		    $self remove $progs_($data)
		}
	    }

	    default {
		$self warn "got bogus command \"$cmd\""
	    }
	}

	set buffer_ ""
    }
}

ProgramSource/Proxy public announce {msg scope} {
    #FIXME
}

#FIXME need stop-announce
