# snap-api.tcl --
#
#       OTcl class wrappers for SRMv2 API
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/common/snap-api.tcl,v 1.4 2002/02/03 04:25:43 lim Exp $


Class SRMv2_Session
Class SRMv2_Source


SRMv2_Session instproc init {addr sport rport {ttl 16}} {
	$self next

	$self instvar addr_ sport_ ttl_ rport_
	set addr_ $addr
	set sport_ $sport
	set rport_ $rport
	set ttl_ $ttl

	$self instvar srm_session_
	set srm_session_ [srm_create_session $addr $sport $rport $ttl]

	if { $srm_session_ == {} } return
	srm_callbacks $srm_session_ "$self callback srm_recv" \
			"$self callback srm_should_recover" \
			"$self callback srm_read_adu" \
			"$self callback srm_source_update" \
			"$self callback srm_recv_cid"
}


SRMv2_Session public destroy {} {
	$self instvar srm_session_
	# FIXME: must destroy all source otcl objects as well
	if { $srm_session_ != {} } {
		srm_destroy_session $srm_session_
	}
	$self next
}


SRMv2_Session public srm_session {} {
	return [$self set srm_session_]
}


SRMv2_Session public reset {addr sport rport {ttl 16}} {
	$self instvar srm_session_
	return [srm_reset_session $srm_session_ reset $addr $sport $rport $ttl]
}


SRMv2_Session public delay_until_full_packet { {flag {}} } {
	$self instvar srm_session_
	if { $flag=={} } {
		return [srm_delay_until_full_packet $srm_session_]
	} else {
		return [srm_delay_until_full_packet $srm_session_ $flag]
	}
}


SRMv2_Session public bandwidth { {bps {}} } {
	$self instvar srm_session_
	if { $bps=={} } {
		return [srm_session_bandwidth $srm_session_]
	} else {
		srm_session_bandwidth $srm_session_ $bps
	}
}


SRMv2_Session public drop_probability { {dropProb {}} } {
	$self instvar srm_session_
	if { $dropProb=={} } {
		return [srm_drop_probability $srm_session_]
	} else {
		return [srm_drop_probability $srm_session_ $dropProb]
	}
}


SRMv2_Session public callback_object { args } {
	$self instvar srm_session_ callback_obj_
	if { [llength $args]==0 } {
		if [info exists callback_obj_] {
			return $callback_obj_
		} else {
			return {}
		}
	} else {
		set object [lindex $args 0]
		if { $object=={} } {
			catch { unset callback_obj_ }
		} else {
			set callback_obj_ $object
		}
	}
}


SRMv2_Session private callback { method srm_source args } {
	$self instvar callback_obj_ sources_
	if [info exists callback_obj_] {
		set obj $callback_obj_
	} else { set obj $self }

	if ![info exists sources_($srm_source)] {
		SRMv2_Source create_remote_source $self $srm_source
	}

	eval [list $obj] [list $method] $sources_($srm_source) $args
}


SRMv2_Session private new_source { srm_source src } {
	$self instvar sources_
	set sources_($srm_source) $src
}


SRMv2_Session public srm_recv { src cid seqno data } {
}


SRMv2_Session public srm_should_recover { src cid sseq eseq } {
	return 1
}


SRMv2_Session public srm_read_adu { src cid seqno } {
	error "application must redefine the SRMv2_Session::srm_read_adu\
			method"
}


SRMv2_Session public srm_source_update { src info } {
}


SRMv2_Session public srm_recv_cid { src cid parent name } {
}


SRMv2_Source public init { args } {
	SRMv2_Source instvar remotesrc_
	$self instvar srm_source_ sess_
	if ![info exists remotesrc_] {
		# we are creating a local source
		set sess_ [lindex $args 0]
		set srcid [lindex $args 1]
		if { $srcid=={} } {
			set srm_source_ [srm_create_source \
					[$sess_ srm_session]]
		} else {
			set srm_source_ [srm_create_source \
					[$sess_ srm_session] $srcid]
		}
	} else {
		# we are creating a remote source
		set sess_ [lindex $args 0]
		set srm_source_ [lindex $args 1]
	}

	$sess_ new_source $srm_source_ $self
}


SRMv2_Source proc.private create_remote_source { sess srm_source } {
	$self instvar remotesrc_ remotesrc_cnt_
	set remotesrc_ 1
	if ![info exists remotesrc_cnt_] { set remotesrc_cnt_ 0 }
	incr remotesrc_cnt_

	# don't want to use "new" here coz I want this code to be
	# otcl-only (and otcl doesn't have the "new" proc)
	set s [SRMv2_Source _o_srmv2src$remotesrc_cnt_ $sess $srm_source]
	unset remotesrc_
	$sess new_source $srm_source $s
	return $s
}


SRMv2_Source public destroy {} {
	# FIXME: what should we do here
	$self next
}


SRMv2_Source public srm_source {} {
	return [$self set srm_source_]
}


SRMv2_Source public session {} {
	return [$self set sess_]
}


SRMv2_Source public app_info { args } {
	$self instvar srm_source_
        if {[llength $args] > 0} {
		srm_app_info $srm_source_ [lindex $args 0]
	} else {
		return [srm_app_info $srm_source_]
	}
}


SRMv2_Source public calloc { {parent_cid 0} {name {}} } {
	$self instvar srm_source_
	return [srm_calloc $srm_source_ $parent_cid $name]
}


SRMv2_Source public get_container_name { cid } {
	$self instvar srm_source_
	return [srm_get_container_name $srm_source_ $cid]
}


SRMv2_Source public get_parent_cid { cid } {
	$self instvar srm_source_
	return [srm_get_parent_cid $srm_source_ $cid]
}


SRMv2_Source public send { cid data } {
	$self instvar srm_source_
	return [srm_send $srm_source_ $cid $data]
}


SRMv2_Source public recover { cid sseq eseq } {
	$self instvar srm_source_
	return [srm_recover $srm_source_ $cid $sseq $eseq]
}


SRMv2_Source public source_id { } {
	$self instvar srm_source_
	return [srm_get_source_id $srm_source_]
}

