# ui-filedlg.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/player/ui-filedlg.tcl,v 1.4 2002/02/03 04:22:14 lim Exp $


import WidgetClass FileDialog

WidgetClass FileDialog/Archive -superclass FileDialog -default {
	{ .preview.Checkbutton.borderWidth 1 }
	{ .preview.Checkbutton.highlightThickness 1 }
	{ .preview.info.text.borderWidth 1 }
	{ .preview.info.text.highlightThickness 0 }
	{ .preview.info.text.width 25 }
	{ .preview.info.text.height 6 }
	{ .preview.info.scrollbar both }
	{ .preview.info*Scrollbar.width 10 }
	{ .preview.info*Scrollbar.borderWidth 1 }
	{ .preview.info*Scrollbar.highlightThickness 1 }
	{ *MultiColumnListbox*bbox.width 300 }
}


FileDialog/Archive instproc build_widget { path } {
	$self next $path
	$self subwidget filebox configure \
			-browsecmd "$self browse_preview; $self ignore_args"

	frame $path.preview
	checkbutton $path.preview.button -text "Preview" -anchor w \
			-variable [$self tkvarname preview_] \
			-command "$self browse_preview"
	#text $path.preview.info -state disabled -wrap none
	ScrolledText $path.preview.info -options {
		{ text.state disabled }
		{ text.wrap none }
	}

	$self tkvar preview_
	set preview_ 1

	pack $path.preview.button -side top -fill x -anchor w
	pack $path.preview.info -fill both -expand 1 -padx 5 -pady 5
	pack $path.preview -fill both -side right
}


FileDialog/Archive instproc browse_preview { } {
	set filetypes [$self subwidget filebox cget -filetypes]
	set ext [string trim [lindex [lindex $filetypes 0] 1]]
	switch -exact -- $ext {
		.dat {
			$self browse_preview_ browse_data_index DAT
		}
		.idx {
			$self browse_preview_ browse_data_index IDX
		}
		.ctg {
			$self browse_preview_ browse_catalog
		}
	}
}


FileDialog/Archive instproc browse_preview_ { method args } {
	$self tkvar preview_

	if { $preview_ } {
		set text [[$self subwidget preview].info subwidget text]
		$text configure -state normal
		$text delete 1.0 end
		set path [file join \
				[$self subwidget filebox cget -directory] \
				[$self subwidget filebox cget -filename]]
		eval [list $self] [list $method] [list $path] $args
		$text configure -state disabled
	}
}


FileDialog/Archive instproc browse_data_index { filename filetype } {
	set afile [new ArchiveFile]
	if ![catch {$afile open $filename; $afile header hdr} ] {
		if { [string match "M${filetype}*" $hdr(version)] } {
			set duration [expr $hdr(end) - $hdr(start)]
			if { $duration < 0.0 } {
				set duration 0.0
			}

			set    string "Version: $hdr(version)\n"
			append string "Protocol: $hdr(protocol)\n"
			append string "Media: $hdr(media)\n"
			append string "CName: $hdr(cname)\n"
			append string "Name: $hdr(name)\n"
			append string "Start: [ArchiveFile ts2string \
					$hdr(start)]\n"
			append string "End: [ArchiveFile ts2string \
					$hdr(end)]\n"
			append string "Duration: $duration seconds\n"
		} else {
			set string "Cannot preview file"
		}
	} else {
		set string "Cannot preview file"
	}
	[$self subwidget preview].info subwidget text insert end $string
	delete $afile
}


FileDialog/Archive instproc browse_catalog { filename } {
	set catalog [new SessionCatalog]
	set text [[$self subwidget preview].info subwidget text]

	if [catch {$catalog open $filename}] {
		$text insert end "Cannot open file"
		delete $catalog
		return
	}

	if [catch {$catalog read}] {
		global errorInfo
		$text insert end "Cannot preview session catalog"
		delete $catalog
		return
	}

	foreach id [$catalog info streams] {
		lappend session([$catalog info session $id]) $id
	}

	foreach s [array names session] {
		$text insert end "$s:\n"
		foreach id $session($s) {
			$text insert end "    Data file: [file tail \
					[$catalog info datafile $id]]\n"
			$text insert end "    Index file: [file tail \
					[$catalog info indexfile $id]]\n"
		}
	}

	delete $catalog
}

