# sdp_agent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/sdp_agent.tcl,v 1.18 2002/02/03 04:22:06 lim Exp $


#
# The SDP_Agent class handles the receiving of SDP Programs.  Subsequently,
# these Programs can be returned upon request.
#
Class SDP_Agent

SDP_Agent public init { } {

    $self instvar sessions_ sdp_list_

    # Initialize the sessions directory.
    #set session_ ~/mash/tcl/applications/mash_server/sessions/
    #set o [$self options]
    #$o load_preferences "mserver"
    set sessions_ [$self get_option sdp_sessions_dir]

    # Initialize the list of SDP Programs
    set sdp_list_ {}

    # Read cache
    $self read_cache
}


SDP_Agent private read_cache { } {

    $self instvar sessions_ sdp_list_

    mtrace trcNet "In SDP_Agent::read_cache"

    cd $sessions_
    set msgfiles [glob -nocomplain -- *]

    foreach f $msgfiles {

	# Extract the Program object from the catalog file.
	set msg_str [read_file $f]
	set msg [lindex [ [new SDPParser 0] parse $msg_str] 0]
	if {$msg==""} {
		file delete $f
	} else {

		set program [new Program $msg]

		# Use the message's time information to figure out whether
		# this announcement has expired.
		set sdp_time [$msg set alltimedes_]
		if {$sdp_time==""} {
			file delete $f
		} else {
			set end_time [[lindex $sdp_time 0] set endtime_]
			set end_offset [[lindex $sdp_time 0] sec_until_current endtime_]
			if { $end_offset < 0 && $end_time != 0 } {
				file delete $f

			} else {
				# Append the key/msg pair to the sdp_list_.
				lappend sdp_list_ [get_key $program] $msg
			}
		}
	}
    }
}


#
# This method is a called when a new Program is received.  The addprog
# method takes a program and adds it to the current list of programs.
# Finally, the program is written to the cache.
#
SDP_Agent public addprog { source program } {

    $self instvar sessions_ sdp_list_
    global tcl_platform

    # Extract the unique key and message of this Program
    set key [get_key $program]
    set msg [$program base]

    # Check if this announcement is currently in the sdp_list_.
    if { [lsearch -exact $sdp_list_ $key] == -1 } {

	mtrace trcNet "-> Received announcment: $key"

	# Append the key/program pair to the list.
	lappend sdp_list_ $key $msg

	# Store the message in a file with the filename key in the cache.
	if {$tcl_platform(platform) == "windows"} {
		# semi-colons are illegal in windows filenames
		regsub -all ":" $key "+" key

	}
	append filename $sessions_ $key

	write_to_file $filename [$msg obj2str]
    }
}


SDP_Agent public updateprog { source program } {

    $self instvar sessions_ sdp_list_
    global tcl_platform

    # Extract the unique key and message of this Program; from the key,
    # construct the filename.
    set key [get_key $program]
    set msg [$program base]
    if {$tcl_platform(platform) == "windows"} {
	    # semi-colons are illegal in windows filenames
	    regsub -all ":" $key "+" newkey
	    append filename $sessions_ $newkey

    } else {
	    append filename $sessions_ $key

    }
	mtrace trcNet "-> Updating announcment: $key"

    # Check that the filename exists in the cache.
    set exists [file exists $filename]
    if { $exists } {
	# Replace the old key/program pair in the list with the new one.
	set index [expr [lsearch -exact $sdp_list_ $key] + 1]
	set sdp_list_ [lreplace $sdp_list_ $index $index $msg]

	# Write the updated message in the file.
	write_to_file $filename [$msg obj2str]

    } else {
	$self addprog $source $program
    }
}


SDP_Agent public removeprog { source program } {

    $self instvar sessions_ sdp_list_
    global tcl_platform

    # Extract the unique key of this Program; from that, construct
    # the filename.
    set key [get_key $program]
    if {$tcl_platform(platform) == "windows"} {
	    # semi-colons are illegal in windows filenames
	    regsub -all ":" $key "+" newkey
	    append filename $sessions_ $newkey

    } else {
	    append filename $sessions_ $key

    }

    mtrace trcNet "-> Removing announcment: $key"

    # Remove the key/program pair from the list.
    set index [lsearch -exact $sdp_list_ $key]
    if { $index != -1 } {
	set sdp_list_ [lreplace $sdp_list_ $index [expr $index + 1]]

    } else {
	mtrace trcNet "-> Announcement not in sdp_list_."
    }

    # Check that the length of the list is still an even number.
    if { [expr [llength $sdp_list_] % 2] != 0 } {
	puts "removeprog produced an invalid sdp_list_."
	exit
    }

    # Remove the file corresponding to the key in the cache.
    file delete $filename
}


SDP_Agent public addsource { source } {
}


#
# The return_progs method returns a list of SDP key and Program pairs
# which can then be converted into an associated array.
#
SDP_Agent public return_progs { } {
    $self instvar sdp_list_
    return $sdp_list_
}


# -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


import HTTP_Agent
import ScopeZone
import ProgramSource/SAP

#
# The HTTP_Agent/SDP_Agent class is an HTTP-aware agent that can be
# used in the MASH_Server.  This object contains a plain SDP_Agent
# which is used to listen for new SDP Programs and return the current
# list of Programs.
#
Class HTTP_Agent/SDP_Agent -superclass HTTP_Agent

HTTP_Agent/SDP_Agent public init { } {
    # This doesn't belong here,
    # but is necessary for AnnounceListenManager/SAP/Nsdr
    $self add_default sapTTL 127
    #

    $self next
    $self instvar agent_
    set agent_ [new SDP_Agent]
    set zone [new ScopeZone 224.2.128.0/17]
    new ProgramSource/SAP $agent_ $zone
}


#
# The handle_request method is called by the MASH_Server when an
# HTTP request is received.  This method checks for the "magic URLs"
# it cares about and returns the corresponding page.
#
HTTP_Agent/SDP_Agent instproc handle_request { url key source reply_var } {
    upvar $reply_var reply
    $self instvar list_
    mtrace trcNet "-> SDP_Agent::handle_request called"

    set page ""
    set status 200
    set type "text/html"

    # Check for the "magic" URLs.
    if { $url == "/live-list.html" } {
	mtrace trcNet "-> SDP Announcements page requested"
	set page [$self get_page sessions_list]

    } elseif { $url == "/live-desc" } {
	mtrace trcNet "-> SDP Description requested"
#	$self update_agent_list
#	array set desc_array $list_
#	set msg $desc_array($key)
#	set page [$self get_desc_page $msg sessions]
	set page [$self get_desc_page $key sessions]
#	set page [$self edit_html $page]

    } elseif { $url == "/view" } {
	    mtrace trcNet "-> View Session requested"
	    $self update_agent_list
	    array set desc_array $list_
	    set msg_str [$desc_array($key) obj2str]

#	set page $msg_str
#	set type "application/x-sd"

	    set argv [list -sdp $msg_str]
	    set page [$self create_collaborator_mashlet $argv]
	    set type "x-mash/x-script"
    } elseif { $url == "/asview" } {
	    mtrace trcNet "-> Assisted View Session requested"
	    $self update_agent_list
	    array set desc_array $list_
	    set msg_str [$desc_array($key) obj2str]

#	set page $msg_str
#	set type "application/x-sd"

	    set megafor [$self get_option megafor]
	    set argv [list -sdp $msg_str -usemega -unicast $megafor]
	    set page [$self create_collaborator_mashlet $argv]
	    set type "x-mash/x-script"
    } elseif { $url == "/prefs.mash" } {
	    # FIXME: do this here, for now

	    set mashlet_dir [$self get_option mashlet_dir]
	    if { $mashlet_dir == "" } {
		    # create a default url (relative to the host on which
		    # mash_server is being run) for use by the
		    # TCLCL_IMPORT_DIRS environment variable
		    set server_port [$self get_option server_port]
		    global mash
		    set mashlet_dir "http://[localaddr]:$server_port/$mash(version)"
	    }

	    set page "
		    . configure -bg \#FFFFFF
		    label .label -text {Please wait while mashlets are imported} -bg \#FFFFFF
		    pack .label -fill both -expand 1
		    update
		    set env(TCLCL_IMPORT_DIRS) $mashlet_dir
		    set x 0; import PathFinderPrefs
		    destroy .label
		    PathFinderPrefs .f
		    pack .f -padx 5 -pady 5 -anchor nw
	    "
	    set type "x-mash/x-script"
    }

    if { $page != {} } {
	    set reply(headers) [list content-type $type]
	    set reply(data)    $page
	    set reply(status)  $status
	    return 1
    } else {
	    return 0
    }
}

