/*
 * ns-map.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "srmv2.h"
#include "ns-map.h"
#include "ns-srmv2.h"
#include <math.h>
#include <limits.h>

/*
 * Initialize name->cid and cid->name tables.
 */
NameMap::NameMap() : prio_(0)
{
	int created = 0;
	nodes_ = new Tcl_HashTable;
	for (int i = 0; i < MAXNAMES; i ++)
		names_[i] = 0;
	Tcl_InitHashTable(nodes_, TCL_STRING_KEYS);

	namespace_ = new SRMv2_NameSpace(this);

	insert("/", namespace_->root());
	unsigned int mapid = calloc(0, "map", &created);

	/* Register the lengths of "/"  & "/map" */
	getnode(getname(mapid))->regadu(0, 2);
	getnode(getname(mapid))->regadu(1, 5);
	getnode(getname(mapid))->set_edge(2, 0); /* Advance 'expected_' to (2, 0). */
	init_prio();
}

/*
 * Return an NS_Node* from an ASCII name.
 */
NS_Node *
NameMap::getnode(char *name)
{
	if (name != 0) {
		Tcl_HashEntry *eptr = Tcl_FindHashEntry(nodes_, name);

		if (eptr)
			return (NS_Node*) Tcl_GetHashValue(eptr);
	}
	return (NS_Node*) 0;
}

/*
 * Return a container ID from an ASCII name.
 */
int
NameMap::getcid(char *name)
{
	NS_Node *node;
	node = getnode(name);
	if (node)
		return node->getcid();
	return -1;
}

unsigned int
NameMap::calloc(unsigned int parent, const char *relname, int *created,
		unsigned int cid)
{
	int len = strlen(getname(parent)) + strlen(relname) + 1;
	char *nm = new char[len];
	strcpy(nm, getname(parent));
	if (strcmp(nm, "/")) {
		strcat(nm, "/");
	}
	strcat(nm, relname);
	NS_Node* node = getnode(nm);
	if (!node)
		node = namespace_->calloc(parent, created, cid);
	unsigned int id = insert(nm, node);
	return id;
}


/*
 * Called by the receiver that gets new Map data
 */
unsigned int
NameMap::copen(const char *absname, unsigned int cid)
{
	NS_Node *node;
	char    *component;
	unsigned int id, pid;
	int created;

	if (absname == 0 || absname[0] != '/')
		return SRMv2_ERROR;

	char *cpy = new char [strlen(absname) + 2];
	strcpy(cpy, "/");
	strcat(cpy, absname);
	char *p = cpy;

	char *path   = new char[strlen(absname) + 3];
	char *parent = new char[strlen(absname) + 3];
	strcpy(path, "");
	strcpy(parent, "/");

        while (component = strtok(p, "/")) {
                p = NULL;
		strcat(path, "/");
		strcat(path, component);
		if (strlen(component) > 0) {
			if (node = getnode(path)) {
				if (parent[strlen(parent) - 1] != '/')
					strcat(parent, "/");
				strcat(parent, component);
				continue;
			}
			pid = getcid(parent);
			node = namespace_->calloc(pid, &created, cid);
                        id = insert(path, node);
		}
		if (parent[strlen(parent) - 1] != '/')
			strcat(parent, "/");
		strcat(parent, component);
	}
	delete path;
	delete parent;
	delete cpy;
	return id;
}


/*
 * Insert an NS_Node into the NameMap.
 */
unsigned int
NameMap::insert(char *name, NS_Node *node)
{
	Tcl_HashEntry *eptr = Tcl_FindHashEntry(nodes_, name);
	int created = 0;
	int id = node->getcid();

	if (!eptr) {
		eptr = Tcl_CreateHashEntry(nodes_, name, &created);
		Tcl_SetHashValue(eptr, (unsigned int) node);
		names_[id] = new char[strlen(name)+1];
		strcpy(names_[id], name);
	} else {
		if (strcmp(names_[id], name))
			printf("would overwrite %s at %d with %s; ignored\n",
			       names_[id], id, name);
	}

	return id;
}

/*
 * This is necessary only for sources for which we send SRMv2_ANNOUNCE
 * messages. Should be invoked explicity, for other SRMv2_Source
 * objects, prio_ is unused.
 */
void
NameMap::init_prio()
{
	prio_ = new activity[MAXNAMES];
	for (int i=0; i<MAXNAMES; i++) {
		prio_[i].tix = SRMv2_INIT_PRIO;
		prio_[i].hot = SRMv2_UNUSED;
		prio_[i].selected = 0;
	}
}
void
NameMap::update_prio(unsigned int cid)
{
	if (prio_[cid].tix < 2 * SRMv2_INIT_PRIO)
		prio_[cid].tix = 2 * SRMv2_INIT_PRIO;
	prio_[cid].hot = SRMv2_HOT;
	prio_[cid].selected = 0;
}

/*
 * Generate the k (= 'count') highest "lottery winners".
 * Do this probabilistically, so that there's no starvation.
 * Coupon collecting analysis shows that we need on the average about
 * count*log(count) random numbers to get 'count' distinct winners.
 */
srmv2_announcehdr*
NameMap::hiprio(unsigned int count)
{
	srmv2_announcehdr* reclist = new srmv2_announcehdr[count];
	unsigned int i, j, k, total = 0;
	unsigned int success = 0;
	if (!prio_) return 0;
	/* If there's room to send all containers do so */
//	printf("Total containers %d\n", namespace_->cid());
	if (count > namespace_->cid()) {
		for (j = 0; j < namespace_->cid(); j++) {
//			printf(" TIX[%d] = %d\n", j, prio_[j].tix);
			if (prio_[j].tix) {
				build_record(&reclist[success++], j);
				prio_[j].tix = SRMv2_INIT_PRIO;
			}
		}
		for (j = success; j < count; j++) {
			reclist[j].cid = SRMv2_ERROR;
			reclist[j].sign = SRMv2_ERROR;
			reclist[j].ebytes = SRMv2_ERROR;
		}
		return reclist;
	}
	float* winner = new float[count*count];
	success = 0;
	while (count) {
		total = 0;
		for (i=0; (i<MAXNAMES) && (prio_[i].selected == 0); i++)
			total += prio_[i].tix;
		for (i=0; i < count*count; i++)
			winner[i] = total * (double)random()/double(INT_MAX);
		sort_prio(winner, count*count);
		i = 0, j = 0, total = 0;
		while (j < MAXNAMES && i < count*count) {
			/* winner should catch up to total */
			while (winner[i] < total) {
				i++;
				continue;
			}
			if (!prio_[j].selected && winner[i] < total + prio_[j].tix) {
				prio_[j].selected = 1;
				build_record(&reclist[success++], j);
				/*
				 * Re-initialize priority, now that we've
				 * selected this container
				 */
				prio_[j].tix = SRMv2_INIT_PRIO;
				total += prio_[j++].tix;
				if (success == count) {
					for (k = 0; k < MAXNAMES; k++)
						prio_[k].selected = 0;
					delete [] winner;
					return reclist;
				}
			}
			/* total should catch up to winner */
			if (!prio_[j].selected && total + prio_[j].tix < winner[i]) {
				total += prio_[j].tix;
				prio_[j].tix ++; /* additively increase prio if we  pass this container */
			}
		}
		count -= success;
	}
	// FIXME Suchi, what do we do here?
	abort();
	return (0);
}

void
NameMap::sort_prio(float* a, int sz)
{
	int i, j;
	float temp;

	for (i = 1; i < sz; i++) {
		j = i;
		temp = a[j];
		while (j > 0 && a[j-1] > temp) {
			a[j] = a[j-1];
			j--;
		}
		a[j] = temp;
	}
}

void
NameMap::build_record(srmv2_announcehdr *sh, unsigned int cid)
{
	NS_Node* nd = getnode(getname(cid));
	sh->cid = cid;
	sh->sign = nd->signature()->adu;
	sh->ebytes = nd->signature()->byte;
//	printf("BR %4d : %d %d \n", cid, sh->sign, sh->ebytes);
}

void
NameMap::regadu(unsigned int cid, unsigned int seqno, unsigned int ebytes)
{
	NS_Node* nd = getnode(getname(cid));
	nd->regadu(seqno, ebytes);
}

