/*
 * session-srm.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* 	$Id: session-srm.h,v 1.21 2002/02/03 04:16:51 lim Exp $	 */

#ifndef srm_sessioh_h
#define srm_sessioh_h

#include "net.h"
#include "srm.h"
#include "transmitter-srm.h"
#include "timer.h"
#include "mtrace.h"
#include "appmgr-srm.h"
#include "pktbuf-srm.h"

#ifndef MASH_ASSERT_H
#define MASH_ASSERT_H
#include <assert.h>
#endif

#define KBps    16
#define MAX_BURST_SIZE 2048

#define NOT_BUSY 0
#define ERR_BUSY 1
#define ERR_TOO_BIG 2


/* Constants returned by SRM_Request::delay_est() */
#define NOT_FOUND -1

class SRM_Source;
class SRM_AppMgr;
class SRM_Request;
class SRM_Reply;
class SRM_Session;

/* ntptime is in units of 2^{-16} = 1/65535 sec */
inline float ntp2msec(u_int32_t ntptime)
{
        // REVIEW: there should be a non floating point way to do this
        return (float)((ntptime >> 16)*1000.0 + (ntptime&0xffff)/65.536);
}

/* ntptime is in *2^{-16} sec */
inline float ntp2msec(float ntptime)
{
        // REVIEW: there should be a non floating point way to do this
        return (float)(ntptime*1000.0/65536.0);
}

struct SRM_delayInfo {
        float delay;            // milisec
        float t2m1;             // (t2 - t1) * 2^{-16} sec
};

class SA_Timer: public Timer, public TclObject {
public:
    SA_Timer(int period = 3000);
    // Default period for announcements is 3 seconds
    ~SA_Timer();
    void timeout();
    int command(int argc, const char*const* argv);
    void session(SRM_Session *ss) { ss_ = ss; }
protected:
    int period_;
    SRM_Session *ss_;
    u_char sn_;
};


class SRM_Session : public SRM_Transmitter, public SessionHandler {
public:
    SRM_Session();
    ~SRM_Session();
    int command(int argc, const char*const* argv);
    void recv(CtrlHandler*);
    void recv(DataHandler*);
    void announce(CtrlHandler*);
    int begin_xmit(int len);
    inline SRM_SourceManager *source_manager() {
	return sm_;
    }
    virtual void transmit(pktbuf* pb);
    void parse_ctrl(u_char *, int);
    void sched_request(SRM_Request *sr, const srm_src& ss);
    void sched_reply(SRM_Reply *sr, const srm_src& ss);
    void fill_cname(pktbuf *pkt, SRM_Source *local);

    SRM_BufferPool *pool() { return pool_;};
    SRM_AppMgr *app_manager() {return appmgr_;};
    SA_Timer   *sa_timer() { return sa_timer_; }
    pktbuf* alloc() { return pool_->alloc(); };
    void release(pktbuf *pb) { pool_->release(pb); }
    void sethdr(pktbuf *pb, const srm_src &id, u_int16_t pkt_type) {
	pool_->sethdr(pb, id, pkt_type);
    }

    static SRM_Session *instance_; /* FIXME: used to that each SRM_Request
				      does not have to store the instance
				      pointer. Does that really matter? */

    void update_delay(const srm_src& srcId, u_int32_t tsend, u_int32_t nElt,
                      srm_dinfo* arDInfo);
    float delay_est(const srm_src& src);
    void fill_SA(pktbuf* pb);

#ifdef SRM_DEBUG
    void describeSA(FILE* of, pktbuf* pb);
#endif
    // returns rand [ c1*d[~], (c1+c2)d[~] ]
    double request_time(const srm_src& rqt_tgt);
    // returns rand [ d1*d[~], (d1+d2)d[~] ]
    double reply_time(const srm_src& rpy_tgt);

protected:
    short min_delay_;
    short min_reply_;
    short min_request_;

protected:
    /* delay parameters */
    float c1_;
    float c2_;
    float d1_;
    float d2_;
    void demux(pktbuf*, u_int32_t addr);
    //u_int32_t alloc_srcid(u_int32_t addr) const;
    void timeout();
    int send_ADU(pktbuf *pb, const srm_src &id, int type);
    double gettime();

    int mtu_;
    int avbl_bw_;
    double bkt_size_;
    double ps_inst_;

    int badversion_;
    int badoptions_;
    int badpacket_;
    int badext_;
    int nrunt_;


    DataHandler dh_;
    CtrlHandler ch_;
    SRM_BufferPool* pool_;
    u_char *pktbuf_;
    SRM_AppMgr *appmgr_;
    SA_Timer *sa_timer_;
    pktbuf *pb_;

    // Added session announcement timer
    //        SA_Timer satimer_;
    Tcl_HashTable* phtDelays_;
};

/*
 * SRM_Request::SRM_Request
 * To cancel this timer, the application has to do
 * SRM_Request::cancel(), this is provided by Timer
 */
class SRM_Request : public Timer {
public:
    SRM_Request();
    virtual ~SRM_Request(){
	if (pb_!=NULL) SRM_Session::instance_->release(pb_);
        Timer::cancel();
    };
    //static void Init();
    virtual void fill(const srm_src& ss);
    //virtual void fill_hdr(const srm_src& ss);
    /*
     * Defined by the application
     * Returns the length so that it can be
     * used in the len field.
     */
    virtual int fill_ADU() {
	assert(0 && "the app must define its own fill_ADU");
	return 0;
    }

    void cancel() {
	isDone_ = 1;
    }
    void set_source(const srm_src &src) { localSrc_ = src; }
    void set_tgt(const srm_src &tgt) { tgt_ = tgt; }
    void msched(int ms) {
        MTrace(trcSRM, ("(%x) rqt/rpy sched at %d", this, ms));
        if (!isDone_) {
            Timer::cancel();
            Timer::msched(ms);
        }
    }
    // doubles the multiplier, sets ignore_backoff_ and reschedule
    int backoff();
    // just doubles the multiplier
    void doubleMult();

protected:
    int isDone_;
    srm_src localSrc_;
    srm_src tgt_;               // tgt of reply request
    virtual void timeout();
    virtual double newtime();

    pktbuf *pb_;
    int multiplier_;

    /*
     * Application fills this in. When the destructor
     * is invoked, this object is also removed.
     * This is allolcated by SRM.
     */

private:
    double ignore_backoff_;
};

class SRM_Reply : public SRM_Request {
public:

    SRM_Reply();
    /*
     * Same function as the constructor for
     * the base class.
     */
    virtual ~SRM_Reply(){Timer::cancel(); };
    /*
     * Simply invoke the destructor of the
     * base class, default behavior
     */
    virtual void fill(const srm_src& ss);
    //void fill_hdr(const srm_src& ss);
    /*
     * Defined by the application
     * Returns the length so that it can be
     * used in the len field.
     */
    virtual const srm_src& origSId() {
       /* FIXME: this is wrong! But done this way so that the other apps can compile */
       return localSrc_;
    }
    double reply_done();
    virtual void timeout();
    /* sanity check */
    int backoff() { assert(0); return 0; }

protected:
    virtual double newtime();

    int ignore_;
};

#endif

