/*
 * rep-xcoder-jpegcompressed2uncompressed.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "inet.h"
#include "rtp.h"
#include "rep-decoder.h"
#include "bsd-endian.h"
#include "tclcl.h"
#include "jpeg/jpeg.h"
#include "renderer.h"
#include "pktbuf.h"
#include "vidreps.h"

class JpegToUncompressedRepXcoder : public TclObject {

public:
  JpegToUncompressedRepXcoder();
  virtual ~JpegToUncompressedRepXcoder();
  virtual int command(int argc, const char*const* argv);
  void xcode(JPEGCompressed *jframe);
  void set_frame_buffer(VidRep *fb) {
    output_ = (Uncompressed *) fb;
  };

protected:
  int inq_;		/* input quantization */
  int decimation_;
  int inw_;
  int inh_;

  u_char *rvts_;

  void configure();
  void resize(int inw, int inh);
  JpegPixelDecoder* codec_;
  JpegDecoder::config config_;
  Uncompressed *output_;
};

static class JpegToUncompressedRepXcoderClass : public TclClass {
public:
  JpegToUncompressedRepXcoderClass() : TclClass("Module/VideoXcoder/JPEGCompressedToUncompressed") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new JpegToUncompressedRepXcoder());
  }
} swd_jpeg_to_uncompressed_xcoder_;

JpegToUncompressedRepXcoder::JpegToUncompressedRepXcoder()
  : rvts_(0), codec_(0)
{
  JpegDecoder::defaults(config_);

  inq_ = 0;
  /* guess type 0 */
  decimation_ = 422;
  output_ = 0;
}

JpegToUncompressedRepXcoder::~JpegToUncompressedRepXcoder()
{
  delete codec_;
}

int
JpegToUncompressedRepXcoder::command(int argc, const char*const* argv)
{
  if (argc == 3) {
    if (strcmp(argv[1], "set_frame_buffer") == 0) {
      output_ = (Uncompressed *) TclObject::lookup(argv[2]);
      return TCL_OK;
    }
    if (strcmp(argv[1], "transcode") == 0) {
      JPEGCompressed *in_frame;

      in_frame = (JPEGCompressed *) TclObject::lookup(argv[2]);
      if (in_frame != 0) {
	xcode(in_frame);
      }
      return TCL_OK;
    }
  }
  return (TclObject::command(argc, argv));
}

void JpegToUncompressedRepXcoder::configure()
{
  config_.comp[0].hsf = 2;
  if (decimation_ == 411) {
    config_.comp[0].vsf = 2;
  } else {
    config_.comp[0].vsf = 1;
  }
  config_.comp[1].hsf = 1;
  config_.comp[1].vsf = 1;
  config_.comp[2].hsf = 1;
  config_.comp[2].vsf = 1;
  config_.width = inw_;
  config_.height = inh_;
  JpegDecoder::quantizer(config_, inq_);

  if (codec_ != 0)
    delete codec_;

  codec_ = JpegPixelDecoder::create(config_, inw_, inh_);

  /*
   * If we have been given name of Uncompressed object
   * to put result in, set up byte images correctly.
   */
  if (output_ != 0) {
    u_char* frm = codec_->frame();
    int off = inw_ * inh_;

    if (decimation_ == 411) {
      output_->init(inw_, inh_, 2, 2, inw_, inh_, 0, 0, frm,
		    frm + off, frm + off + (off >> 2));
    } else {
      output_->init(inw_, inh_, 2, 1, inw_, inh_, 0, 0, frm,
		    frm + off, frm + off + (off >> 1));
    }
  }

  int q;
  q = JpegDecoder::q_to_thresh(inq_);
  codec_->thresh(q);

#ifdef notyet
  Tcl& tcl = Tcl::instance();
  int ct = atoi(tcl.attr("softJPEGcthresh"));
#else
  int ct = 6;
#endif

  codec_->cthresh(ct);
}

void JpegToUncompressedRepXcoder::resize(int inw, int inh) {
  rvts_ = new u_char[(inw*inh)/64];
  inw_ = inw;
  inh_ = inh;
}

void JpegToUncompressedRepXcoder::xcode(JPEGCompressed* in_frame)
{
  int needConfig = 0;
  int in_decimation;

  if (in_frame->v_subsample_ == 1) {
    in_decimation = 422;
  } else {
    in_decimation = 411;
  }

  if (in_frame->q_ != inq_ || in_decimation != decimation_) {
    decimation_ = in_decimation;
    inq_ = in_frame->q_;
    needConfig = 1;
  }
  int inw = in_frame->w_;
  int inh = in_frame->h_;
  if (inw_ !=  inw || inh_ != inh) {
    resize(inw, inh);
    needConfig = 1;
  }
  if (needConfig)
    configure();

  if (output_ != 0) {
    output_->ts_ = in_frame->ts_;
    output_->ssrc_ = in_frame->ssrc_;

    codec_->decode(in_frame->bp_, in_frame->len_, rvts_, 0);
    codec_->resetndblk();
  }
}

