/*
 * mb-obj.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-obj.h,v 1.23 2002/02/03 03:16:30 lim Exp $
 */

#ifndef MASH_MB_OBJ_H__
#define MASH_MB_OBJ_H__

#include "tclcl.h"
#ifndef WIN32
#   include <sys/time.h>
#endif
#include "pktbuf.h"
#include "appmgr-srm.h"
#include "srm/source-srm.h"
#include "mb/mb.h"
#include "mb/mb-pkt.h"
#include "mb/array.h"
#include "mb/stack.h"
#include "misc/linkedlist.h"


class MBBaseMgr;
class MBBaseRcvr;
class MBPageObject;
class MBRequest;
class MBReply;
class MBCmd;


class MBBaseRcvr : public SRM_PacketHandler {
public:
	MBBaseRcvr(MBBaseMgr *pMgr, const SrcId &srcId);
	virtual ~MBBaseRcvr();

	virtual int executeCmd(MBCmd *pCmd, MBPageObject *pPage,
			       const MBTime& oldTime, const MBTime& newTime)=0;
	virtual int handleCmd(MBCmd *pCmd, MBPageObject *pPage,
			      const MBTime& oldTime, const MBTime& newTime);

	virtual void HandleSA(Pkt_PgStatus* aStats, int numStats);
	virtual int  FillSA(Byte *pb, int len);
	void HandleRequest(const SrcId& sid, Pkt_request *pPkt);
	void HandleReply(Byte* pb, u_int len);

	// fills the next ADU into pktbuf
	int NextADU(Byte *pb, u_int len, int& nextSize, MBPageObject
		    *pPage=NULL);

	const SrcId& getSrcId() const { return sid_; }
	SRM_Source* getSrc() const;
	MBBaseMgr *getMgr() { return pMgr_; }

#ifdef MB_DEBUG
	void Dump(int dumptype, Tcl_Obj* pObj);
#endif

protected:
	Tcl_HashTable *getPagesHT() const { return phtPages_; }
	virtual MBPageObject *DefinePage(const PageId &pageId, Bool
					 *newFlag=NULL);

	virtual void recvCommands(Byte *pb, u_int len, Bool isReply);
	virtual void recv(Byte *pb, u_int len);
	// REVIEW: SRM should use unsigned...
	virtual void recv(Byte *pb, int len) { recv(pb,(u_int)len); }

private:
	MBBaseMgr *pMgr_;
	SrcId sid_;
protected:
	Tcl_HashTable *phtPages_;
};







// there is one MBPageObject per page per receiver
// Note that each PageObject manages the portion of a "real page" that
//    belongs to one receiver. The actual page will contain
//    information in all PageObjects in all receivers.
class MBPageObject {
public:
	MBPageObject(MBBaseMgr *pMgr, const PageId &pgid);
	virtual ~MBPageObject();

	void HandleRequest(const SrcId &sidReqSrc, const SrcId &sidReqTgt,
			   ulong snStart, ulong snEnd);
	void  SchedRequest(const SrcId &srcId);
	void  UpdateRequest(ulong& snStart, ulong& snEnd);
	void  CancelRequest(MBRequest* pRequest);
	void  CancelReply(MBReply* pReply);
	void  SuppressReplies(const SrcId& origSrc, ulong snStart,
			      ulong snEnd);
	ulong FillReply(int& outlen, Byte *pb, u_int len, ulong
			snStart,ulong snEnd);
	void  FillStatus(Pkt_PgStatus& pktStat);
	// returns the number of bytes fill in
	int   NextADU(Byte *pb, u_int len, int& nextSize);

	void  UpdateDeferred(const MBTime& t);
	void  FlushDeferred(MBBaseRcvr *pRcvr);
	Bool  Update(const SrcId &srcId, ulong maxSn);
	void  UpdateRequest(const SrcId &srcId, ulong startSn, ulong endSn);

	Bool  HasCmd(ulong seqno) { return (aCmds_[seqno]!=NULL); }
	MBCmd *getCmd(ulong seqno){ return (aCmds_[seqno]); }

	// returns the Page ID
	const PageId& getId() { return id_ ; }
	ulong getMaxSeqno() const { return maxCmdSeqno_; }
	ulong getNewSeqno() { return ++maxCmdSeqno_ ; }
	ulong getTopReceived() const { return topReceived_; }

	// returns the number of bytes to be sent next
	int RequestSendAmount();

	void ChangeName(const char* szNewName) {
		delete szName_;
		::AllocNCopy(&szName_ , szNewName);
	}
	void SetLastSent(ulong lastSent) {
		if (lastSent_ < lastSent) lastSent_ = lastSent;
	}

	void  AddCmd(MBCmd *pCmd, int overwrite=0);
	void  Defer(MBCmd *pCmd);
	const MBTime& targetTime() const { return targetTime_; }
	void targetTime(const MBTime& t) { targetTime_ = t; }

#ifdef MB_DEBUG
	virtual void Dump(int dumptype, Tcl_Obj* pObj);
	void DumpTS(Tcl_Obj* pObj);
#endif

protected:
	MBRequest *getRequest() { return pRequest_; }
	MBTime targetTime_;

private:
	// pointer to the manager object
	MBBaseMgr *pMgr_;

	// name and id of the page
	char   *szName_;
	PageId id_ ;

	MBRequest     *pRequest_;	// pointer to THE repair request sent
	List<MBReply> lReplies_;	// list of repair replies sent

	// current maximum id for cmds, note: we use seqno to identify
	// items too
	ulong maxCmdSeqno_;
	ulong topReceived_;		// high water mark of filled commands
	ulong lastSent_;		// last sequence number of
					// command sent out
                                        // only makes sense for local pages
	// dynamic array of commands
	MBArray<MBCmd*> aCmds_;
	static int stepSize_;
	List<MBCmd> deferredList_;
};





class MBRequest : public SRM_Request {
public:
	MBRequest(const SrcId& srcId, MBPageObject* pPage,
		  ulong snStart, ulong snEnd)
		: SRM_Request(),
		  snStart_(snStart), snEnd_(snEnd), srcId_(srcId),
		  pPage_(pPage), numtimes_(0) {
		assert(snStart_ <= snEnd_);
	}

	virtual ~MBRequest() { MBLOG(("cancel %x", this)); }
	int fill_ADU(Byte* pb, int len);
	virtual int fill_ADU() {
		// REVIEW: get the len right!
		return fill_ADU(pb_->data+sizeof(srmhdr), SRM_MTU);
	}

	ulong getStart() { return snStart_; }
	ulong getEnd  () { return snEnd_; }
	void  SetStart(ulong snStart) { snStart_ = snStart; }
	void  SetEnd  (ulong snEnd  ) { snEnd_   = snEnd;   }

	const PageId& PgId();
	void describe(char* szDesc, u_int len);

	Bool CheckActive() { return (snStart_<= snEnd_); }
	Bool CheckOverlap(ulong snStart, ulong snEnd) {
		return (snStart_<=snEnd && snStart<=snEnd_);
	}

private:
	ulong        snStart_;
	ulong        snEnd_;
	SrcId        srcId_;
	MBPageObject *pPage_;
	int          numtimes_;
};



class MBReply : public SRM_Reply {
public:
	MBReply(const SrcId& origSId, MBPageObject *pPage,
		ulong snStart, ulong snEnd)
		: SRM_Reply(),  origStart_(snStart), origEnd_(snEnd),
		  snStart_(snStart), snEnd_(snEnd), pPage_(pPage),
		  origSId_(origSId) {
		assert(snStart_ <= snEnd_);
	}
	virtual ~MBReply() { MBLOG(("cancel %x", this)); }

	Bool CheckOverlap(ulong snStart, ulong snEnd) {
		return (snStart_<=snEnd && snStart<=snEnd_);
	}
	Bool OverlapOrig(ulong snStart, ulong snEnd) {
		/*REVIEW: this is ugly and should be avoidable */
		return (origStart_<=snEnd && snStart<=origEnd_);
	}

	// reduce to the difference
	// returns -1 if not overlapping
	// returns  0 if overlapping but shrunked range is null
	// returns  1 if overlapping but shrunked range is not null
	int Shrunk(ulong snStart, ulong snEnd) {
		if (CheckOverlap(snStart, snEnd)) {
			// do nothing if it is a proper subset
			if (snStart > snStart_ && snEnd < snEnd_) return 1;
			if (snStart<=snStart_) {
				// we know snEnd >= snStart_ =>
				// advance the start
				snStart_ = snEnd+1;
			}
			if (snEnd >= snEnd_) {
				// we know snStart <= snEnd_ => move
				// back the end
				snEnd_ = snStart-1;
			}
			return (snStart_<=snEnd_);
		} else {
			return -1;
		}
	}

	virtual int fill_ADU() {
		// REVIEW: get the len right!
		return fill_ADU(pb_->data+sizeof(srmhdr), SRM_MTU);
	}

	// fills as much as possible, shrunk itself after that
	int fill_ADU(Byte* pb, int len);
	void describe(char* szDesc, u_int len, ulong snStart, ulong snEnd);
	virtual const SrcId& origSId() { return origSId_; }

private:
	ulong        origStart_;
	ulong        origEnd_;
	ulong        snStart_;
	ulong        snEnd_;
	MBPageObject *pPage_;
	SrcId        origSId_;
};



class MBBaseMgr : public SRM_AppMgr {
public:
	MBBaseMgr();
	virtual ~MBBaseMgr();

	virtual SRM_PacketHandler *new_source(const srm_src &sid, int islocal);
	virtual int periodic_update(u_char *buf);
	/*virtual int next_ADU(u_char *db, int len, srm_src &id, int &pkt_type,
	  int &next);*/
	virtual void handle_request(const SrcId& sid, Byte *pb, int len);
	virtual void handle_reply(const SrcId& sid, Byte *pb, int len);
	virtual void handle_SA(Byte *pb, u_int len);
	/* REVIEW: srm should change to u_int */
	virtual void handle_SA(Byte *pb, int len) {
		handle_SA(pb,(u_int)len);
	}

	virtual Bool isVisible(const PageId &pgId)=0;

	virtual void activity(MBPageObject *pPage, MBCmd* pCmd)=0;

	virtual void notifyCurrPage(const SrcId& /*srcId*/,
                                    const PageId& /*pgId*/) {}


	void SchedRequest(MBRequest* pRequest, const SrcId& sid ) {
		char szDesc[200];
		pRequest->describe(szDesc, 200);
		MBLOG(("shd %s", szDesc));
		session()->sched_request(pRequest, sid);
	}
	void SchedReply(MBReply* pReply, const SrcId &sid) {
		MBLOG(("shd rpy (%x) to %s", pReply, intoa(sid.ss_addr)));
		session()->sched_reply(pReply, sid);
	}
	void RequestSA(MBBaseRcvr *pRcvr);
	// caller tells manager that it has len bytes ready to be sent
	RetCode RequestSend(int len) {
		if (len) return session()->begin_xmit(len);
		return 0;
	}

	MBPageObject *DefinePage(const PageId &pageId);

	// checks if the corresponding receiver has such a page
	Bool FindPage(const PageId& pgid) {
		Tcl_HashEntry *pEntry =
			Tcl_FindHashEntry(phtPages_, (char*)&pgid);
		return pEntry!=NULL;
	}

	// returns the size of the maximum packet len
	static u_short getMTU() {
		// REVIEW: this should be from SRM
		return SRM_MTU - sizeof(srmhdr);
	}

	static u_short getMaxCmdSz() {
		// note: need to subtract from Pkt_Reply 'cos we have to be
		// able to send it out the command as a reply...
		return getMTU()-sizeof(Pkt_PageHdr)-sizeof(Pkt_reply);
	}

	SRM_Source* getSrc(const SrcId& srcId) {
		return session()->source_manager()->consult(srcId);
	}

	Tcl_Obj* debugObjName() {
		return pDebugObjName_;
	}

#ifdef MB_DEBUG
	void Dump(int dumptype, Tcl_Obj* pObj);
#endif

protected:
	Tcl_HashTable *getReceiversHT() const { return phtReceivers_; }
	// returns TRUE if the receiver already exists; false if it is
	// a new rcvr
	Bool AddReceiver(MBBaseRcvr *pRcvr) {
		Bool created;
		Tcl_HashEntry *newEntry =
			Tcl_CreateHashEntry(phtReceivers_,
					    (char*)&pRcvr->getSrcId(),
					    &created);
		Tcl_SetHashValue(newEntry, (ClientData) pRcvr);
		return created;
	}
	void RemoveReceiver(MBBaseRcvr *pRcvr) {
		Tcl_HashEntry *pEntry =
			Tcl_FindHashEntry(phtReceivers_,
					  (char*)&pRcvr->getSrcId());
		if (pEntry) Tcl_DeleteHashEntry(pEntry);
	}

	int command(int argc, const char*const* argv);

private:
	MBBaseRcvr *DefineReceiver(const SrcId &srcId, Bool *newFlag=NULL);

	virtual MBBaseRcvr   *NewReceiver(const SrcId &srcId, Bool isLocal)=0;
	virtual MBPageObject *NewPageObject(const PageId &pageId,
					    Bool newPage)=0;

	Tcl_HashTable *phtReceivers_;
	Tcl_HashTable *phtPages_;

	MBStack<MBBaseRcvr*> *pReqSAs_;

	Tcl_Obj* pDebugObjName_;
};



inline char* PgId2Str(const PageId& pid) {
	char* szNew = new char[3*MAX_N_LONG_CHAR+3];
	sprintf(szNew, "%lx_%lx:%lx",
		(ulong)pid.sid.ss_addr, (ulong)pid.sid.ss_uid, pid.uid);
	return szNew;
}

inline Tcl_Obj* PgId2Obj(const PageId& pid) {
	char szPgId[3*MAX_N_LONG_CHAR+3];
	sprintf(szPgId, "%lx_%lx:%lx",
		(ulong)pid.sid.ss_addr, (ulong)pid.sid.ss_uid, pid.uid);
	return Tcl_NewStringObj(szPgId, -1);
}

inline Bool Str2PgId(const char*szPgId, PageId& pgIdOut)
{
	char* szNext=NULL;
	ulong ul=strtoul(szPgId,&szNext,16);
	if (*szNext!='_') return FALSE;
	pgIdOut.sid.ss_addr = ul;

	char* szNextNext=NULL;
	ul=strtoul(szNext+1,&szNextNext,16);
	if (*szNextNext!=':') return FALSE;
	pgIdOut.sid.ss_uid = ul;

	ul=strtoul(szNextNext+1,&szNext,16);
	if (*szNext!='\0') return FALSE;
	pgIdOut.uid=ul;
	return TRUE;
}





#endif // MASH_MB_OBJ_H__
