/*
 * anm-obj.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_ANM_OBJ_CC
#define MASH_ANM_OBJ_CC

#ifndef lint
static char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/atobj/anm-obj.cc,v 1.5 2002/02/03 03:10:21 lim Exp $";
#ifndef USE
#define USE(x)
#endif
USE(rcsid);
#endif

#include "tclcl.h"
#include "float.h"

class AnmObj : public TclObject {

public:
        AnmObj(double eId, double sT = 0, double eT=DBL_MAX)
                : eId_(eId), sT_(sT), eT_(eT) {
                        isStatic_ =  (eT == DBL_MAX) ? 1 : 0;
                        bind("eId_", &eId_);
                        bind("sT_",  &sT_);
                        bind("eT_",  &eT_);
                        Tcl::instance().evalf("%s set eId_ %g", name(), eId_);
                        Tcl::instance().evalf("%s set sT_ %g", name(), sT_);
                        Tcl::instance().evalf("%s set eT_ %g", name(), eT_);
        }
        ~AnmObj() { fprintf(stderr, "~anmObj %s\n", name());  }
        virtual int command(int argc, const char*const* argv);
private:
        double eId_, sT_, eT_;
        int isStatic_;
};

const int cArgStart = 4;
static class AnmObjClass : public TclClass {
public:
        AnmObjClass() : TclClass("AnmObj") {
        }
        TclObject* create(int argc, const char*const* argv) {
                double eId, sT, eT;
                if (argc==cArgStart + 1) {
                        sscanf(argv[cArgStart], "%lg", &eId);
                        return (new AnmObj(eId));
                } else if (argc==cArgStart + 2) {
                        sscanf(argv[cArgStart], "%lg", &eId);
                        sscanf(argv[cArgStart+1], "%lg", &sT);
                        return (new AnmObj(eId, sT));
                } else if (argc==cArgStart + 3) {
                        sscanf(argv[cArgStart],"%lg", &eId);
                        sscanf(argv[cArgStart+1], "%lg", &sT);
                        sscanf(argv[cArgStart+2], "%lg", &eT);
                        return (new AnmObj(eId, sT, eT));
                } else {
                        return (TclObject *) NULL;
                }
        }
} AnmObjClass;

int AnmObj::command(int argc, const char*const* argv)
{
        Tcl& tcl = Tcl::instance();
        if (argc==2) {
                if (!strcmp(argv[1],"isStatic")) {
                        tcl.resultf("%d", isStatic_);
                        return TCL_OK;
                }
        }
        return TCL_ERROR;
}


#endif /* #ifdef MASH_ANM_OBJ_CC */
